/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\r\u0001A\r\u0011$\u0001M\u0001;\u0003\r\u0011UA)\u0004\u0003!\t\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil;", "", "()V", "Companion"}, moduleName="intellij-markdown")
public final class SequentialParserUtil {
    private static final int PUNCTUATION_MASK = 1643118592;
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil$Companion.INSTANCE;

    static {
        PUNCTUATION_MASK = 1 << 20 | 1 << 21 | 1 << 22 | 1 << 23 | 1 << 24 | 1 << 29 | 1 << 30;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aq\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t!\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KQA9!D\u0004\n\u000b%!\u0011BA\u0005\u00021\tAJ\u0001\u0007\u0003\u001a\u0007!)Q\"\u0001M\u00063\u0019Aa!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0005KAAi!D\u0004\n\u000b%!\u0011BA\u0005\u00021\tAJ\u0001\u0007\u0003\u001a\r!9Q\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0004&\u0017!AQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\u0014e\u0019\u0001BC\u0007\u00021\t)3\u0002#\u0006\u000e\u0003aE\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00155\t\u0001DA\u0013\u0011\u0011-iA!\u0003\u0002\n\u0003a\u0011\u0001tB\r\n\u0011/iq!C\u0003\n\t%\u0011\u0011\"\u0001\r\u00031\u0013AB!k\u0006\u0005\u0003\"\u000b\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil$Companion;", "", "()V", "PUNCTUATION_MASK", "", "getPUNCTUATION_MASK", "()I", "filterBlockquotes", "", "Lkotlin/Range;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "textRange", "indicesToTextRanges", "indices", "", "isPunctuation", "", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "lookup", "isWhitespace", "textRangesToIndices", "ranges"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final int getPUNCTUATION_MASK() {
            return PUNCTUATION_MASK;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Integer> textRangesToIndices(@NotNull Collection<? extends Range<Integer>> ranges) {
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            ArrayList<Integer> result = new ArrayList<Integer>();
            block0: for (Range<Integer> range : ranges) {
                int n;
                int n2 = ((Number)((Object)range.getStart())).intValue();
                if (n2 > (n = ((Number)((Object)range.getEnd())).intValue() - 1)) continue;
                while (true) {
                    void i;
                    result.add((int)i);
                    if (i == n) continue block0;
                    ++i;
                }
            }
            return CollectionsKt.sorted((Iterable)result);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Range<Integer>> indicesToTextRanges(@NotNull List<? extends Integer> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int starting = 0;
            IntRange intRange = CollectionsKt.getIndices((Collection)indices);
            int n = ((Number)intRange.getStart()).intValue();
            int n2 = ((Number)intRange.getEnd()).intValue();
            if (n <= n2) {
                while (true) {
                    void $receiver;
                    void i;
                    Collection collection = indices;
                    void var8_7 = i + true;
                    int n3 = $receiver.size();
                    if (var8_7 == n3 || ((Number)indices.get((int)i)).intValue() + 1 != ((Number)indices.get((int)(i + true))).intValue()) {
                        result.add(new IntRange(((Number)indices.get(starting)).intValue(), ((Number)indices.get((int)i)).intValue() + 1));
                        starting = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return result;
        }

        public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return c == (char)0 || Character.isSpaceChar(c) || Character.isWhitespace(c);
        }

        public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return (this.getPUNCTUATION_MASK() >> Character.getType(c) & 1) != 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Range<Integer>> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull Range<Integer> textRange) {
            Intrinsics.checkParameterIsNotNull((Object)tokensCache, (String)"tokensCache");
            Intrinsics.checkParameterIsNotNull(textRange, (String)"textRange");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int lastStart = ((Number)((Object)textRange.getStart())).intValue();
            int R = ((Number)((Object)textRange.getEnd())).intValue();
            int n = lastStart;
            int n2 = R - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (Intrinsics.areEqual((Object)new TokensCache.Iterator(tokensCache, (int)i).getType(), (Object)MarkdownTokenTypes.Companion.INSTANCE.getBLOCK_QUOTE())) {
                        if (lastStart < i) {
                            result.add(new IntRange(lastStart, (int)i));
                        }
                        lastStart = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (lastStart < R) {
                result.add(new IntRange(lastStart, R));
            }
            return result;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

