/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class AssignmentExprent
extends Exprent {
    public static final int CONDITION_NONE = -1;
    private static final String[] OPERATORS = new String[]{" += ", " -= ", " *= ", " /= ", " &= ", " |= ", " ^= ", " %= ", " <<= ", " >>= ", " >>>= "};
    private Exprent left;
    private Exprent right;
    private int condType = -1;

    public AssignmentExprent(Exprent left, Exprent right, Set<Integer> bytecodeOffsets) {
        super(2);
        this.left = left;
        this.right = right;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public VarType getExprType() {
        return this.left.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        VarType typeLeft = this.left.getExprType();
        VarType typeRight = this.right.getExprType();
        if (typeLeft.typeFamily > typeRight.typeFamily) {
            result.addMinTypeExprent(this.right, VarType.getMinTypeInFamily(typeLeft.typeFamily));
        } else if (typeLeft.typeFamily < typeRight.typeFamily) {
            result.addMinTypeExprent(this.left, typeRight);
        } else {
            result.addMinTypeExprent(this.left, VarType.getCommonSupertype(typeLeft, typeRight));
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.left);
        lst.add(this.right);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new AssignmentExprent(this.left.copy(), this.right.copy(), this.bytecode);
    }

    @Override
    public int getPrecedence() {
        return 13;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        VarType leftType = this.left.getExprType();
        VarType rightType = this.right.getExprType();
        boolean fieldInClassInit = false;
        boolean hiddenField = false;
        if (this.left.type == 5) {
            StructField fd;
            FieldExprent field = (FieldExprent)this.left;
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node != null && (fd = node.classStruct.getField(field.getName(), field.getDescriptor().descriptorString)) != null) {
                if (field.isStatic() && fd.hasModifier(16)) {
                    fieldInClassInit = true;
                }
                if (node.getWrapper() != null && node.getWrapper().getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()))) {
                    hiddenField = true;
                }
            }
        }
        if (hiddenField) {
            return new TextBuffer();
        }
        TextBuffer buffer = new TextBuffer();
        if (fieldInClassInit) {
            buffer.append(((FieldExprent)this.left).getName());
        } else {
            buffer.append(this.left.toJava(indent, tracer));
        }
        TextBuffer res = this.right.toJava(indent, tracer);
        if (this.condType == -1 && !leftType.isSuperset(rightType) && (rightType.equals(VarType.VARTYPE_OBJECT) || leftType.type != 8)) {
            if (this.right.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                res.enclose("(", ")");
            }
            res.prepend("(" + ExprProcessor.getCastTypeName(leftType) + ")");
        }
        buffer.append(this.condType == -1 ? " = " : OPERATORS[this.condType]).append(res);
        tracer.addMapping(this.bytecode);
        return buffer;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.left) {
            this.left = newExpr;
        }
        if (oldExpr == this.right) {
            this.right = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent as = (AssignmentExprent)o;
        return InterpreterUtil.equalObjects(this.left, as.getLeft()) && InterpreterUtil.equalObjects(this.right, as.getRight()) && this.condType == as.getCondType();
    }

    public Exprent getLeft() {
        return this.left;
    }

    public void setLeft(Exprent left) {
        this.left = left;
    }

    public Exprent getRight() {
        return this.right;
    }

    public void setRight(Exprent right) {
        this.right = right;
    }

    public int getCondType() {
        return this.condType;
    }

    public void setCondType(int condType) {
        this.condType = condType;
    }
}

