/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.PropertyMetadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo$filePath$1;
import org.jetbrains.builtInWebServer.PathInfo$path$1;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0006\u000b\u0005!I!B\u0001\r\u0003\u0015\tA\u0011\u0003\u0007\u00013\u0005A\n!i\u000e\n\t!\tQB\u0001G\u00011\u0007IA\u0001\u0003\u0002\u000e\u00051\u0005\u0001TA\u0005\u0004\u0011\ri\u0011\u0001'\u0002\n\u000b\u0011\t\u0001rA\u0007\u0003\u0019\u0003AB!\u0003\u0003\u0005\u0003!%Q\"\u0001\r\u0006#\u000e\t\u00012B\u0013\u0004\u0011Ki\u0011\u0001G\u0003*\u0017\u0011\u0019\u0005\u0002\u0003\u0002\u000e\u00051\u0005\u0001TA)\u0004\t\u0015\u0001QB\u0001\u0003\u0007\u0011\u001bIS\u0002B\"\t\u0011\u001di\u0011\u0001\u0007\u0003\u001dGE\u001ba!\u0002\u0002\u0005\u0012!IQB\u0001C\b\u0011!I#\u0002B\"\t\u0011'i\u0011\u0001\u0007\u0006\u001dGE\u001b1!\u0004\u0002\u0005\u0016!Y\u0011f\u0003\u0003D\u0011!\tQB\u0001G\u00011\u0007\t6\u0001B\u0003\u0001\u001b\t!9\u0002\u0003\u0007*\u0015\u0011\u0019\u0005\u0002#\u0003\u000e\u0003a)\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0002E\rS)!1\t\u0003\u0005\u000e\u001b\u0005AR\u0001H\u0012R\u0007\ri!\u0001B\u0007\t\u001a%\"Ba\u0011\u000f\t\b5\u0011A\u0012\u0001\r\u00053\u0011AY\"\u0004\u0002\r\u0002a!\u0001eI)\u0004\u000f\u0015\u0001QB\u0001\u0003\u000f\u0011!\t\"\u0001\"\b\t\u001f%RAa\u0011\u0005\t 5\t\u0001\u0004\u0002\u000f$#\u000e\u0019QB\u0001\u0003\u0011\u0011!IS\u0002B\"\t\u0011Ci\u0011\u0001\u0007\u0003\u001dGE\u001ba!\u0002\u0002\u0005$!IQB\u0001\u0003\u0012\u0011!I#\u0002B\"\t\u0011\ri\u0011\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005%!5\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/PathInfo;", "", "ioFile", "Ljava/io/File;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "moduleName", "", "isLibrary", "", "(Ljava/io/File;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Z)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "getFilePath", "()Ljava/lang/String;", "filePath$delegate", "Lkotlin/Lazy;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getIoFile", "()Ljava/io/File;", "()Z", "isValid", "<set-?>", "getModuleName", "setModuleName", "(Ljava/lang/String;)V", "name", "getName", "path", "getPath", "path$delegate", "getRoot", "isDirectory"}, moduleName="built-in-server-api")
public final class PathInfo {
    @Nullable
    private String moduleName;
    @NotNull
    private final Lazy<? extends String> path$delegate;
    @NotNull
    private final Lazy<? extends String> filePath$delegate;
    @Nullable
    private final File ioFile;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final VirtualFile root;
    private final boolean isLibrary;
    private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    @NotNull
    public final String getPath() {
        return (String)LazyKt.getValue(this.path$delegate, (Object)this, (KProperty)((KProperty)$delegatedProperties[0]));
    }

    @NotNull
    public final String getFilePath() {
        return (String)LazyKt.getValue(this.filePath$delegate, (Object)this, (KProperty)((KProperty)$delegatedProperties[1]));
    }

    public final boolean isValid() {
        boolean bl;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            bl = virtualFile.isValid();
        } else {
            bl = this.ioFile.exists();
        }
        return bl;
    }

    @NotNull
    public final String getName() {
        String string;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            string = virtualFile.getName();
        } else {
            string = this.ioFile.getName();
        }
        return string;
    }

    @NotNull
    public final FileType getFileType() {
        FileType fileType;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            fileType = virtualFile.getFileType();
        } else {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName(this.ioFile.getName());
        }
        return fileType;
    }

    public final boolean isDirectory() {
        boolean bl;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            bl = virtualFile.isDirectory();
        } else {
            bl = this.ioFile.isDirectory();
        }
        return bl;
    }

    @Nullable
    public final File getIoFile() {
        return this.ioFile;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    public final boolean isLibrary() {
        return this.isLibrary;
    }

    static {
        $delegatedProperties = new PropertyMetadata[]{(PropertyMetadata)PathInfo$path$1.INSTANCE, (PropertyMetadata)PathInfo$filePath$1.INSTANCE};
    }

    public PathInfo(@Nullable File ioFile, @Nullable VirtualFile file, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.ioFile = ioFile;
        this.file = file;
        this.root = root;
        this.isLibrary = isLibrary;
        this.moduleName = moduleName;
        this.path$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this, moduleName){
            final /* synthetic */ PathInfo this$0;
            final /* synthetic */ String $moduleName;

            @NotNull
            public final String invoke() {
                StringBuilder builder = new StringBuilder();
                if (this.$moduleName != null) {
                    builder.append(this.$moduleName).append('/');
                }
                if (this.this$0.isLibrary()) {
                    builder.append(this.this$0.getRoot().getName()).append('/');
                }
                if (this.this$0.getFile() == null) {
                    String string = this.this$0.getRoot().getPath();
                    File file = this.this$0.getIoFile();
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    builder.append(FileUtilRt.getRelativePath((String)string, (String)FileUtilRt.toSystemIndependentName((String)file.getPath()), (char)'/'));
                } else {
                    builder.append(VfsUtilCore.getRelativePath(this.this$0.getFile(), this.this$0.getRoot(), '/'));
                }
                return builder.toString();
            }
            {
                this.this$0 = pathInfo;
                this.$moduleName = string;
                super(0);
            }
        }));
        this.filePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PathInfo this$0;

            @NotNull
            public final String invoke() {
                String string;
                if (this.this$0.getIoFile() == null) {
                    VirtualFile virtualFile = this.this$0.getFile();
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    string = FileUtilRt.toSystemDependentName((String)virtualFile.getPath());
                } else {
                    string = this.this$0.getIoFile().getPath();
                }
                return string;
            }
            {
                this.this$0 = pathInfo;
                super(0);
            }
        }));
    }

    public /* synthetic */ PathInfo(File file, VirtualFile virtualFile, VirtualFile virtualFile2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(file, virtualFile, virtualFile2, string, bl);
    }
}

