/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final boolean isDirectory;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        this(fileSystem, ioFile, ioFile.isDirectory());
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "<init>"));
        }
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.isDirectory = isDirectory;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myIoFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getFileSystem"));
        }
        return coreLocalFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.myIoFile.getAbsolutePath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "getPath"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile) : null;
    }

    @Override
    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            ArrayList<CoreLocalVirtualFile> result2 = new ArrayList<CoreLocalVirtualFile>();
            File[] files = this.myIoFile.listFiles();
            if (files == null) {
                answer = EMPTY_ARRAY;
            } else {
                for (File file : files) {
                    result2.add(new CoreLocalVirtualFile(this.myFileSystem, file));
                }
                answer = result2.toArray(new VirtualFile[result2.size()]);
            }
            this.myChildren = answer;
        }
        return answer;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = FileUtil.loadFileBytes(this.myIoFile);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/local/CoreLocalVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    @Override
    public long getLength() {
        return this.myIoFile.length();
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)o;
        return this.myIoFile.equals(that.myIoFile);
    }

    public int hashCode() {
        return this.myIoFile.hashCode();
    }
}

