/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.ReturnReplacingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"u\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005A\u0001#\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u0001!SI\u0012\u0001'\u0001\u001e\u0002S\t;\u0002B\u0001\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006E\u001b\u0011\u0001C\u0002&\t\u0011\t\u0001bC\u0007\u00021/)s\u0001B\u0001\t\u00195!\u0011BA\u0005\u00021+AJ\"\n\u0003\u0005\u0003!iQ\"\u0001M\u000eK\rAa\"D\u0001\u0019\u001c\u0015:A!\u0001E\u000f\u001b\u0011I!!C\u0001\u0019\u001faeQ\u0005\u0002\u0003\u0002\u0011?i\u0011\u0001g\u0007&\u000b\u0011\t\u0001\u0002E\u0007\u0003\u0019\u0003A\n#\n\u0003\u0005\u0003!\tR\"\u0001M\u000eK!!\u0011\u0001\u0003\u0005\u000e\u0003aE\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!\n\u0003\u0005\u0003!\rR\"\u0001M\fK\u0011!\u0011\u0001\u0003\n\u000e\u0003a]Q\u0005\u0002\u0003\u0002\u0011Ki\u0011\u0001g\u0006&\t\u0011\t\u0001bE\u0007\u00021/)s\u0001B\u0001\t!5\u0011A\u0012\u0001M\u0011+\u0005A:#J\u0004\u0005\u0003!\u0001RB\u0001G\u00011C)\u0012\u0001\u0007\u000b*\u000f\u0011\t\u0005\u0002c\u0002\u000e\u0003a!\u0011kA\u0001\u0006\u0001%BA!\u0011\u000f\t\n5\u0011A\u0012\u0001\r\u0006#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S+!\u0011\t\u0003E\u0006\u001b\u0013a\t\u0001\u0007\u0004R\u0007\u0005!i!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Aq!D\u0001\u0019\u0010E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0005\u000e\u0003aE\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00135\t\u00014C)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B9!QQB\u0001G\u00011+\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator;", "", "call", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "(Lcom/google/dart/compiler/backend/js/ast/JsInvocation;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;)V", "body", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "breakLabel", "Lcom/google/dart/compiler/backend/js/ast/JsLabel;", "currentStatement", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/annotations/Nullable;", "invokedFunction", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "isResultNeeded", "", "namingContext", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "resultExpr", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "doReplaceReturns", "", "getArguments", "", "getBreakLabel", "", "getLabelPrefix", "getParameters", "Lcom/google/dart/compiler/backend/js/ast/JsParameter;", "getResultLabel", "getResultReference", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "getThisAlias", "process", "processReturns", "removeStatementsAfterTopReturn", "replaceThis", "Lcom/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "Lcom/google/dart/compiler/backend/js/ast/JsVars;", "Companion"}, moduleName="kotlin-compiler")
public final class FunctionInlineMutator {
    private final JsFunction invokedFunction;
    private final boolean isResultNeeded;
    private final NamingContext namingContext;
    private final JsBlock body;
    private JsExpression resultExpr;
    private JsLabel breakLabel;
    private final JsStatement currentStatement;
    private final JsInvocation call;
    private final InliningContext inliningContext;
    public static final Companion Companion = org.jetbrains.kotlin.js.inline.FunctionInlineMutator$Companion.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void process() {
        JsExpression jsExpression;
        List<JsExpression> arguments2 = this.getArguments();
        List<JsParameter> parameters2 = this.getParameters();
        this.replaceThis();
        RemoveDefaultInitializersKt.removeDefaultInitializers(arguments2, parameters2, this.body);
        NamingUtilsKt.aliasArgumentsIfNeeded(this.namingContext, arguments2, parameters2);
        NamingUtilsKt.renameLocalNames(this.namingContext, this.invokedFunction);
        this.removeStatementsAfterTopReturn();
        this.processReturns();
        this.namingContext.applyRenameTo(this.body);
        FunctionInlineMutator functionInlineMutator = this;
        JsExpression jsExpression2 = this.resultExpr;
        if (jsExpression2 != null) {
            void $receiver;
            JsExpression jsExpression3 = jsExpression2;
            FunctionInlineMutator functionInlineMutator2 = functionInlineMutator;
            JsExpression it = (JsExpression)$receiver;
            JsNode jsNode = this.namingContext.applyRenameTo(it);
            if (jsNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsExpression");
            }
            JsExpression jsExpression4 = (JsExpression)jsNode;
            functionInlineMutator = functionInlineMutator2;
            jsExpression = jsExpression4;
        } else {
            jsExpression = null;
        }
        functionInlineMutator.resultExpr = jsExpression;
    }

    private final void replaceThis() {
        if (!org.jetbrains.kotlin.js.inline.FunctionInlineMutator$Companion.INSTANCE.hasThisReference(this.body)) {
            return;
        }
        JsExpression thisReplacement = org.jetbrains.kotlin.js.inline.FunctionInlineMutator$Companion.INSTANCE.getThisReplacement(this.call);
        if (thisReplacement == null || thisReplacement instanceof JsLiteral.JsThisRef) {
            return;
        }
        if (SideEffectUtilsKt.needToAlias(thisReplacement)) {
            JsName thisName = this.namingContext.getFreshName(this.getThisAlias());
            this.namingContext.newVar(thisName, thisReplacement);
            thisReplacement = thisName.makeRef();
        }
        RewriteUtilsKt.replaceThisReference((JsNode)this.body, thisReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeStatementsAfterTopReturn() {
        List<JsStatement> statements = this.body.getStatements();
        Collection $receiver22 = statements;
        int $receiver22 = 0;
        int statementsSize = $receiver22.size();
        int n = statementsSize - 1;
        if ($receiver22 <= n) {
            while (true) {
                void i;
                JsStatement statement;
                if ((statement = statements.get((int)i)) instanceof JsReturn) {
                    statements.subList((int)(i + true), statementsSize).clear();
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void processReturns() {
        List<JsStatement> statements;
        JsStatement lastTopLevelStatement;
        if (this.currentStatement instanceof JsReturn && ((JsReturn)this.currentStatement).getExpression() == this.call) {
            this.inliningContext.getStatementContext().removeMe();
            return;
        }
        Collection $receiver = CollectUtilsKt.collectInstances(JsReturn.class, this.body);
        int returnCount = $receiver.size();
        if (returnCount == 0) {
            this.resultExpr = JsLiteral.UNDEFINED;
            return;
        }
        if (returnCount == 1 && (lastTopLevelStatement = (statements = this.body.getStatements()).get(CollectionsKt.getLastIndex(statements))) instanceof JsReturn) {
            this.resultExpr = ((JsReturn)lastTopLevelStatement).getExpression();
            CollectionsKt.remove(statements, CollectionsKt.getLastIndex(statements));
            return;
        }
        this.doReplaceReturns();
    }

    private final void doReplaceReturns() {
        JsNameRef resultReference = this.getResultReference();
        if (resultReference != null) {
            this.resultExpr = resultReference;
        }
        PreconditionsKt.assert(this.resultExpr == null || this.resultExpr instanceof JsNameRef);
        JsName breakName = this.namingContext.getFreshName(this.getBreakLabel());
        this.breakLabel = new JsLabel(breakName);
        JsExpression jsExpression = this.resultExpr;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        ReturnReplacingVisitor visitor2 = new ReturnReplacingVisitor((JsNameRef)jsExpression, breakName.makeRef());
        visitor2.accept((JsNode)this.body);
        List<JsStatement> statements = this.body.getStatements();
        JsStatement jsStatement = CollectionsKt.lastOrNull(statements);
        if (!(jsStatement instanceof JsBreak)) {
            jsStatement = null;
        }
        JsLabel jsLabel = this.breakLabel;
        JsBreak last = (JsBreak)jsStatement;
        SourceInfoAwareJsNode sourceInfoAwareJsNode = last;
        if ((sourceInfoAwareJsNode != null && (sourceInfoAwareJsNode = ((JsContinue)sourceInfoAwareJsNode).getLabel()) != null ? ((JsNameRef)sourceInfoAwareJsNode).getName() : null) == (jsLabel != null ? jsLabel.getName() : null)) {
            CollectionsKt.remove(statements, CollectionsKt.getLastIndex(statements));
        }
    }

    private final JsNameRef getResultReference() {
        JsNameRef existingReference;
        JsNameRef jsNameRef;
        if (!this.isResultNeeded) {
            return null;
        }
        JsStatement jsStatement = this.currentStatement;
        if (jsStatement instanceof JsExpressionStatement) {
            JsBinaryOperation expression;
            JsExpression jsExpression = ((JsExpressionStatement)this.currentStatement).getExpression();
            if (!(jsExpression instanceof JsBinaryOperation)) {
                jsExpression = null;
            }
            JsBinaryOperation jsBinaryOperation = expression = (JsBinaryOperation)jsExpression;
            jsNameRef = jsBinaryOperation != null ? this.getResultReference(jsBinaryOperation) : null;
        } else {
            jsNameRef = existingReference = jsStatement instanceof JsVars ? this.getResultReference((JsVars)this.currentStatement) : (JsNameRef)null;
        }
        if (existingReference != null) {
            return existingReference;
        }
        JsName resultName = this.namingContext.getFreshName(this.getResultLabel());
        this.namingContext.newVar(resultName, null);
        return resultName.makeRef();
    }

    private final JsNameRef getResultReference(JsBinaryOperation $receiver) {
        if ($receiver.getOperator() != JsBinaryOperator.ASG || $receiver.getArg2() != this.call) {
            return null;
        }
        JsExpression jsExpression = $receiver.getArg1();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        return (JsNameRef)jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final JsNameRef getResultReference(JsVars $receiver) {
        void receiver;
        JsVars.JsVar variable;
        block3: {
            block2: {
                void $receiver2;
                List<JsVars.JsVar> vars = $receiver.getVars();
                variable = CollectionsKt.first(vars);
                if (variable.getInitExpression() != this.call) break block2;
                Collection collection = vars;
                if ($receiver2.size() <= 1) break block3;
            }
            return null;
        }
        JsName varName = variable.getName();
        JsContext<JsStatement> $i$f$size = this.inliningContext.getStatementContext();
        JsContext $receiver3 = (JsContext)receiver;
        $receiver3.removeMe();
        $receiver3.addPrevious((JsNode)JsAstUtils.newVar(varName, null));
        return varName.makeRef();
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsExpression> getArguments() {
        List<JsExpression> arguments2 = this.call.getArguments();
        if (InvocationUtilsKt.isCallInvocation(this.call)) {
            void $receiver;
            Collection collection = arguments2;
            int n = 1;
            List<JsExpression> list = arguments2;
            int n2 = $receiver.size();
            return list.subList(n, n2);
        }
        List<JsExpression> list = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list, "arguments");
        return list;
    }

    private final boolean isResultNeeded(JsInvocation call) {
        return !(this.currentStatement instanceof JsExpressionStatement) || Intrinsics.areEqual(call, ((JsExpressionStatement)this.currentStatement).getExpression()) ^ true;
    }

    private final List<JsParameter> getParameters() {
        List<JsParameter> list = this.invokedFunction.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "invokedFunction.getParameters()");
        return list;
    }

    private final String getResultLabel() {
        return this.getLabelPrefix() + "result";
    }

    private final String getBreakLabel() {
        return this.getLabelPrefix() + "break";
    }

    private final String getThisAlias() {
        return "$this";
    }

    @NotNull
    public final String getLabelPrefix() {
        String labelPrefix;
        String ident = InvocationUtilsKt.getSimpleIdent(this.call);
        String string = ident;
        if (string == null) {
            string = labelPrefix = "inline$";
        }
        if (StringsKt.endsWith$default(labelPrefix, "$", false, 2)) {
            return labelPrefix;
        }
        return labelPrefix + "$";
    }

    private FunctionInlineMutator(JsInvocation call, InliningContext inliningContext) {
        this.call = call;
        this.inliningContext = inliningContext;
        this.currentStatement = this.inliningContext.getStatementContext().getCurrentNode();
        FunctionContext functionContext = this.inliningContext.getFunctionContext();
        this.invokedFunction = functionContext.getFunctionDefinition(this.call);
        JsBlock jsBlock = this.invokedFunction.getBody().deepCopy();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "invokedFunction.getBody().deepCopy()");
        this.body = jsBlock;
        this.isResultNeeded = this.isResultNeeded(this.call);
        this.namingContext = this.inliningContext.newNamingContext();
    }

    public /* synthetic */ FunctionInlineMutator(@NotNull JsInvocation call, @NotNull InliningContext inliningContext, DefaultConstructorMarker $constructor_marker) {
        this(call, inliningContext);
    }

    public static final /* synthetic */ void access$setBreakLabel$p(FunctionInlineMutator $this, @Nullable JsLabel jsLabel) {
        $this.breakLabel = jsLabel;
    }

    public static final /* synthetic */ void access$setResultExpr$p(FunctionInlineMutator $this, @Nullable JsExpression jsExpression) {
        $this.resultExpr = jsExpression;
    }

    @JvmStatic
    @NotNull
    public static final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        return org.jetbrains.kotlin.js.inline.FunctionInlineMutator$Companion.INSTANCE.getInlineableCallReplacement(call, inliningContext);
    }

    @JvmStatic
    public static final boolean canBeExpression(@NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        return org.jetbrains.kotlin.js.inline.FunctionInlineMutator$Companion.INSTANCE.canBeExpression(function);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0003\u0003\u0002\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K!!9\u0001c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0007\u0005\b!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\re\u0019\u0001RB\u0007\u00021\u001d)\u0013\u0002b\u0001\t\u00105\u0011A\u0012\u0001\r\t3\rAY!D\u0001\u0019\r\u0015BA!\u0001E\t\u001b\u0005A\"!G\u0002\t\u00065\t\u0001d\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/FunctionInlineMutator$Companion;", "", "()V", "canBeExpression", "", "body", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "getInlineableCallReplacement", "Lorg/jetbrains/kotlin/js/inline/InlineableResult;", "call", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "getThisReplacement", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "hasThisReference"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final InlineableResult getInlineableCallReplacement(@NotNull JsInvocation call, @NotNull InliningContext inliningContext) {
            Intrinsics.checkParameterIsNotNull(call, "call");
            Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
            FunctionInlineMutator mutator = new FunctionInlineMutator(call, inliningContext, null);
            mutator.process();
            JsStatement inlineableBody = mutator.body;
            JsLabel breakLabel = mutator.breakLabel;
            if (breakLabel != null) {
                breakLabel.setStatement(inlineableBody);
                inlineableBody = breakLabel;
            }
            return new InlineableResult(inlineableBody, mutator.resultExpr);
        }

        @JvmStatic
        private final JsExpression getThisReplacement(JsInvocation call) {
            if (InvocationUtilsKt.isCallInvocation(call)) {
                return call.getArguments().get(0);
            }
            if (InvocationUtilsKt.hasCallerQualifier(call)) {
                return InvocationUtilsKt.getCallerQualifier(call);
            }
            return null;
        }

        private final boolean hasThisReference(JsBlock body) {
            List<JsLiteral.JsThisRef> thisRefs = CollectUtilsKt.collectInstances(JsLiteral.JsThisRef.class, body);
            return !thisRefs.isEmpty();
        }

        @JvmStatic
        public final boolean canBeExpression(@NotNull JsFunction function) {
            Intrinsics.checkParameterIsNotNull(function, "function");
            JsBlock jsBlock = function.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.getBody()");
            return this.canBeExpression(jsBlock);
        }

        private final boolean canBeExpression(JsBlock body) {
            List<JsStatement> statements = body.getStatements();
            Collection $receiver = statements;
            return $receiver.size() == 1 && statements.get(0) instanceof JsReturn;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

