/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

public final class AnnotationsUtils {
    private AnnotationsUtils() {
    }

    public static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotation"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationStringParameter"));
        }
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation2);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        ConstantValue<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value2 = constant.getValue();
        assert (value2 instanceof String) : "Native function annotation should have one String parameter";
        return (String)value2;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObject"));
        }
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation2)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation2);
    }

    @Nullable
    public static String getNameForAnnotatedObjectWithOverrides(@NotNull DeclarationDescriptor declarationDescriptor) {
        List<DeclarationDescriptor> descriptors;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getNameForAnnotatedObjectWithOverrides"));
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor && DescriptorUtils.isOverride((CallableMemberDescriptor)declarationDescriptor)) {
            Set<CallableMemberDescriptor> overriddenDeclarations = DescriptorUtils.getAllOverriddenDeclarations((CallableMemberDescriptor)declarationDescriptor);
            descriptors = ContainerUtil.mapNotNull(overriddenDeclarations, new Function<CallableMemberDescriptor, DeclarationDescriptor>(){

                @Override
                public DeclarationDescriptor fun(CallableMemberDescriptor descriptor2) {
                    return DescriptorUtils.isOverride(descriptor2) ? null : descriptor2;
                }
            });
        } else {
            descriptors = ContainerUtil.newArrayList(new DeclarationDescriptor[]{declarationDescriptor});
        }
        for (DeclarationDescriptor descriptor2 : descriptors) {
            for (PredefinedAnnotation annotation2 : PredefinedAnnotation.Companion.getWITH_CUSTOM_NAME()) {
                if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
                String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, annotation2);
                return name != null ? name : descriptor2.getName().asString();
            }
        }
        return null;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return AnnotationsUtils.getAnnotationByName(descriptor2, annotation2.getFqName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "getAnnotationByName"));
        }
        return descriptor2.getAnnotations().findAnnotation(fqName2);
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isNativeObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.NATIVE);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isLibraryObject"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, PredefinedAnnotation.LIBRARY);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "isPredefinedObject"));
        }
        for (PredefinedAnnotation annotation2 : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull PredefinedAnnotation annotation2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor2, annotation2.getFqName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/utils/AnnotationsUtils", "hasAnnotationOrInsideAnnotatedClass"));
        }
        if (AnnotationsUtils.getAnnotationByName(descriptor2, fqName2) != null) {
            return true;
        }
        ClassDescriptor containingClass = DescriptorUtils.getContainingClass(descriptor2);
        return containingClass != null && AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass((DeclarationDescriptor)containingClass, fqName2);
    }
}

