/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.SequencesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"c\u0015\tA1A\u0003\u0002\u0011\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq\"B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u00035%Ca\u0011\u0003\t\u00015\u0011A\u0012\u0001S\u0001#\t!\u0001\u0001C\u0001\u0012\t\u0011\u0005\u0001\u0012A\u000b\u00021\u0007)\u0012\u0001\u0007\u0002\u001a\u0016!\u0015QbB\u0005\u0003\u0013\u0005!\u0013!\u0003\u0002\n\u0003\u0011\u0006\u0001d\u0001)\u0004\u0002e%\u0001rA\u0007\u0002I\u0005\u00016!A)\u0004\u0003!!Ak!\u0003\u000e\u001b!)Q\"\u0001M\u0006+\u0005A\"!g\u0003\t\r5\u0011A\u0012\u0001M\u0007!\u000e\u0005Ak!\u0003\u000e\u001f!9Q\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002g\u0004\u0016\u0003a5\u0011\u0014\u0002E\t\u001b\u0005A\"\u0001UB\u0001)\u000e%Q\"\u0004\u0005\n\u001b\ta\t\u0001g\u0005\u0016\u0003aQ\u0011\u0014\u0002E\t\u001b\u0005A\"\u0001UB\u0001)\u000e%Q\"\u0004E\u000b\u001b\ta\t\u0001G\u0006\u0016\u0003aQ\u0011\u0014\u0002E\t\u001b\u0005A\"\u0001UB\u0001)\u000e%Q\u0002\u0004E\f\u001b\u0005AB\"F\u0001\u0019\u000ee%\u0001\u0012C\u0007\u00021\t\u00016\u0011\u0001+\u0004\n5a\u0001\u0012D\u0007\u000211)\u0012\u0001'\u0004\u001a\n!EQ\"\u0001\r\u0003!\u000e\u0005Ak!\u0003\u000e\u0019!iQ\"\u0001\r\r+\u0005Aj!'\u0003\t\u00125\t\u0001D\u0001)\u0004\u0002Q\u001bI!\u0004\r\t\u001c5\t\u0001DD\t\b\t\u0001Ai\"\u0006\u0003\n\u0005%\tAU\u0004\r\u0010+\u0011I!!C\u0001%\u001eay\u00114\u0002\u0005\u0007\u001b\ta\t\u0001'\u0004Q\u0007\u0003!6\u0011BG\u0013\u0011?i\u0011\u0001\u0007\b\u0016\u0003a\u0001\u0012\u0014\u0002E\u0011\u001b\u0005A\u0012\u0003UB\u00013\u0017A\u0019#\u0004\u0002\r\u0002a\u0011\u0002kA\u0001U\u0007\u0013\u0001"}, strings={"get", "V", "K", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "key", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "BindingContextUtilsKt", "getDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUnreachableCode", "", "isUsedAsExpression", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;"}, moduleName="kotlin-compiler")
public final class BindingContextUtilsKt {
    @Nullable
    public static final <K, V> V get(BindingContext $receiver, @NotNull ReadOnlySlice<K, V> slice, K key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(slice, "slice");
        return $receiver.get(slice, key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(KtReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement2 = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement2 != null) {
                PsiElement $receiver3 = psiElement2;
                PsiElement it = $receiver3;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it = $receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext2 = context;
        KtDeclarationWithBody ktDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, KtDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(readOnlySlice, ktDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.sequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(KtReturnExpression $receiver, @NotNull BindingContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it = $receiver2;
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(ResolutionContext<C> $receiver, @Nullable KtExpression expression) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression == null) {
            return;
        }
        JetTypeInfo typeInfo = (JetTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(BindingTrace $receiver, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        if (element == null) {
            return;
        }
        LexicalScope scopeToRecord = ScopeUtilsKt.takeSnapshot(scope2);
        $receiver.record(BindingContext.LEXICAL_SCOPE, element, scopeToRecord);
        if (element instanceof KtExpression) {
            $receiver.record(BindingContext.RESOLUTION_SCOPE, element, ScopeUtilsKt.asJetScope(scopeToRecord));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(BindingContext $receiver, @Nullable KtExpression expression) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                object = expression;
                if (object == null) break block2;
                KtExpression $receiver2 = object;
                KtExpression it = $receiver2;
                JetTypeInfo jetTypeInfo = (JetTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it);
                object = jetTypeInfo != null ? jetTypeInfo.getDataFlowInfo() : null;
                if (object != null) break block3;
            }
            object = DataFlowInfo.EMPTY;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "expression?.let { this[B\u2026o } ?: DataFlowInfo.EMPTY");
        return object;
    }

    public static final boolean isUnreachableCode(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(KtExpression $receiver, @NotNull BindingContext context) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof KtReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        List<DeclarationDescriptor> list = targetDescriptor;
        if (list != null) {
            DeclarationDescriptor $receiver2 = list;
            DeclarationDescriptor it = $receiver2;
            list = CollectionsKt.listOf(it);
            if (list != null) {
                collection = list;
                return collection;
            }
        }
        collection = CollectionsKt.orEmpty((Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver));
        return collection;
    }
}

