/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintType;
import org.jetbrains.kotlin.types.KotlinType;

public class SubtypingConstraint {
    private final ConstraintType type;
    private final KotlinType subtype;
    private final KotlinType supertype;

    public SubtypingConstraint(@NotNull ConstraintType type2, @NotNull KotlinType subtype, @NotNull KotlinType supertype) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        this.type = type2;
        this.subtype = subtype;
        this.supertype = supertype;
    }

    @NotNull
    public KotlinType getSubtype() {
        KotlinType kotlinType = this.subtype;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "getSubtype"));
        }
        return kotlinType;
    }

    @NotNull
    public KotlinType getSupertype() {
        KotlinType kotlinType = this.supertype;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "getSupertype"));
        }
        return kotlinType;
    }

    @NotNull
    public ConstraintType getType() {
        ConstraintType constraintType = this.type;
        if (constraintType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "getType"));
        }
        return constraintType;
    }

    @NotNull
    public String getErrorMessage() {
        String string = this.type.makeErrorMessage(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/inference/SubtypingConstraint", "getErrorMessage"));
        }
        return string;
    }

    public String toString() {
        return this.getSubtype() + " :< " + this.getSupertype();
    }
}

