/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypes {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypes.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypes.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypes.getType(Throwable.class);
    public static final Type JAVA_CLASS_TYPE = AsmTypes.getType(Class.class);
    public static final Type UNIT_TYPE = Type.getObjectType("kotlin/Unit");
    public static final Type PROPERTY_METADATA_TYPE = Type.getObjectType("kotlin/PropertyMetadata");
    public static final Type LAMBDA = Type.getObjectType("kotlin/jvm/internal/Lambda");
    public static final Type FUNCTION_REFERENCE = Type.getObjectType("kotlin/jvm/internal/FunctionReference");
    public static final Type PROPERTY_REFERENCE0 = Type.getObjectType("kotlin/jvm/internal/PropertyReference0");
    public static final Type PROPERTY_REFERENCE1 = Type.getObjectType("kotlin/jvm/internal/PropertyReference1");
    public static final Type PROPERTY_REFERENCE2 = Type.getObjectType("kotlin/jvm/internal/PropertyReference2");
    public static final Type MUTABLE_PROPERTY_REFERENCE0 = Type.getObjectType("kotlin/jvm/internal/MutablePropertyReference0");
    public static final Type MUTABLE_PROPERTY_REFERENCE1 = Type.getObjectType("kotlin/jvm/internal/MutablePropertyReference1");
    public static final Type MUTABLE_PROPERTY_REFERENCE2 = Type.getObjectType("kotlin/jvm/internal/MutablePropertyReference2");
    public static final Type K_CLASS_TYPE = AsmTypes.reflect("KClass");
    public static final Type K_CLASS_ARRAY_TYPE = Type.getObjectType("[" + K_CLASS_TYPE.getDescriptor());
    public static final Type K_DECLARATION_CONTAINER_TYPE = AsmTypes.reflect("KDeclarationContainer");
    public static final Type K_FUNCTION = AsmTypes.reflect("KFunction");
    public static final Type K_PROPERTY0_TYPE = AsmTypes.reflect("KProperty0");
    public static final Type K_PROPERTY1_TYPE = AsmTypes.reflect("KProperty1");
    public static final Type K_PROPERTY2_TYPE = AsmTypes.reflect("KProperty2");
    public static final Type K_MUTABLE_PROPERTY0_TYPE = AsmTypes.reflect("KMutableProperty0");
    public static final Type K_MUTABLE_PROPERTY1_TYPE = AsmTypes.reflect("KMutableProperty1");
    public static final Type K_MUTABLE_PROPERTY2_TYPE = AsmTypes.reflect("KMutableProperty2");
    public static final String REFLECTION = "kotlin/jvm/internal/Reflection";
    public static final String REF_TYPE_PREFIX = "kotlin/jvm/internal/Ref$";
    public static final Type OBJECT_REF_TYPE = Type.getObjectType("kotlin/jvm/internal/Ref$ObjectRef");
    public static final Type DEFAULT_CONSTRUCTOR_MARKER = Type.getObjectType("kotlin/jvm/internal/DefaultConstructorMarker");

    @NotNull
    private static Type reflect(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "reflect"));
        }
        Type type2 = Type.getObjectType("kotlin/reflect/" + className);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "reflect"));
        }
        return type2;
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "getType"));
        }
        Type type2 = TYPES_MAP.get(javaClass);
        if (type2 == null) {
            type2 = Type.getType(javaClass);
            TYPES_MAP.put(javaClass, type2);
        }
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/AsmTypes", "getType"));
        }
        return type3;
    }

    private AsmTypes() {
    }
}

