/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.ide.common.blame.parser.util.ParserUtil;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DexExceptionParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR = Pattern.compile("UNEXPECTED TOP-LEVEL EXCEPTION:");
    private static final Pattern ALREADY_ADDED_EXCEPTION = Pattern.compile("already added: L(.+);");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        Matcher m1 = ERROR.matcher(line);
        if (!m1.matches()) {
            return false;
        }
        String stackTrace = ParserUtil.digestStackTrace((OutputLineReader)reader);
        if (stackTrace == null) {
            return false;
        }
        Matcher m2 = ALREADY_ADDED_EXCEPTION.matcher(stackTrace);
        if (!m2.matches()) {
            return false;
        }
        String message = String.format("Class %1s has already been added to output. Please remove duplicate copies.", m2.group(1).replace('/', '.').replace('$', '.'));
        messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(SourceFile.UNKNOWN, SourcePosition.UNKNOWN), new SourceFilePosition[0]));
        return true;
    }
}

