/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.ClassDeclaration;
import lombok.ast.Expression;
import lombok.ast.If;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StringLiteral;
import lombok.ast.VariableReference;

public class LogDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LogDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue CONDITIONAL = Issue.create("LogConditional", "Unconditional Logging Calls", "The BuildConfig class (available in Tools 17) provides a constant, \"DEBUG\", which indicates whether the code is being built in release mode or in debug mode. In release mode, you typically want to strip out all the logging calls. Since the compiler will automatically remove all code which is inside a \"if (false)\" check, surrounding your logging calls with a check for BuildConfig.DEBUG is a good idea.\n\nIf you *really* intend for the logging to be present in release mode, you can suppress this warning with a @SuppressLint annotation for the intentional logging calls.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue WRONG_TAG = Issue.create("LogTagMismatch", "Mismatched Log Tags", "When guarding a `Log.v(tag, ...)` call with `Log.isLoggable(tag)`, the tag passed to both calls should be the same. Similarly, the level passed in to `Log.isLoggable` should typically match the type of `Log` call, e.g. if checking level `Log.DEBUG`, the corresponding `Log` call should be `Log.d`, not `Log.i`.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    public static final Issue LONG_TAG = Issue.create("LongLogTag", "Too Long Log Tags", "Log tags are only allowed to be at most 23 tag characters long.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    private static final String IS_LOGGABLE = "isLoggable";
    private static final String LOG_CLS = "android.util.Log";
    private static final String PRINTLN = "println";

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("d", "e", "i", "v", "w", PRINTLN, IS_LOGGABLE);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        boolean withinConditional;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        if (!method.getContainingClass().matches(LOG_CLS)) {
            return;
        }
        String name = node.astName().astValue();
        boolean bl = withinConditional = IS_LOGGABLE.equals(name) || LogDetector.checkWithinConditional(context, node.getParent(), node);
        if (("i".equals(name) || "d".equals(name) || "v".equals(name) || PRINTLN.equals(name)) && !withinConditional && LogDetector.performsWork(context, node) && context.isEnabled(CONDITIONAL)) {
            String message = String.format("The log call Log.%1$s(...) should be conditional: surround with `if (Log.isLoggable(...))` or `if (BuildConfig.DEBUG) { ... }`", node.astName().toString());
            context.report(CONDITIONAL, (Node)node, context.getLocation((Node)node), message);
        }
        if (context.isEnabled(LONG_TAG)) {
            int tagArgumentIndex;
            int n = tagArgumentIndex = PRINTLN.equals(name) ? 1 : 0;
            if (method.getArgumentCount() > tagArgumentIndex && method.getArgumentType(tagArgumentIndex).matchesSignature("java.lang.String") && node.astArguments().size() == method.getArgumentCount()) {
                Node argument;
                String tag;
                Iterator iterator = node.astArguments().iterator();
                if (tagArgumentIndex == 1) {
                    iterator.next();
                }
                if ((tag = ConstantEvaluator.evaluateString(context, argument = (Node)iterator.next(), true)) != null && tag.length() > 23) {
                    String message = String.format("The logging tag can be at most 23 characters, was %1$d (%2$s)", tag.length(), tag);
                    context.report(LONG_TAG, (Node)node, context.getLocation((Node)node), message);
                }
            }
        }
    }

    private static boolean performsWork(@NonNull JavaContext context, @NonNull MethodInvocation node) {
        int messageArgumentIndex;
        int n = messageArgumentIndex = PRINTLN.equals(node.astName().astValue()) ? 2 : 1;
        if (node.astArguments().size() >= messageArgumentIndex) {
            String string;
            Iterator iterator = node.astArguments().iterator();
            Node argument = null;
            for (int i = 0; i <= messageArgumentIndex; ++i) {
                argument = (Node)iterator.next();
            }
            if (argument == null) {
                return false;
            }
            if (argument instanceof StringLiteral || argument instanceof VariableReference) {
                return false;
            }
            return !(argument instanceof BinaryExpression ? (string = ConstantEvaluator.evaluateString(context, argument, false)) != null : argument instanceof Select && (string = ConstantEvaluator.evaluateString(context, argument, false)) != null);
        }
        return false;
    }

    private static boolean checkWithinConditional(@NonNull JavaContext context, @Nullable Node curr, @NonNull MethodInvocation logCall) {
        while (curr != null) {
            if (curr instanceof If) {
                MethodInvocation call;
                If ifNode = (If)curr;
                if (ifNode.astCondition() instanceof MethodInvocation && IS_LOGGABLE.equals((call = (MethodInvocation)ifNode.astCondition()).astName().astValue())) {
                    LogDetector.checkTagConsistent(context, logCall, call);
                }
                return true;
            }
            if (curr instanceof MethodInvocation || curr instanceof ClassDeclaration) break;
            curr = curr.getParent();
        }
        return false;
    }

    private static void checkTagConsistent(JavaContext context, MethodInvocation logCall, MethodInvocation call) {
        Iterator isLogIterator = call.astArguments().iterator();
        Iterator logIterator = logCall.astArguments().iterator();
        if (!isLogIterator.hasNext() || !logIterator.hasNext()) {
            return;
        }
        Expression isLoggableTag = (Expression)isLogIterator.next();
        Expression logTag = (Expression)logIterator.next();
        String logCallName = logCall.astName().astValue();
        boolean isPrintln = PRINTLN.equals(logCallName);
        if (isPrintln) {
            if (!logIterator.hasNext()) {
                return;
            }
            logTag = (Expression)logIterator.next();
        }
        if (logTag != null && !isLoggableTag.toString().equals(logTag.toString())) {
            JavaParser.ResolvedNode resolved1 = context.resolve((Node)isLoggableTag);
            JavaParser.ResolvedNode resolved2 = context.resolve((Node)logTag);
            if ((resolved1 == null || resolved2 == null || !resolved1.equals(resolved2)) && context.isEnabled(WRONG_TAG)) {
                Location location = context.getLocation((Node)logTag);
                Location alternate = context.getLocation((Node)isLoggableTag);
                alternate.setMessage("Conflicting tag");
                location.setSecondary(alternate);
                String isLoggableDescription = resolved1 != null ? resolved1.getName() : isLoggableTag.toString();
                String logCallDescription = resolved2 != null ? resolved2.getName() : logTag.toString();
                String message = String.format("Mismatched tags: the `%1$s()` and `isLoggable()` calls typically should pass the same tag: `%2$s` versus `%3$s`", logCallName, isLoggableDescription, logCallDescription);
                context.report(WRONG_TAG, (Node)call, location, message);
            }
        }
        if (logCallName.length() != 1 || !isLogIterator.hasNext()) {
            return;
        }
        Expression isLoggableLevel = (Expression)isLogIterator.next();
        if (isLoggableLevel == null) {
            return;
        }
        String levelString = isLoggableLevel.toString();
        if (isLoggableLevel instanceof Select) {
            levelString = ((Select)isLoggableLevel).astIdentifier().astValue();
        }
        if (levelString.isEmpty()) {
            return;
        }
        char levelChar = Character.toLowerCase(levelString.charAt(0));
        if (logCallName.charAt(0) == levelChar || !context.isEnabled(WRONG_TAG)) {
            return;
        }
        switch (levelChar) {
            case 'd': 
            case 'e': 
            case 'i': 
            case 'v': 
            case 'w': {
                break;
            }
            default: {
                return;
            }
        }
        String expectedCall = String.valueOf(levelChar);
        String message = String.format("Mismatched logging levels: when checking `isLoggable` level `%1$s`, the corresponding log call should be `Log.%2$s`, not `Log.%3$s`", levelString, expectedCall, logCallName);
        Location location = context.getLocation((Node)logCall.astName());
        Location alternate = context.getLocation((Node)isLoggableLevel);
        alternate.setMessage("Conflicting tag");
        location.setSecondary(alternate);
        context.report(WRONG_TAG, (Node)call, location, message);
    }
}

