/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.JavaContext;
import java.util.ListIterator;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.BooleanLiteral;
import lombok.ast.Cast;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StringLiteral;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class ConstantEvaluator {
    private final JavaContext mContext;
    private boolean mAllowUnknown;

    public ConstantEvaluator(@Nullable JavaContext context) {
        this.mContext = context;
    }

    public ConstantEvaluator allowUnknowns() {
        this.mAllowUnknown = true;
        return this;
    }

    @Nullable
    public Object evaluate(@NonNull Node node) {
        if (node instanceof NullLiteral) {
            return null;
        }
        if (node instanceof BooleanLiteral) {
            return ((BooleanLiteral)node).astValue();
        }
        if (node instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)node;
            return string.astValue();
        }
        if (node instanceof IntegralLiteral) {
            IntegralLiteral literal = (IntegralLiteral)node;
            if (literal.astMarkedAsLong()) {
                return literal.astLongValue();
            }
            return literal.astIntValue();
        }
        if (node instanceof FloatingPointLiteral) {
            FloatingPointLiteral literal = (FloatingPointLiteral)node;
            if (literal.astMarkedAsFloat()) {
                return Float.valueOf(literal.astFloatValue());
            }
            return literal.astDoubleValue();
        }
        if (node instanceof UnaryExpression) {
            UnaryOperator operator = ((UnaryExpression)node).astOperator();
            Object operand = this.evaluate((Node)((UnaryExpression)node).astOperand());
            if (operand == null) {
                return null;
            }
            switch (operator) {
                case LOGICAL_NOT: {
                    if (!(operand instanceof Boolean)) break;
                    return (Boolean)operand == false;
                }
                case UNARY_PLUS: {
                    return operand;
                }
                case BINARY_NOT: {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (!(operand instanceof Byte)) break;
                    return (int)(~((Byte)operand).byteValue());
                }
                case UNARY_MINUS: {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (!(operand instanceof Byte)) break;
                    return (int)(-((Byte)operand).byteValue());
                }
            }
        } else if (node instanceof InlineIfExpression) {
            InlineIfExpression expression = (InlineIfExpression)node;
            Object known = this.evaluate((Node)expression.astCondition());
            if (known == Boolean.TRUE && expression.astIfTrue() != null) {
                return this.evaluate((Node)expression.astIfTrue());
            }
            if (known == Boolean.FALSE && expression.astIfFalse() != null) {
                return this.evaluate((Node)expression.astIfFalse());
            }
        } else if (node instanceof BinaryExpression) {
            BinaryOperator operator = ((BinaryExpression)node).astOperator();
            Object operandLeft = this.evaluate((Node)((BinaryExpression)node).astLeft());
            Object operandRight = this.evaluate((Node)((BinaryExpression)node).astRight());
            if (operandLeft == null || operandRight == null) {
                if (this.mAllowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == BinaryOperator.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                switch (operator) {
                    case LOGICAL_OR: {
                        return left || right;
                    }
                    case LOGICAL_AND: {
                        return left && right;
                    }
                    case BITWISE_OR: {
                        return left | right;
                    }
                    case BITWISE_XOR: {
                        return left ^ right;
                    }
                    case BITWISE_AND: {
                        return left & right;
                    }
                    case EQUALS: {
                        return left == right;
                    }
                    case NOT_EQUALS: {
                        return left != right;
                    }
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean isWide = isInteger ? left instanceof Long || right instanceof Long : left instanceof Double || right instanceof Double;
                switch (operator) {
                    case BITWISE_OR: {
                        if (isWide) {
                            return left.longValue() | right.longValue();
                        }
                        return left.intValue() | right.intValue();
                    }
                    case BITWISE_XOR: {
                        if (isWide) {
                            return left.longValue() ^ right.longValue();
                        }
                        return left.intValue() ^ right.intValue();
                    }
                    case BITWISE_AND: {
                        if (isWide) {
                            return left.longValue() & right.longValue();
                        }
                        return left.intValue() & right.intValue();
                    }
                    case EQUALS: {
                        if (isInteger) {
                            return left.longValue() == right.longValue();
                        }
                        return left.doubleValue() == right.doubleValue();
                    }
                    case NOT_EQUALS: {
                        if (isInteger) {
                            return left.longValue() != right.longValue();
                        }
                        return left.doubleValue() != right.doubleValue();
                    }
                    case GREATER: {
                        if (isInteger) {
                            return left.longValue() > right.longValue();
                        }
                        return left.doubleValue() > right.doubleValue();
                    }
                    case GREATER_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() >= right.longValue();
                        }
                        return left.doubleValue() >= right.doubleValue();
                    }
                    case LESS: {
                        if (isInteger) {
                            return left.longValue() < right.longValue();
                        }
                        return left.doubleValue() < right.doubleValue();
                    }
                    case LESS_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() <= right.longValue();
                        }
                        return left.doubleValue() <= right.doubleValue();
                    }
                    case SHIFT_LEFT: {
                        if (isWide) {
                            return left.longValue() << right.intValue();
                        }
                        return left.intValue() << right.intValue();
                    }
                    case SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >> right.intValue();
                        }
                        return left.intValue() >> right.intValue();
                    }
                    case BITWISE_SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >>> right.intValue();
                        }
                        return left.intValue() >>> right.intValue();
                    }
                    case PLUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() + right.longValue();
                            }
                            return left.intValue() + right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() + right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() + right.floatValue());
                    }
                    case MINUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() - right.longValue();
                            }
                            return left.intValue() - right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() - right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() - right.floatValue());
                    }
                    case MULTIPLY: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() * right.longValue();
                            }
                            return left.intValue() * right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() * right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() * right.floatValue());
                    }
                    case DIVIDE: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() / right.longValue();
                            }
                            return left.intValue() / right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() / right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() / right.floatValue());
                    }
                    case REMAINDER: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() % right.longValue();
                            }
                            return left.intValue() % right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() % right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() % right.floatValue());
                    }
                }
                return null;
            }
        } else {
            if (node instanceof Cast) {
                Cast cast = (Cast)node;
                Object operandValue = this.evaluate((Node)cast.astOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    String typeName = cast.astTypeReference().getTypeName();
                    if (typeName.equals("float")) {
                        return Float.valueOf(number.floatValue());
                    }
                    if (typeName.equals("double")) {
                        return number.doubleValue();
                    }
                    if (typeName.equals("int")) {
                        return number.intValue();
                    }
                    if (typeName.equals("long")) {
                        return number.longValue();
                    }
                    if (typeName.equals("short")) {
                        return number.shortValue();
                    }
                    if (typeName.equals("byte")) {
                        return number.byteValue();
                    }
                }
                return operandValue;
            }
            if (this.mContext != null && (node instanceof VariableReference || node instanceof Select)) {
                Statement statement;
                JavaParser.ResolvedNode resolved = this.mContext.resolve(node);
                if (resolved instanceof JavaParser.ResolvedField) {
                    JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
                    return field.getValue();
                }
                if (node instanceof VariableReference && (statement = JavaContext.getParentOfType(node, Statement.class, false)) != null) {
                    ListIterator iterator = statement.getParent().getChildren().listIterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != statement) continue;
                        if (!iterator.hasPrevious()) break;
                        iterator.previous();
                        break;
                    }
                    String targetName = ((VariableReference)node).astIdentifier().astValue();
                    while (iterator.hasPrevious()) {
                        BinaryExpression binaryExpression;
                        ExpressionStatement expressionStatement;
                        Expression expression;
                        Node previous = (Node)iterator.previous();
                        if (previous instanceof VariableDeclaration) {
                            VariableDeclaration declaration = (VariableDeclaration)previous;
                            VariableDefinition definition = declaration.astDefinition();
                            for (VariableDefinitionEntry entry : definition.astVariables()) {
                                if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                                return this.evaluate((Node)entry.astInitializer());
                            }
                            continue;
                        }
                        if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                        return this.evaluate((Node)binaryExpression.astRight());
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public static Object evaluate(@NonNull JavaContext context, @NonNull Node node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    @Nullable
    public static String evaluateString(@NonNull JavaContext context, @NonNull Node node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }
}

