/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.ArraysKt;
import kotlin.Charsets;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.LinesSequence;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"e\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012B\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u001d)\u0001!B\u0001\t)\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0013\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ\"\u0004\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0003e-A!\u0001E\u0002\u001b\u0005A\"\u0001UB\u0001)\u000e\u0015Q\"\u0004\u0005\u0001\u001b\u0005A2!F\u0001\u0019\be-A!\u0001E\u0002\u001b\u0005A\"\u0001UB\u0001)\u000e\u0015QR\u0005\u0005\u0005\u001b\u0005AJ!F\u0001\u0019\u0003e%\u0001\"B\u0007\u00021\u000f\u00016\u0011AM\u0006\t\u0005A\u0019!D\u0001\u0019\u0005A\u001b\u0011\u0001VB\u0003\u001bIAY!D\u0001\u0019\rU\t\u0001$AM\u000b\u0011\u001biq!\u0003\u0002\n\u0003a=\u0011BA\u0005\u00021\u0019Ar\u0001UB\u0001)\u000e\u0015QR\u0003C\u0004\u0011!iA!\u0003\u0002\n\u0003a=\u0001\u0014C\u000b\u00021\u0003!6QAG\n\u0011%iA!\u0003\u0002\n\u0003a=\u00014C\u000b\u00021\u0003!6QAG\u000b\t\u000fA!\"\u0004\u0003\n\u0005%\t\u0001t\u0002M\n+\u0005A\n\u0001VB\u0003\u001b\u001bA)\"D\u0001\u0019\u0017U\t\u0001t\u0003+\u0004\u000655\u0001\u0002D\u0007\u00021\u001f)\u0012\u0001G\u0001U\u0007\u000biQ\u0002\u0003\u0007\u000e\u0003a=Q#\u0001M\f3\u0017!\u0011\u0001#\u0007\u000e\u0003ai\u0001k!\u0001U\u0007\u000biA\u0002\u0003\u0007\u000e\u0003a=Q#\u0001M\f3\u0013AI\"D\u0001\u0019\u0010A\u001b\t\u0001VB\u0003\u001b\u001bAY\"D\u0001\u0019\u001dU\t\u0001t\u0002+\u0004\u00065qBa\u0011\t\t\u001e5\tAeD\t\u0005\t\u0001Ay\"F\u0001\u0019!E\u0011A\u0011\u0001\u0005\u0010+\u0005!{\"'\u0006\t\u000e59\u0011BA\u0005\u0002I?I!!C\u0001%\u001fa9\u0001k!\u0001R\u0007\u0005A\t\u0003VB\u0003\u001bq!1\t\u0005\u0005\u0012\u001b\u0005!{\"\u0005\u0002\u0005\u0001!}Q#\u0001\r\u000237Ai!\u0004\u0006\n\u000b%!\u0011BA\u0005\u00021\u001fA\u001a\"\u0003\u0002\n\u0003\u0011~\u0001d\u0002)\u0004\u0002E\u001b\u0011\u0001c\tU\u0007\u000b\u0001"}, strings={"buffered", "Ljava/io/BufferedReader;", "Ljava/io/Reader;", "bufferSize", "", "TextStreamsKt", "Ljava/io/BufferedWriter;", "Ljava/io/Writer;", "copyTo", "", "out", "forEachLine", "", "block", "Lkotlin/Function1;", "", "lineIterator", "", "lineSequence", "Lkotlin/Sequence;", "lines", "readBytes", "", "Ljava/net/URL;", "readText", "charset", "Ljava/nio/charset/Charset;", "reader", "Ljava/io/StringReader;", "use", "R", "T", "Ljava/io/Closeable;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useLines", "(Ljava/io/Reader;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;"}, moduleName="kotlin-stdlib")
@JvmName(name="TextStreamsKt")
public final class TextStreamsKt {
    @NotNull
    public static final BufferedReader buffered(Reader $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedReader ? (BufferedReader)$receiver : new BufferedReader($receiver, bufferSize);
    }

    @NotNull
    public static /* synthetic */ BufferedReader buffered$default(Reader reader, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.buffered(reader, n);
    }

    @NotNull
    public static final BufferedWriter buffered(Writer $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedWriter ? (BufferedWriter)$receiver : new BufferedWriter($receiver, bufferSize);
    }

    @NotNull
    public static /* synthetic */ BufferedWriter buffered$default(Writer writer, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.buffered(writer, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void forEachLine(Reader $receiver, @NotNull Function1<? super String, ? extends Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Reader $receiver2 = $receiver;
        Closeable $receiver3 = TextStreamsKt.buffered$default($receiver2, 0, 1);
        boolean closed = false;
        try {
            void $receiver4;
            Sequence<String> it2;
            Object it3 = (BufferedReader)$receiver3;
            Sequence<String> sequence2 = it2 = TextStreamsKt.lineSequence((BufferedReader)it3);
            Function1<? super String, ? extends Unit> function1 = block;
            for (Object element : $receiver4) {
                void operation;
                operation.invoke(element);
            }
            it3 = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver3.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T useLines(Reader $receiver, @NotNull Function1<? super Sequence<? extends String>, ? extends T> block) {
        BufferedReader it2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Closeable $receiver2 = TextStreamsKt.buffered$default($receiver, 0, 1);
        boolean closed = false;
        try {
            it2 = (BufferedReader)$receiver2;
            it2 = block.invoke(TextStreamsKt.lineSequence(it2));
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (!closed) {
                $receiver2.close();
            }
            InlineMarker.finallyEnd(1);
        }
        return (T)it2;
    }

    @NotNull
    public static final StringReader reader(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new StringReader($receiver);
    }

    @NotNull
    public static final Sequence<String> lineSequence(BufferedReader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.constrainOnce(new LinesSequence($receiver));
    }

    @Deprecated(message="Use lineSequence() instead to avoid conflict with JDK8 lines() method.", replaceWith=@ReplaceWith(imports={}, expression="lineSequence()"))
    @NotNull
    public static final Sequence<String> lines(BufferedReader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TextStreamsKt.lineSequence($receiver);
    }

    @Deprecated(message="Use lineSequence() function which returns Sequence<String>")
    @NotNull
    public static final Iterator<String> lineIterator(BufferedReader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TextStreamsKt.lineSequence($receiver).iterator();
    }

    @NotNull
    public static final String readText(Reader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        StringWriter buffer = new StringWriter();
        TextStreamsKt.copyTo$default($receiver, buffer, 0, 2);
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "buffer.toString()");
        return string;
    }

    public static final long copyTo(Reader $receiver, @NotNull Writer out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $receiver.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $receiver.read(buffer);
        }
        return charsCopied;
    }

    public static /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.copyTo(reader, writer, n);
    }

    @NotNull
    public static final String readText(URL $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return ArraysKt.toString(TextStreamsKt.readBytes($receiver), charset);
    }

    @NotNull
    public static final String readText(URL $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return ArraysKt.toString(TextStreamsKt.readBytes($receiver), charset);
    }

    @NotNull
    public static /* synthetic */ String readText$default(URL uRL, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return TextStreamsKt.readText(uRL, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(URL $receiver) {
        Object it2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Closeable $receiver2 = $receiver.openStream();
        boolean closed = false;
        try {
            it2 = (InputStream)$receiver2;
            it2 = ByteStreamsKt.readBytes$default((InputStream)it2, 0, 1);
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
        return (byte[])it2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends Closeable, R> R use(T $receiver, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        boolean closed = false;
        try {
            R r = block.invoke($receiver);
            return r;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (!closed) {
                $receiver.close();
            }
            InlineMarker.finallyEnd(1);
        }
    }
}

