/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerationInfoBase
implements GenerationInfo {
    public abstract void insert(PsiClass var1, PsiElement var2, boolean var3) throws IncorrectOperationException;

    public abstract PsiMember getPsiMember();

    @Nullable
    public PsiElement findInsertionAnchor(@NotNull PsiClass aClass, @NotNull PsiElement leaf) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/GenerationInfoBase", "findInsertionAnchor"));
        }
        if (leaf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaf", "com/intellij/codeInsight/generation/GenerationInfoBase", "findInsertionAnchor"));
        }
        PsiElement element = leaf;
        while (element.getParent() != aClass) {
            element = element.getParent();
        }
        PsiElement lBrace = aClass.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (!GenerateMembersUtil.isChildInRange(element, lBrace.getNextSibling(), rBrace)) {
            return null;
        }
        PsiElement prev = leaf.getPrevSibling();
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            element = leaf.getNextSibling();
        }
        return element;
    }

    public void positionCaret(Editor editor, boolean toEditMethodBody) {
        GenerateMembersUtil.positionCaret(editor, (PsiElement)this.getPsiMember(), toEditMethodBody);
    }
}

