/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.completion;

import com.intellij.application.options.emmet.EmmetCompositeConfigurable;
import com.intellij.application.options.emmet.XmlEmmetConfigurable;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;

public class EmmetLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element, final Lookup lookup, Consumer<LookupElementAction> consumer) {
        if (element instanceof CustomLiveTemplateLookupElement && ((CustomLiveTemplateLookupElement)element).getCustomLiveTemplate() instanceof ZenCodingTemplate) {
            ZenCodingGenerator generator;
            PsiElement context = lookup.getPsiElement();
            ZenCodingGenerator zenCodingGenerator = generator = context != null ? ZenCodingTemplate.findApplicableDefaultGenerator(context, false) : null;
            if (generator != null) {
                consumer.consume((Object)new LookupElementAction(PlatformIcons.EDIT, "Edit Emmet settings"){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        final Project project = lookup.getEditor().getProject();
                        assert (project != null);
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (project.isDisposed()) {
                                    return;
                                }
                                Configurable generatorSpecificConfigurable = generator.createConfigurable();
                                EmmetCompositeConfigurable configurable = generatorSpecificConfigurable != null ? new EmmetCompositeConfigurable(generatorSpecificConfigurable) : new EmmetCompositeConfigurable(new Configurable[]{new XmlEmmetConfigurable()});
                                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                            }
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
                consumer.consume((Object)new LookupElementAction(AllIcons.Actions.Delete, "Disable Emmet"){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                generator.disableEmmet();
                            }
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }
}

