/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\"\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011A)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\tA\"A\u0003\u0002\t\u0007!1\u0004\u0004\u0001\u001a\u0003a\u0005\u0011$\u0001\r\u0002;\u0005\u00152#i\u0002\u0005\u0003E\u001b\u0011\u0001c\u0001&\u0011\u0011Y\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003aEQE\tE\n\u001b\u001dI!!C\u0001%\u0016%\u0011\u0011\"\u0001\u0013\f1)\tB\u0001\u0002\u0001\t\u0016U\t\u00014B\t\u0005\t\u0003A1\"F\u0001\u0019\re\u0019\u0001rC\u0007\u00021#Ib\u0001\u0003\u0007\u000e\t%\u0011\u0011\"\u0001\u0013\f13I2\u0001C\u0007\u000e\u0003amQ\u0005\u0004\u0003\u0014\u00119i\u0011\u0001'\b\u001a\u0007!yQ\"\u0001M\t3\rAy\"D\u0001\u0019!\u0015\u001a\u0002\u0012E\u0007\u00021EIr\u0002\u0003\u0007\u000e\u001b%A\u0011bB\u0005\u0003\u0013\u0005AZ!\u0003\u0002\n\u0003a1\u0001$B\u0005\u0003\u0013\u0005A\u0012\u0003g\t&\u0007!\u0011R\"\u0001\r\u0012S%!1\u000b\u0003\u0005\u0003\u001b\u0005A*!U\u0002\u0004\u001b\t!1\u0001c\u0002*k\u0011\t\u0005\u0002\u0003\u0003\u000e_%\u0011\u0012\"E\u0005\u0003\u0013\u0005AZ!\u0003\u0002\n\u0003a1\u0001SB\u000b\t\u0013\tI\u0011\u0001g\u0003\n\u0005%\t\u0001D\u0002G\u00011\u0015AR\u0001%\u0004\u0016.%\u0011\u0012\"E\u0005\u0003\u0013\u0005AZ!\u0003\u0002\n\u0003a1\u0001SB\u000b\t\u0013\tI\u0011\u0001g\u0003\n\u0005%\t\u0001D\u0002G\u00011\u0015AR\u0001g\u0004R\u0007\u0005!q\u0001'\u0003R\u0007\u0005!q!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemesManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "Lcom/intellij/openapi/options/ExternalizableScheme;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "checkPath", "", "originalPath", "createSchemesManager", "Lcom/intellij/openapi/options/SchemesManager;", "T", "E", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "process", "", "Lkotlin/Function1;", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory"}, moduleName="configuration-store-impl")
public abstract class SchemeManagerFactoryBase
extends SchemesManagerFactory
implements SettingsSavingComponent {
    private final List<SchemeManagerImpl<Scheme, ExternalizableScheme>> managers = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public abstract ComponentManager getComponentManager();

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor2, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        StateStorageManager storageManager2 = ServiceKt.getStateStore(this.getComponentManager()).getStateStorageManager();
        String path = this.checkPath(directoryName);
        StateStorageManager stateStorageManager = storageManager2;
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        StreamProvider streamProvider = stateStorageManagerImpl != null ? stateStorageManagerImpl.getStreamProvider() : null;
        StateStorageManager stateStorageManager2 = storageManager2;
        Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"storageManager");
        SchemeManagerImpl manager = new SchemeManagerImpl(path, processor2, streamProvider, this.pathToFile(path, stateStorageManager2), roamingType, (Disposable)this.getComponentManager());
        this.managers.add(manager);
        return manager;
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        checkPath.1 error$ = checkPath.1.INSTANCE;
        if (StringsKt.contains$default((String)originalPath, (char)'\\', (boolean)false, (int)2)) {
            error$.invoke("Path must be system-independent, use forward slash instead of backslash");
        } else if (StringsKt.isEmpty((String)originalPath)) {
            error$.invoke("Path must not be empty");
        }
        return originalPath;
    }

    @NotNull
    public abstract File pathToFile(@NotNull String var1, @NotNull StateStorageManager var2);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, ExternalizableScheme>, ? extends Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> manager : this.managers) {
            try {
                SchemeManagerImpl<Scheme, ExternalizableScheme> schemeManagerImpl = manager;
                Intrinsics.checkExpressionValueIsNotNull(schemeManagerImpl, (String)"manager");
                processor2.invoke(schemeManagerImpl);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + ((Object)manager).getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, ExternalizableScheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0005\u00031\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002K!!1\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AB!\n\u0007\u0005\u0017!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\te\u0019\u0001RB\u0007\u00021\u001dI#\u0002B&\t\u0011\u0007i\u0011\u0001\u0007\u0002\u001dWE\u001b1!\u0004\u0002\u0005\u0006!\u0019\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/io/File;", "path", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;"}, moduleName="configuration-store-impl")
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @Override
        @NotNull
        public ComponentManager getComponentManager() {
            ComponentManager componentManager = (ComponentManager)ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"ApplicationManager.getApplication()");
            return componentManager;
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)SchemeManagerFactoryImplKt.getROOT_CONFIG(), (boolean)false, (int)2)) {
                path = StringsKt.substring((String)path, (int)(CollectionsKt.length((CharSequence)SchemeManagerFactoryImplKt.getROOT_CONFIG()) + 1));
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(storageManager2.expandMacros(SchemeManagerFactoryImplKt.getROOT_CONFIG() + "/" + path));
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)C\u0002B\u0006\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u0007S)!1\n\u0003E\u0003\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001B\u0002\t\b%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "pathToFile", "Ljava/io/File;", "path", "", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;"}, moduleName="configuration-store-impl")
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @NotNull
        private final Project componentManager;
        private final Project project;

        @NotNull
        public Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @NotNull
        public File pathToFile(@NotNull String path, @NotNull StateStorageManager storageManager2) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            return new File(this.project.getBasePath(), ProjectUtil.isDirectoryBased(this.project) ? ".idea" + "/" + path : "." + path);
        }

        public ProjectSchemeManagerFactory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(null);
            this.componentManager = this.project = project;
        }
    }
}

