/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.RangesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\t\r)\u0011\u0001#\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0011!B\u0001\t\"\u0015\t\u00012A\u0003\u0002\t\u0011)\u0011\u0001\u0003\t\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\t\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\t\ta\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u0002+\u0011!\t\u0001c\u0001\u0016\u0003a\u0011\u0011dB\u0005\u0003\u0013\u0005!\u000b!\u0003\u0002\n\u0003\u0011\u000e\u0001TA\r\u00021\ri\n\u0001PQ\"\u0013\rA9!D\u0001\u0019\t%1\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001(\u0001\u0019\u000b%!\u00012B\u0007\u0003\u0019\u0003Ab!C\u0002\t\u000e5\t\u0001dB\u0005\u0005\t\u0005Ay!D\u0001\u0019\u0011%)A!\u0001E\t\u001b\ta\t\u0001G\u0005R\u0007\u0005A\u0019\"*\b\u0005\u0017!\u001dR\"\u0001\r\u00153\rAI#D\u0001\u001d\u0001e\u0019\u0001\"F\u0007\u00021E\t6!\u0001E\u0016K%!\u0011\u0001\u0003\f\u000e\u0003a!\u0012\u0004\u0002E\t\u001b\ta\t\u0001G\u0005&\u0011\u0011\t\u0001RF\u0007\u00021EI2\u0001C\f\u000e\u0003a=R\u0005\u0002\u0003\f\u0011ai\u0011\u0001\u0007\u000b&\u001d\u0011\t\u0001\u0012G\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0003\u00193e1\u0001rD\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u00193\u0015ZA!\u0001E\u001a\u001b\u0005AB#\u0007\u0004\t55!\u0011BA\u0005\u00021mA*$j\u0006\u0005\u0003!]RB\u0001G\u00019\u0003I2\u0001\u0003\n\u000e\u0003a!\u0011kA\u0001\t9\u0015^Aa\u0003E\u001d\u001b\ta\t\u0001\b\u0001\u001a\u0007!iR\"\u0001\r\u0005#\u000e\t\u00012H\u0013\b\t-Aa$\u0004\u0003\n\u0005%\t\u0001\u0004\u0002\r\u001aKY!1\u0002#\u0010\u000e'%1\u0011\"\u0002\t +\ta\t\u0001\b\u0001\u001d\u0001AyR#C\u0005\u0007\u0013\u0015\u0001r$\u0006\u0002\r\u0002q\u0001A\u0004\u0001G\u00011\u007fA*$j\u0004\u0005\u0017!\u0001SB\u0001G\u00019\u0001\t6!\u0001E!K\u0015!\u0011\u0001C\u0011\u000e\u00051\u0005\u0001tC\u0013\r\t\u0005A\u0019%D\u0001\u0019\te\u0019\u0001BE\u0007\u00021_I2\u0001\u0003\u0012\u000e\u0003a\tR\u0005\u0002\u0003\f\u0011\u000bj\u0011\u0001G\u0004&\u001b\u0011\t\u0001bIG\u00041\u000f\n6!\u0001\u0003%3\rAI#D\u0001\u001d\u0002E\u001b\u0011\u0001#\u0013&\u0016\u0011Y\u0001\"J\u0007\u00021EI2\u0001#\u000b\u000e\u0003q\u0005\u0011kA\u0001\tL\u0015BA!\u0001\u0005'\u001b\u0005A\u0012#G\u0002\tN5\t\u0001tC\u0013\t\t\u0005Aa%D\u0001\u0019#e\u0019\u0001bJ\u0007\u00021\u001f*+\u0002B\u0001\tQ5\t\u0001$E\r\u0004\u0011#j\u0011\u0001(\u0001R\u0007\u0005AY%\n\u0005\u0005\u0003!IS\"\u0001\r\u00123\rAI#D\u0001\u0019\u0005\u0015JBa\u0003E*\u001b\u0005AB#G\u0002\tU5\t\u0001\u0004B\r\u0004\u0011+j\u0011\u0001G\u0016\u001a\u0019!]SBC\u0005\u0003\u0013\u0005AJ&\u0003\u0002\n\u0003q\u0001\u0011BA\u0005\u00021mAB&j\n\u0005\u0003!iSB\u0001G\u00019\u0003I2\u0001\u0003\n\u000e\u0003a=\u0012d\u0001E.\u001b\u0005Ab&G\u0002\t^5\t\u0001$E)\u0004\u0003!ySe\u0002\u0003\f\u0011?jA!\u0003\u0002\n\u0003q\u0005\u0001$GS\u0010\t\u0005A\u0001'\u0004\u0002\r\u0002q\u0005\u0011d\u0001E'\u001b\u0005A:\"G\u0002\t^5\t\u0001$E)\u0004\u0003!\u0005T%\u0003\u0003\u0002\u0011Ej\u0011\u0001\u0007\u000b\u001a\t!EQB\u0001G\u00011%)3\u0001c\u0019\u000e\u0003a!Re\u0003\u0003\u0002\u0011Ij\u0011\u0001\u0007\u000b\u001a\r!QR\u0002B\u0005\u0003\u0013\u0005A2\u0004'\u000e&\t\u0011\t\u0001RM\u0007\u00021Q)+\u0002B\u0006\tg5\t\u0001\u0004F\r\u0004\u0011Si\u0011\u0001\b\u0001R\u0007\u0005A9'J\u0006\u0005\u0003!!T\"\u0001\r\u00153\u0019AI'\u0004\u0003\n\u0005%\tA\u0004\u0001M K)AQ'D\u0001\u0019)e1\u0001BG\u0007\u0005\u0013\tI\u0011\u0001G\u000e\u00196\u0015vA!\u0001E6\u001b\u0005AB#G\u0002\t*5\tA\u0014A\r\u0004\u0011Yj\u0011\u0001'\u001cR\u0007\u0005Aq'j\b\u0005\u0017!=T\"\u0001\r\u00153\u0011AI#\u0004\u0002\r\u0002q\u0001\u0011d\u0001\u00059\u001b\u0005A\u0012#U\u0002\u0002\u0011W)+\u0004B\u0006\tr5\t\u0001\u0004F\r\u0007\u0011SjA!\u0003\u0002\n\u0003q\u0001\u0001tH\r\u0005\u0011ej!\u0001$\u0001\u001d\u0001e9\u00012O\u0007\u0006\u0013\tI\u0011\u0001\b\u0001\r\u0002aQ\u0014kA\u0001\tv\u0015\"Aa\u0003\u0005<\u001b\u0005AB!\n\u0004\u0005\u0003!]T\"\u0001\r\u0015+\u0005Ar\"K\u0005\u0005\u0003rA!\"\u0004\u0002\r\u0002q\u0001\u0011k\u0001\u0002\u0006\u0003!U\u0011\u0006\u0003\u0003B9!YQB\u0001G\u00011/\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0004\u001b\u0005AB!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u00111iA!\u0003\u0002\n\u0003a!\u0001\u0014D)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!5Q\"\u0001\r\b#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001(\u0001\u0019\u000bE\u001b\u0011!\u0002\u0001*\u0011\u0011\t\u0005\u0002c\u0003\u000e\u00051\u0005\u0001DB)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!iQbB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003q\u0005\u00014D)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!=Q\"\u0001\r\t#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BD\u0007\u00021\u0011\t6!A\u0003\u0001S5!\u0011\t\u0003E\u000f\u001b\u001dI!!C\u0001\u001d\u0002%\u0011\u0011\"\u0001\r\u001017\t6!A\u0003\u0001S)!\u0011\t\u0003E\u0010\u001b\u0011I!!C\u0001\u001d\u0001a\u0001\u0012kA\u0001\u0006\u0001%:A!\u0011\u0005\t\"5\t\u0001$E)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\rR\"\u0001\r\u0012#\u000e\tQ\u0001A\u0015\u000e\t\u0005C\u0001BE\u0007\u0003\u0019\u0003AB!F\u0001\u0019\u0005q\t\u0013kA\u0002\u000e\u0005\u0011\u0015\u0002b\u0005"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl;", "T", "Lcom/intellij/openapi/options/Scheme;", "E", "Lcom/intellij/openapi/options/ExternalizableScheme;", "Lcom/intellij/openapi/options/SchemesManager;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/io/File;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "virtualFileTrackerDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/io/File;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/Disposable;)V", "currentScheme", "Lcom/intellij/openapi/options/Scheme;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToDelete", "Lgnu/trove/THashSet;", "readOnlyExternalizableSchemes", "Lgnu/trove/THashMap;", "schemeExtension", "schemeToInfo", "Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "schemes", "Ljava/util/ArrayList;", "updateExtension", "", "useVfs", "fileName", "getFileName", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Ljava/lang/String;", "addNewScheme", "", "scheme", "replaceExisting", "(Lcom/intellij/openapi/options/Scheme;Z)V", "addVfsListener", "canRead", "name", "", "clearAllSchemes", "collectExistingNames", "", "deleteFiles", "errors", "", "", "findExternalizableSchemeByFileName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/ExternalizableScheme;", "findSchemeByName", "schemeName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/Scheme;", "getAllSchemeNames", "getAllSchemes", "kotlin.jvm.PlatformType", "", "getCurrentScheme", "()Lcom/intellij/openapi/options/Scheme;", "getDirectory", "getFileExtension", "allowAny", "getRootDirectory", "getState", "Lcom/intellij/openapi/options/SchemeProcessor$State;", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Lcom/intellij/openapi/options/SchemeProcessor$State;", "isMetadataEditable", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Z", "isMy", "file", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "isOverwriteOnLoad", "existingScheme", "isRenamed", "loadBundledScheme", "resourceName", "requestor", "", "convertor", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jdom/Element;", "loadScheme", "input", "Ljava/io/InputStream;", "duringLoad", "(Ljava/lang/CharSequence;Ljava/io/InputStream;Z)Lcom/intellij/openapi/options/ExternalizableScheme;", "loadSchemes", "readSchemeFromFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)Lcom/intellij/openapi/options/ExternalizableScheme;", "refreshVirtualDirectoryAndAddListener", "reload", "removeDirectoryIfEmpty", "removeExternalizableSchemes", "removeScheme", "(Lcom/intellij/openapi/options/Scheme;)V", "retainExternalInfo", "newSchemes", "save", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Lcom/intellij/openapi/options/ExternalizableScheme;Lcom/intellij/util/text/UniqueNameGenerator;)V", "setCurrent", "notify", "setSchemes", "newCurrentScheme", "removeCondition", "Lcom/intellij/openapi/util/Condition;", "(Ljava/util/List;Lcom/intellij/openapi/options/Scheme;Lcom/intellij/openapi/util/Condition;)V", "toString", "scheduleDelete", "ExternalInfo"}, moduleName="configuration-store-impl")
public final class SchemeManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    private final ArrayList<T> schemes;
    private final THashMap<String, E> readOnlyExternalizableSchemes;
    private T currentScheme;
    private VirtualFile directory;
    private final String schemeExtension;
    private final boolean updateExtension;
    private final THashSet<String> filesToDelete;
    private final THashMap<E, ExternalInfo> schemeToInfo;
    private final boolean useVfs;
    private final String fileSpec;
    private final SchemeProcessor<E> processor;
    private final StreamProvider provider;
    private final File ioDirectory;
    private final RoamingType roamingType;

    private final void refreshVirtualDirectoryAndAddListener(Disposable virtualFileTrackerDisposable) {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        if (virtualFile == null) {
            return;
        }
        this.directory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false, new Runnable(this, virtualFileTrackerDisposable){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ Disposable $virtualFileTrackerDisposable;

            public final void run() {
                SchemeManagerImpl.access$addVfsListener(this.this$0, this.$virtualFileTrackerDisposable);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$virtualFileTrackerDisposable = disposable;
            }
        });
    }

    private final void addVfsListener(Disposable virtualFileTrackerDisposable) {
        Object object = ServiceManager.getService(VirtualFileTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)object;
        String string = "file://" + StringsKt.replace$default((String)this.ioDirectory.getAbsolutePath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
        VirtualFileListener virtualFileListener = (VirtualFileListener)new VirtualFileAdapter(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null || !SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    return;
                }
                String string = event.getFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                E oldScheme = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                Object oldCurrentScheme = null;
                if (oldScheme != null) {
                    oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                    E e = oldScheme;
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    this.this$0.removeScheme((Scheme)e);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted(oldScheme);
                }
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                E newScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, virtualFile, false);
                if (newScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme(newScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded(newScheme);
                    this.updateCurrentScheme(oldCurrentScheme, newScheme);
                }
            }

            private final void updateCurrentScheme(T oldCurrentScheme, E newCurrentScheme) {
                if (Intrinsics.areEqual(oldCurrentScheme, SchemeManagerImpl.access$getCurrentScheme$p(this.this$0)) ^ true && SchemeManagerImpl.access$getCurrentScheme$p(this.this$0) == null) {
                    Scheme scheme = (Scheme)newCurrentScheme;
                    if (scheme == null) {
                        scheme = (Scheme)CollectionsKt.firstOrNull((List)SchemeManagerImpl.access$getSchemes$p(this.this$0));
                    }
                    this.this$0.setCurrent(scheme);
                }
            }

            static /* synthetic */ void updateCurrentScheme$default(addVfsListener.1 var0, Scheme scheme, ExternalizableScheme externalizableScheme, int n) {
                if ((n & 2) != 0) {
                    externalizableScheme = null;
                }
                var0.updateCurrentScheme(scheme, externalizableScheme);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        VirtualFile[] virtualFileArray = dir.getChildren();
                        for (int i = 0; i < virtualFileArray.length; ++i) {
                            VirtualFile file;
                            VirtualFile virtualFile = file = virtualFileArray[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                            if (!SchemeManagerImpl.access$isMy(this.this$0, virtualFile)) continue;
                            VirtualFile virtualFile2 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                            this.schemeCreatedExternally(virtualFile2);
                        }
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                    this.schemeCreatedExternally(virtualFile);
                }
            }

            private final void schemeCreatedExternally(VirtualFile file) {
                E readScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, file, false);
                if (readScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme(readScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded(readScheme);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                T oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory$p(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        SchemeManagerImpl.access$setDirectory$p(this.this$0, null);
                        SchemeManagerImpl.access$removeExternalizableSchemes(this.this$0);
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    E scheme;
                    String string = event.getFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                    E e = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                    if (e == null) {
                        return;
                    }
                    E e2 = scheme = e;
                    if (e2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    this.this$0.removeScheme((Scheme)e2);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted(scheme);
                }
                addVfsListener.1.updateCurrentScheme$default(this, oldCurrentScheme, null, 2);
            }
            {
                this.this$0 = $outer;
            }
        };
        Disposable disposable = virtualFileTrackerDisposable;
        if (disposable == null) {
            Intrinsics.throwNpe();
        }
        virtualFileTracker.addTracker(string, virtualFileListener, false, disposable);
    }

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull(convertor, (String)"convertor");
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                String extension = this.getFileExtension(charSequence, true);
                ExternalInfo info = new ExternalInfo(StringsKt.substring((String)fileName, (int)0, (int)(CollectionsKt.length((CharSequence)fileName) - CollectionsKt.length((CharSequence)extension))), extension);
                info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
                info.setSchemeName(((ExternalizableScheme)scheme).getName());
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.put((Object)((ExternalizableScheme)scheme2), (Object)info);
                ComponentStoreImplKt.getLOG().assertTrue(oldInfo == null);
                ExternalizableScheme oldScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.put((Object)((ExternalizableScheme)scheme).getName(), (Object)scheme);
                if (oldScheme != null) {
                    ComponentStoreImplKt.getLOG().warn("Duplicated scheme " + ((ExternalizableScheme)scheme).getName() + " - old: " + oldScheme + ", new " + scheme);
                }
            }
            this.schemes.add(scheme);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(CharSequence fileName, boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            string = ".xml";
        } else {
            String string2;
            if (allowAny) {
                string2 = PathUtil.getFileExtension((String)((Object)fileName).toString());
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
            }
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (allowAny) {\n      Pa\u2026t be filtered out\")\n    }");
        }
        return string;
    }

    private final boolean isMy(VirtualFileEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        return this.isMy(virtualFile);
    }

    private final boolean isMy(VirtualFile file) {
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.schemeExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<E> loadSchemes() {
        void $receiver;
        Object file;
        int n;
        File[] $receiver2 = (File[])this.schemes;
        int newSchemesOffset = $receiver2.size();
        if (this.provider != null && this.provider.getEnabled()) {
            this.provider.processChildren(this.fileSpec, this.roamingType, (Function1<? super String, ? extends Boolean>)((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SchemeManagerImpl.access$canRead(this.this$0, it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }), (Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input, boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    E scheme = SchemeManagerImpl.access$loadScheme(this.this$0, name, input, true);
                    if (readOnly && scheme != null) {
                        SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).put((Object)scheme.getName(), scheme);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(3);
                }
            }));
        } else {
            Unit unit;
            File[] fileArray = this.ioDirectory.listFiles(new FilenameFilter(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean accept(File parent, String name) {
                    CharSequence charSequence = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"name");
                    return SchemeManagerImpl.access$canRead(this.this$0, charSequence);
                }
                {
                    this.this$0 = schemeManagerImpl;
                }
            });
            if (fileArray != null) {
                $receiver2 = fileArray;
                File[] it = $receiver2;
                for (n = 0; n < it.length; ++n) {
                    file = it[n];
                    if (((File)file).isDirectory()) continue;
                    try {
                        CharSequence charSequence = ((File)file).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.name");
                        SchemeManagerImpl.super.loadScheme(charSequence, FilesKt.inputStream((File)file), true);
                        continue;
                    }
                    catch (Throwable e) {
                        ComponentStoreImplKt.getLOG().error("Cannot read scheme " + ((File)file).getPath(), e);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        SmartList list = new SmartList();
        int it = newSchemesOffset;
        file = this.schemes;
        n = $receiver.size() - 1;
        if (it <= n) {
            while (true) {
                void i;
                T t = this.schemes.get((int)i);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                ExternalizableScheme scheme = (ExternalizableScheme)t;
                this.processor.initScheme(scheme);
                list.add((Object)scheme);
                if (i == n) break;
                ++i;
            }
        }
        return (Collection)list;
    }

    public final void reload() {
        this.removeExternalizableSchemes();
        this.loadSchemes();
    }

    /*
     * Unable to fully structure code
     */
    private final void removeExternalizableSchemes() {
        block6: {
            v0 = RangesKt.reversed((IntRange)CollectionsKt.getIndices((Collection)this.schemes));
            var1_1 = ((Number)v0.getStart()).intValue();
            var2_2 = ((Number)v0.getEnd()).intValue();
            var3_3 = ((Number)v0.getIncrement()).intValue();
            var4_4 = ProgressionUtilKt.getProgressionFinalElement((int)var1_1, (int)var2_2, (int)var3_3);
            v1 = var1_1;
            v2 = var2_2;
            if (!(var3_3 > 0 ? v1 <= v2 : v1 >= v2)) break block6;
            while (true) {
                if (!((scheme = (Scheme)this.schemes.get((int)i)) instanceof ExternalizableScheme)) ** GOTO lbl-1000
                v3 = scheme;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                if (Intrinsics.areEqual((Object)this.getState((ExternalizableScheme)v3), (Object)SchemeProcessor.State.NON_PERSISTENT) ^ true) {
                    if (Intrinsics.areEqual((Object)scheme, this.currentScheme)) {
                        this.currentScheme = null;
                    }
                    v4 = scheme;
                    if (v4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    this.processor.onSchemeDeleted((ExternalizableScheme)v4);
                    v5 = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = Unit.INSTANCE;
                }
                if (i == var4_4) break;
                var1_1 = i + var3_3;
            }
        }
        this.retainExternalInfo((List)this.schemes);
    }

    private final E findExternalizableSchemeByFileName(String fileName) {
        for (Scheme scheme : this.schemes) {
            if (!(scheme instanceof ExternalizableScheme) || !Intrinsics.areEqual((Object)fileName, (Object)(this.getFileName((ExternalizableScheme)scheme) + this.schemeExtension))) continue;
            Scheme scheme2 = scheme;
            if (scheme2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            return (E)((ExternalizableScheme)scheme2);
        }
        return (E)((ExternalizableScheme)null);
    }

    private final boolean isOverwriteOnLoad(E existingScheme) {
        if ((ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)existingScheme.getName()) == existingScheme) {
            return true;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final E loadScheme(CharSequence fileName, InputStream input, boolean duringLoad) {
        try {
            block14: {
                block15: {
                    element = JDOMUtil.load((InputStream)input);
                    v0 = this.processor.readScheme(element, duringLoad);
                    if (v0 == null) {
                        return (E)((ExternalizableScheme)null);
                    }
                    scheme = v0;
                    extension = this.getFileExtension(fileName, false);
                    fileNameWithoutExtension = fileName.subSequence(0, CollectionsKt.length((CharSequence)fileName) - CollectionsKt.length((CharSequence)extension)).toString();
                    if (!duringLoad) break block14;
                    if (CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete)) && this.filesToDelete.contains((Object)fileName.toString())) {
                        ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because marked to delete");
                        return (E)((ExternalizableScheme)null);
                    }
                    v1 = scheme.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"scheme.name");
                    existingScheme = this.findSchemeByName(v1);
                    if (existingScheme == null) break block14;
                    if (!(existingScheme instanceof ExternalizableScheme)) break block15;
                    v2 = existingScheme;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    if (!this.isOverwriteOnLoad((ExternalizableScheme)v2)) break block15;
                    this.removeScheme(existingScheme);
                    break block14;
                }
                if (!(Intrinsics.areEqual((Object)this.schemeExtension, (Object)extension) ^ true)) ** GOTO lbl-1000
                var9_10 = (Map)this.schemeToInfo;
                var10_11 = $receiver;
                v3 = $receiver;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, V>");
                }
                v4 = (ExternalInfo)((Map)v3).get(existingScheme);
                if (Intrinsics.areEqual((Object)(v4 != null ? v4.getFileNameWithoutExtension() : null), (Object)fileNameWithoutExtension)) {
                    this.filesToDelete.add((Object)fileName.toString());
                } else lbl-1000:
                // 2 sources

                {
                    ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because defines duplicated name " + "\"" + scheme.getName() + "\"");
                }
                return (E)((ExternalizableScheme)null);
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
            info.setSchemeName(scheme.getName());
            if (duringLoad) {
                v5 = scheme;
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                v6 /* !! */  = Boolean.valueOf(this.schemes.add((Scheme)v5));
            } else {
                v7 = scheme;
                if (v7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                this.addScheme((Scheme)v7);
                v6 /* !! */  = Unit.INSTANCE;
            }
            return (E)scheme;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    private final String getFileName(ExternalizableScheme $receiver) {
        Map $receiver2 = (Map)this.schemeToInfo;
        Map $receiver3 = $receiver2;
        Map map = $receiver3;
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, V>");
        }
        ExternalInfo externalInfo = (ExternalInfo)map.get($receiver);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    private final boolean canRead(CharSequence name) {
        return this.updateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".xml") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.schemeExtension);
    }

    private final E readSchemeFromFile(VirtualFile file, boolean duringLoad) {
        CharSequence fileName;
        block5: {
            block4: {
                fileName = file.getNameSequence();
                if (file.isDirectory()) break block4;
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                if (this.canRead(charSequence)) break block5;
            }
            return (E)((ExternalizableScheme)null);
        }
        try {
            CharSequence charSequence = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
            return this.loadScheme(charSequence, inputStream, duringLoad);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    public final void save(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.schemes) {
            Unit unit;
            if (scheme instanceof ExternalizableScheme) {
                String fileName;
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                SchemeProcessor.State state = this.getState((ExternalizableScheme)scheme2);
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.NON_PERSISTENT)) continue;
                hasSchemes = true;
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.UNCHANGED) ^ true) {
                    schemesToSave.add((Object)scheme);
                }
                if ((fileName = this.getFileName((ExternalizableScheme)scheme)) != null && !this.isRenamed((ExternalizableScheme)scheme)) {
                    nameGenerator.addExistingName(fileName);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        for (Scheme scheme : schemesToSave) {
            try {
                Scheme scheme3 = scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheme3, (String)"scheme");
                this.saveScheme(scheme3, nameGenerator);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + "/" + scheme, e));
            }
        }
        if (!this.filesToDelete.isEmpty()) {
            this.deleteFiles(errors);
            if (!(hasSchemes || this.provider != null && this.provider.getEnabled())) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(List<Throwable> errors) {
        VirtualFile dir;
        boolean deleteUsingIo;
        Unit unit;
        File[] fileArray = this.ioDirectory.listFiles();
        if (fileArray != null) {
            File[] $receiver = fileArray;
            File[] it = $receiver;
            for (int i = 0; i < it.length; ++i) {
                File file = it[i];
                if (file.isHidden()) continue;
                ComponentStoreImplKt.getLOG().info("Directory " + this.ioDirectory.getName() + " is not deleted: at least one file " + file.getName() + " exists");
                return;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ComponentStoreImplKt.getLOG().info("Remove schemes directory " + this.ioDirectory.getName());
        this.directory = null;
        boolean bl = deleteUsingIo = !this.useVfs;
        if (!deleteUsingIo && (dir = this.getDirectory()) != null) {
            AccessToken token = WriteAction.start();
            try {
                dir.delete((Object)this);
            }
            catch (Throwable e) {
                deleteUsingIo = true;
                errors.add(e);
            }
            finally {
                token.finish();
            }
        }
        if (deleteUsingIo) {
            List<Throwable> $receiver = errors;
            try {
                FileUtil.delete((File)this.ioDirectory);
            }
            catch (Throwable e) {
                $receiver.add(e);
            }
        }
    }

    private final SchemeProcessor.State getState(E scheme) {
        return this.processor.getState(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveScheme(E scheme, UniqueNameGenerator nameGenerator) {
        boolean renamed;
        String providerPath;
        Element element;
        Element element2;
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
        String currentFileNameWithoutExtension = externalInfo == null ? (String)null : externalInfo.getFileNameWithoutExtension();
        Parent parent = this.processor.writeScheme(scheme);
        if (parent == null || parent instanceof Element) {
            element2 = (Element)parent;
        } else {
            Parent parent2 = parent;
            if (parent2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jdom.Document");
            }
            element2 = element = ((Document)parent2).detachRootElement();
        }
        if (JDOMUtil.isEmpty((Element)element)) {
            Unit unit;
            ExternalInfo externalInfo2 = externalInfo;
            if (externalInfo2 != null) {
                this.scheduleDelete(externalInfo2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed((ExternalizableScheme)scheme)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName((String)scheme.getName(), (boolean)false));
        }
        Element element3 = element;
        if (element3 == null) {
            Intrinsics.throwNpe();
        }
        int newHash = JDOMUtil.getTreeHash((Element)element3, (boolean)true);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
            return;
        }
        ExternalizableScheme bundledScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)scheme.getName());
        if (bundledScheme != null) {
            ExternalInfo externalInfo3 = (ExternalInfo)this.schemeToInfo.get((Object)bundledScheme);
            if (Intrinsics.areEqual((Object)(externalInfo3 != null ? Integer.valueOf(externalInfo3.getHash()) : null), (Object)newHash)) {
                Unit unit;
                ExternalInfo externalInfo4 = externalInfo;
                if (externalInfo4 != null) {
                    this.scheduleDelete(externalInfo4);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = fileNameWithoutExtension;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String fileName = stringBuilder.append(string).append(this.schemeExtension).toString();
        this.filesToDelete.remove((Object)fileName);
        BufferExposingByteArrayOutputStream byteOut = FileBasedStorageKt.toBufferExposingByteArray$default((Parent)element, null, 1);
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + '/' + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (this.useVfs) {
                AccessToken token;
                void file;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                VirtualFile dir = this.getDirectory();
                if (dir == null || !dir.isValid()) {
                    this.directory = dir = SchemeManagerImplKt.createDir(this.ioDirectory, (Object)this);
                }
                if (renamed) {
                    ExternalInfo externalInfo5 = externalInfo;
                    if (externalInfo5 == null) {
                        Intrinsics.throwNpe();
                    }
                    file.element = dir.findChild(externalInfo5.getFileName());
                    if ((VirtualFile)file.element != null) {
                        token = WriteAction.start();
                        try {
                            VirtualFile virtualFile = (VirtualFile)file.element;
                            if (virtualFile == null) {
                                Intrinsics.throwNpe();
                            }
                            virtualFile.rename((Object)this, fileName);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            token.finish();
                        }
                    }
                }
                if ((VirtualFile)file.element == null) {
                    file.element = SchemeManagerImplKt.getFile(fileName, dir, (Object)this);
                }
                token = WriteAction.start();
                try {
                    void $receiver;
                    VirtualFile virtualFile = (VirtualFile)file.element;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Closeable $i$a$1 = virtualFile.getOutputStream((Object)this);
                    boolean closed = false;
                    try {
                        OutputStream it = (OutputStream)$receiver;
                        byteOut.writeTo(it);
                        it = Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        closed = true;
                        try {
                            $receiver.close();
                        }
                        catch (Exception closeException) {
                            // empty catch block
                        }
                        throw (Throwable)e;
                    }
                    finally {
                        if (!closed) {
                            $receiver.close();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    token.finish();
                }
                objectRef = null;
            } else {
                if (renamed) {
                    ExternalInfo externalInfo6 = externalInfo;
                    if (externalInfo6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.scheduleDelete(externalInfo6);
                }
                FileUtil.writeToFile((File)new File(this.ioDirectory, fileName), (byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size());
            }
        } else {
            if (renamed) {
                ExternalInfo externalInfo7 = externalInfo;
                if (externalInfo7 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(externalInfo7);
            }
            StreamProvider streamProvider = this.provider;
            if (streamProvider == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteOut.internalBuffer");
            streamProvider.write(providerPath, byArray, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setSchemeName(scheme.getName());
    }

    private final void scheduleDelete(ExternalInfo $receiver) {
        this.filesToDelete.add((Object)$receiver.getFileName());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRenamed(ExternalizableScheme scheme) {
        void $receiver;
        Map $receiver2 = (Map)this.schemeToInfo;
        Map map = $receiver2;
        void v0 = $receiver;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, V>");
        }
        ExternalInfo info = (ExternalInfo)((Map)v0).get(scheme);
        return info != null && Intrinsics.areEqual((Object)scheme.getName(), (Object)info.getSchemeName()) ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void deleteFiles(List<Throwable> errors) {
        VirtualFile file;
        void $receiver;
        boolean deleteUsingIo;
        if (this.provider != null && this.provider.getEnabled()) {
            deleteUsingIo = false;
            for (String name : this.filesToDelete) {
                VirtualFile virtualFile = errors;
                try {
                    String spec = this.fileSpec + "/" + name;
                    if (!this.provider.isApplicable(spec, this.roamingType)) continue;
                    this.provider.delete(spec, this.roamingType);
                }
                catch (Throwable e) {
                    $receiver.add(e);
                }
            }
        } else if (!this.useVfs) {
            deleteUsingIo = true;
        } else {
            VirtualFile dir = this.getDirectory();
            boolean bl = deleteUsingIo = dir == null;
            if (!deleteUsingIo) {
                AccessToken token = null;
                try {
                    VirtualFile virtualFile = dir;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile[] $i$a$1 = virtualFile.getChildren();
                    for (int spec = 0; spec < $i$a$1.length; ++spec) {
                        file = $i$a$1[spec];
                        if (!this.filesToDelete.contains((Object)file.getName())) continue;
                        if (token == null) {
                            token = WriteAction.start();
                        }
                        VirtualFile e = errors;
                        try {
                            file.delete((Object)this);
                            continue;
                        }
                        catch (Throwable e2) {
                            void $receiver2;
                            $receiver2.add(e2);
                        }
                    }
                }
                finally {
                    if (token != null) {
                        token.finish();
                    }
                }
            }
        }
        if (deleteUsingIo) {
            for (String name : this.filesToDelete) {
                file = errors;
                try {
                    FileUtil.delete((File)new File(this.ioDirectory, name));
                }
                catch (Throwable e) {
                    $receiver.add(e);
                }
            }
        }
        this.filesToDelete.clear();
    }

    private final VirtualFile getDirectory() {
        VirtualFile result2 = this.directory;
        if (result2 == null) {
            this.directory = result2 = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        }
        return result2;
    }

    @NotNull
    public File getRootDirectory() {
        return this.ioDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        T oldCurrentScheme = this.currentScheme;
        if (removeCondition == null) {
            this.schemes.clear();
        } else {
            IntProgression intProgression = RangesKt.reversed((IntRange)CollectionsKt.getIndices((Collection)this.schemes));
            int n = ((Number)intProgression.getStart()).intValue();
            int n2 = ((Number)intProgression.getEnd()).intValue();
            int n3 = ((Number)intProgression.getIncrement()).intValue();
            int n4 = ProgressionUtilKt.getProgressionFinalElement((int)n, (int)n2, (int)n3);
            int n5 = n;
            int n6 = n2;
            if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void i;
                    if (removeCondition.value(this.schemes.get((int)i))) {
                        CollectionsKt.remove((List)this.schemes, (int)i);
                    }
                    if (i == n4) break;
                    i += n3;
                }
            }
        }
        this.retainExternalInfo(newSchemes);
        this.schemes.addAll((Collection)newSchemes);
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            if (newCurrentScheme != null) {
                this.currentScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.schemes.contains(oldCurrentScheme)) {
                this.currentScheme = (Scheme)CollectionsKt.firstOrNull((List)this.schemes);
            }
            if (Intrinsics.areEqual(oldCurrentScheme, this.currentScheme) ^ true) {
                this.processor.onCurrentSchemeChanged(oldCurrentScheme);
            }
        }
    }

    private final void retainExternalInfo(List<? extends T> newSchemes) {
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries(new TObjectObjectProcedure<E, ExternalInfo>(this, newSchemes){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ List $newSchemes;

            public boolean execute(@NotNull E scheme, @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                if (Intrinsics.areEqual((Object)((ExternalizableScheme)SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).get((Object)scheme.getName())), scheme)) {
                    return true;
                }
                for (Scheme t : this.$newSchemes) {
                    if (t != scheme) continue;
                    if (CollectionsKt.isNotEmpty((Collection)((Collection)SchemeManagerImpl.access$getFilesToDelete$p(this.this$0)))) {
                        SchemeManagerImpl.access$getFilesToDelete$p(this.this$0).remove((Object)String.valueOf(info.getFileName()));
                    }
                    return true;
                }
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$newSchemes = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        Scheme existing;
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        int toReplace = -1;
        IntRange intRange = CollectionsKt.getIndices((Collection)this.schemes);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                if (Intrinsics.areEqual((Object)(existing = (Scheme)this.schemes.get((int)i)).getName(), (Object)scheme.getName())) {
                    void $receiver;
                    void $receiver2;
                    if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                        ComponentStoreImplKt.getLOG().warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                    }
                    toReplace = i;
                    if (!replaceExisting || !(existing instanceof ExternalizableScheme)) break;
                    Scheme scheme2 = existing;
                    if (scheme2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.remove((Object)((ExternalizableScheme)scheme2));
                    if (oldInfo == null || !(scheme instanceof ExternalizableScheme)) break;
                    Map map = (Map)this.schemeToInfo;
                    void var9_11 = $receiver2;
                    void v2 = $receiver;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, *>");
                    }
                    if (((Map)v2).containsKey(scheme)) break;
                    T t = scheme;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    this.schemeToInfo.put((Object)((ExternalizableScheme)t), (Object)oldInfo);
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (toReplace == -1) {
            this.schemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.schemes.set(toReplace, scheme);
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme).getName(), this.collectExistingNames((Collection)this.schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            SchemeManagerImplKt.access$renameScheme(externalizableScheme, string);
            this.schemes.add(scheme);
        }
        if (scheme instanceof ExternalizableScheme && CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete))) {
            void $receiver;
            void $receiver3;
            Map map = (Map)this.schemeToInfo;
            existing = $receiver3;
            void v6 = $receiver;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Map<kotlin.Any?, V>");
            }
            ExternalInfo info = (ExternalInfo)((Map)v6).get(scheme);
            if (info != null) {
                this.filesToDelete.remove((Object)String.valueOf(info.getFileName()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        void $receiver;
        THashSet tHashSet;
        Collection<T> collection = schemes;
        THashSet tHashSet2 = tHashSet;
        THashSet tHashSet3 = tHashSet;
        int n = $receiver.size();
        tHashSet2(n);
        THashSet result2 = tHashSet3;
        for (Scheme scheme : schemes) {
            result2.add((Object)scheme.getName());
        }
        return (Collection)result2;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public boolean execute(@NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.currentScheme = null;
        this.schemes.clear();
        this.schemeToInfo.clear();
    }

    public List<T> getAllSchemes() {
        return Collections.unmodifiableList((List)this.schemes);
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        for (Scheme scheme : this.schemes) {
            if (!Intrinsics.areEqual((Object)scheme.getName(), (Object)schemeName)) continue;
            return (T)scheme;
        }
        return (T)((Scheme)null);
    }

    public void setCurrent(@Nullable T scheme, boolean notify) {
        T oldCurrent = this.currentScheme;
        this.currentScheme = scheme;
        if (notify && Intrinsics.areEqual(oldCurrent, scheme) ^ true) {
            this.processor.onCurrentSchemeChanged(oldCurrent);
        }
    }

    @Nullable
    public T getCurrentScheme() {
        return this.currentScheme;
    }

    /*
     * WARNING - void declaration
     */
    public void removeScheme(@NotNull T scheme) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        Collection collection = this.schemes;
        IntProgression intProgression = RangesKt.downTo((int)($receiver.size() - 1), (int)0);
        int n = ((Number)intProgression.getStart()).intValue();
        int n2 = ((Number)intProgression.getEnd()).intValue();
        int n3 = ((Number)intProgression.getIncrement()).intValue();
        int n4 = ProgressionUtilKt.getProgressionFinalElement((int)n, (int)n2, (int)n3);
        int n5 = n;
        int n6 = n2;
        if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                Scheme s = (Scheme)this.schemes.get((int)i);
                if (Intrinsics.areEqual((Object)scheme.getName(), (Object)s.getName())) {
                    if (Intrinsics.areEqual(this.currentScheme, (Object)s)) {
                        this.currentScheme = null;
                    }
                    if (s instanceof ExternalizableScheme) {
                        Unit unit;
                        Scheme scheme2 = s;
                        if (scheme2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type E");
                        }
                        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.remove((Object)((ExternalizableScheme)scheme2));
                        if (externalInfo != null) {
                            this.scheduleDelete(externalInfo);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    CollectionsKt.remove((List)this.schemes, (int)i);
                    break;
                }
                if (i == n4) break;
                n = i + n3;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getAllSchemeNames() {
        void $receiver;
        ArrayList<String> arrayList;
        if (this.schemes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = this.schemes;
        ArrayList<String> arrayList2 = arrayList;
        ArrayList<String> arrayList3 = arrayList;
        int n = $receiver.size();
        arrayList2(n);
        ArrayList<String> names = arrayList3;
        for (Scheme scheme : this.schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    public boolean isMetadataEditable(@NotNull E scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        return !this.readOnlyExternalizableSchemes.containsKey((Object)scheme.getName());
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    public SchemeManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor2, @Nullable StreamProvider provider, @NotNull File ioDirectory, @NotNull RoamingType roamingType, @Nullable Disposable virtualFileTrackerDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.fileSpec = fileSpec;
        this.processor = processor2;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.schemes = new ArrayList();
        this.readOnlyExternalizableSchemes = new THashMap();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(ContainerUtil.identityStrategy());
        boolean bl = this.useVfs = virtualFileTrackerDisposable != null;
        if (this.processor instanceof SchemeExtensionProvider) {
            String string = ((SchemeExtensionProvider)this.processor).getSchemeExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processor.schemeExtension");
            this.schemeExtension = string;
            this.updateExtension = ((SchemeExtensionProvider)this.processor).isUpgradeNeeded();
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.useVfs && (this.provider == null || !this.provider.getEnabled())) {
            try {
                this.refreshVirtualDirectoryAndAddListener(virtualFileTrackerDisposable);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, File file, RoamingType roamingType, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            disposable = null;
        }
        this(string, schemeProcessor, streamProvider, file, roamingType, disposable);
    }

    @NotNull
    public static final /* synthetic */ ArrayList<T> access$getSchemes$p(SchemeManagerImpl<T, E> $this) {
        return $this.schemes;
    }

    @NotNull
    public static final /* synthetic */ THashMap<String, E> access$getReadOnlyExternalizableSchemes$p(SchemeManagerImpl<T, E> $this) {
        return $this.readOnlyExternalizableSchemes;
    }

    @Nullable
    public static final /* synthetic */ T access$getCurrentScheme$p(SchemeManagerImpl<T, E> $this) {
        return $this.currentScheme;
    }

    public static final /* synthetic */ void access$setCurrentScheme$p(SchemeManagerImpl<T, E> $this, @Nullable T t) {
        $this.currentScheme = t;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory$p(SchemeManagerImpl<T, E> $this) {
        return $this.directory;
    }

    public static final /* synthetic */ void access$setDirectory$p(SchemeManagerImpl<T, E> $this, @Nullable VirtualFile virtualFile) {
        $this.directory = virtualFile;
    }

    @NotNull
    public static final /* synthetic */ THashSet<String> access$getFilesToDelete$p(SchemeManagerImpl<T, E> $this) {
        return $this.filesToDelete;
    }

    public static final /* synthetic */ void access$addVfsListener(SchemeManagerImpl<T, E> $this, @Nullable Disposable virtualFileTrackerDisposable) {
        super.addVfsListener(virtualFileTrackerDisposable);
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl<T, E> $this, @NotNull VirtualFileEvent event) {
        return super.isMy(event);
    }

    @Nullable
    public static final /* synthetic */ E access$findExternalizableSchemeByFileName(SchemeManagerImpl<T, E> $this, @NotNull String fileName) {
        return super.findExternalizableSchemeByFileName(fileName);
    }

    @NotNull
    public static final /* synthetic */ SchemeProcessor<E> access$getProcessor$p(SchemeManagerImpl<T, E> $this) {
        return $this.processor;
    }

    @Nullable
    public static final /* synthetic */ E access$readSchemeFromFile(SchemeManagerImpl<T, E> $this, @NotNull VirtualFile file, boolean duringLoad) {
        return super.readSchemeFromFile(file, duringLoad);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory(SchemeManagerImpl<T, E> $this) {
        return super.getDirectory();
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl<T, E> $this, @NotNull VirtualFile file) {
        return super.isMy(file);
    }

    public static final /* synthetic */ void access$removeExternalizableSchemes(SchemeManagerImpl<T, E> $this) {
        super.removeExternalizableSchemes();
    }

    public static final /* synthetic */ boolean access$canRead(SchemeManagerImpl<T, E> $this, @NotNull CharSequence name) {
        return super.canRead(name);
    }

    public static final /* synthetic */ void access$scheduleDelete(SchemeManagerImpl<T, E> $this, ExternalInfo $receiver) {
        super.scheduleDelete($receiver);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA1B\u0003\u0002\u0011\u0011)\u0011\u0001b\u0002\u0006\u0003!\tQ!\u0001C\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005^\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0002#\u000e\t\u0001RA\u0013\f\u0011\u001bi\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\u00023\rAI\"D\u0001\u0019\u0004\u0015\"Aa\u0003\u0005\u000e\u001b\u0005A\u001a!\u000b\b\u0005\u0007rA!!\u0004\u0002\r\u0002a\r\u0011kA\u0004\u0006\u00015\u0011Aa\u0001E\u0004#\t!A\u0001#\u0003*\u0015\u0011\u0019\u0005\u0002C\u0003\u000e\u0003a\rAdI)\u0004\u00075\u0011A1\u0002E\u0004S5!1\t\b\u0005\u0002\u001b\u0005A\u001a!U\u0002\b\u000b\u0001i!\u0001\u0002\u0004\t\bE\u0011AQ\u0002E\u0005S5!1\t\b\u0005\b\u001b\u0005Az!U\u0002\b\u000b\u0001i!\u0001\u0002\u0005\t\u0012E\u0011A!\u0003E\nS9!1\t\b\u0005\u000b\u001b\ta\t\u0001g\u0001R\u0007\u001d)\u0001!\u0004\u0002\u0005\u0016!\u001d\u0011C\u0001\u0003\f\u0011\u0013\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "", "fileNameWithoutExtension", "", "fileExtension", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "setFileExtension", "(Ljava/lang/String;)V", "fileName", "getFileName", "getFileNameWithoutExtension", "setFileNameWithoutExtension", "hash", "", "getHash", "()I", "setHash", "(I)V", "schemeName", "getSchemeName", "setSchemeName", "", "nameWithoutExtension", "extension", "toString"}, moduleName="configuration-store-impl")
    private static final class ExternalInfo {
        @Nullable
        private String schemeName;
        private int hash;
        @NotNull
        private String fileNameWithoutExtension;
        @Nullable
        private String fileExtension;

        @Nullable
        public final String getSchemeName() {
            return this.schemeName;
        }

        public final void setSchemeName(@Nullable String string) {
            this.schemeName = string;
        }

        public final int getHash() {
            return this.hash;
        }

        public final void setHash(int n) {
            this.hash = n;
        }

        @NotNull
        public final String getFileName() {
            return this.fileNameWithoutExtension + this.fileExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String nameWithoutExtension, @NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)nameWithoutExtension, (String)"nameWithoutExtension");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        @NotNull
        public String toString() {
            return this.getFileName();
        }

        @NotNull
        public final String getFileNameWithoutExtension() {
            return this.fileNameWithoutExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.fileNameWithoutExtension = string;
        }

        @Nullable
        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(@Nullable String string) {
            this.fileExtension = string;
        }

        public ExternalInfo(@NotNull String fileNameWithoutExtension, @Nullable String fileExtension) {
            Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }
    }
}

