/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    JPanel myPanel;
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private JRadioButton myRbListen;
    private JRadioButton myRbAttach;
    private JTextField myAddressField;
    private JTextField myHostField;
    private JTextField myPortField;
    private JPanel myShmemPanel;
    private JPanel mySocketPanel;
    private ConfigurationArgumentsHelpArea myHelpArea;
    @NonNls
    private ConfigurationArgumentsHelpArea myJDK13HelpArea;
    private ConfigurationArgumentsHelpArea myJDK14HelpArea;
    private LabeledComponent<ModulesComboBox> myModule;
    private String myHostName = "";
    @NonNls
    protected static final String LOCALHOST = "localhost";
    private final ConfigurationModuleSelector myModuleSelector;

    public RemoteConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myHelpArea.setLabelText(ExecutionBundle.message((String)"remote.configuration.remote.debugging.allows.you.to.connect.idea.to.a.running.jvm.label", (Object[])new Object[0]));
        this.myHelpArea.setToolbarVisible();
        this.myJDK13HelpArea.setLabelText(ExecutionBundle.message((String)"environment.variables.helper.use.arguments.jdk13.label", (Object[])new Object[0]));
        this.myJDK13HelpArea.setToolbarVisible();
        this.myJDK14HelpArea.setLabelText(ExecutionBundle.message((String)"environment.variables.helper.use.arguments.jdk14.label", (Object[])new Object[0]));
        this.myJDK14HelpArea.setToolbarVisible();
        ButtonGroup transportGroup = new ButtonGroup();
        transportGroup.add(this.myRbSocket);
        transportGroup.add(this.myRbShmem);
        ButtonGroup connectionGroup = new ButtonGroup();
        connectionGroup.add(this.myRbListen);
        connectionGroup.add(this.myRbAttach);
        DocumentAdapter helpTextUpdater = new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myRbSocket.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source.equals(RemoteConfigurable.this.myRbSocket)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(false);
                    RemoteConfigurable.this.mySocketPanel.setVisible(true);
                } else if (source.equals(RemoteConfigurable.this.myRbShmem)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(true);
                    RemoteConfigurable.this.mySocketPanel.setVisible(false);
                }
                RemoteConfigurable.this.myPanel.repaint();
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbShmem.addActionListener(listener);
        this.myRbSocket.addActionListener(listener);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isAttach = RemoteConfigurable.this.myRbAttach.isSelected();
                if (!isAttach && RemoteConfigurable.this.myHostField.isEditable()) {
                    RemoteConfigurable.this.myHostName = RemoteConfigurable.this.myHostField.getText();
                }
                RemoteConfigurable.this.myHostField.setEditable(isAttach);
                RemoteConfigurable.this.myHostField.setEnabled(isAttach);
                RemoteConfigurable.this.myHostField.setText(isAttach ? RemoteConfigurable.this.myHostName : RemoteConfigurable.LOCALHOST);
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbAttach.addItemListener(updateListener);
        this.myRbListen.addItemListener(updateListener);
        FocusAdapter fieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.addFocusListener(fieldFocusListener);
        this.myPortField.addFocusListener(fieldFocusListener);
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)((Object)this.myModule.getComponent()), "<whole project>");
    }

    public void applyEditorTo(@NotNull RemoteConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/remote/RemoteConfigurable", "applyEditorTo"));
        }
        configuration.HOST = (this.myHostField.isEditable() ? this.myHostField.getText() : this.myHostName).trim();
        if (configuration.HOST != null && configuration.HOST.isEmpty()) {
            configuration.HOST = null;
        }
        configuration.PORT = this.myPortField.getText().trim();
        if (configuration.PORT != null && configuration.PORT.isEmpty()) {
            configuration.PORT = null;
        }
        configuration.SHMEM_ADDRESS = this.myAddressField.getText().trim();
        if (configuration.SHMEM_ADDRESS != null && configuration.SHMEM_ADDRESS.isEmpty()) {
            configuration.SHMEM_ADDRESS = null;
        }
        configuration.USE_SOCKET_TRANSPORT = this.myRbSocket.isSelected();
        configuration.SERVER_MODE = this.myRbListen.isSelected();
        this.myModuleSelector.applyTo(configuration);
    }

    public void resetEditorFrom(RemoteConfiguration configuration) {
        if (!SystemInfo.isWindows) {
            configuration.USE_SOCKET_TRANSPORT = true;
            this.myRbShmem.setEnabled(false);
            this.myAddressField.setEditable(false);
        }
        this.myAddressField.setText(configuration.SHMEM_ADDRESS);
        this.myHostName = configuration.HOST;
        this.myHostField.setText(configuration.HOST);
        this.myPortField.setText(configuration.PORT);
        if (configuration.USE_SOCKET_TRANSPORT) {
            this.myRbSocket.doClick();
        } else {
            this.myRbShmem.doClick();
        }
        if (configuration.SERVER_MODE) {
            this.myRbListen.doClick();
        } else {
            this.myRbAttach.doClick();
        }
        this.myRbShmem.setEnabled(SystemInfo.isWindows);
        this.myModuleSelector.reset(configuration);
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/remote/RemoteConfigurable", "createEditor"));
        }
        return jPanel;
    }

    private void updateHelpText() {
        boolean useSockets = !this.myRbShmem.isSelected();
        RemoteConnection connection = new RemoteConnection(useSockets, this.myHostName, useSockets ? this.myPortField.getText().trim() : this.myAddressField.getText().trim(), this.myRbListen.isSelected());
        String cmdLine = connection.getLaunchCommandLine();
        String jvmtiCmdLine = cmdLine.replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
        this.myHelpArea.updateText(jvmtiCmdLine);
        this.myJDK14HelpArea.updateText(cmdLine);
        this.myJDK13HelpArea.updateText("-Xnoagent -Djava.compiler=NONE " + cmdLine);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea;
        LabeledComponent labeledComponent;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea2;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.settings.border"), (int)0, (int)0, null, null));
        this.mySocketPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.host.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.port.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, new Dimension(150, -1), null));
        this.myShmemPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.address.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.transport.label"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbSocket = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.socket.radio"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbShmem = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.radio"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.debugger.mode.label"));
        jPanel4.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbAttach = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.attach.radio"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbListen = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.listen.radio"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHelpArea = configurationArgumentsHelpArea3 = new ConfigurationArgumentsHelpArea();
        ((Component)configurationArgumentsHelpArea3).setVisible(true);
        jPanel3.add((Component)configurationArgumentsHelpArea3, new GridConstraints(0, 0, 1, 1, 9, 1, 3, 0, null, null, null));
        this.myJDK13HelpArea = configurationArgumentsHelpArea2 = new ConfigurationArgumentsHelpArea();
        ((Component)configurationArgumentsHelpArea2).setVisible(true);
        jPanel3.add((Component)configurationArgumentsHelpArea2, new GridConstraints(2, 0, 1, 1, 9, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText("Search sources using m&odule's classpath:");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setVisible(true);
        jPanel3.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myJDK14HelpArea = configurationArgumentsHelpArea = new ConfigurationArgumentsHelpArea();
        ((Component)configurationArgumentsHelpArea).setVisible(true);
        jPanel3.add((Component)configurationArgumentsHelpArea, new GridConstraints(1, 0, 1, 1, 9, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

