/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RerunTestsNotification {
    private static final String KEY = "rerun.tests.notification.shown";

    public static void showRerunNotification(@Nullable RunContentDescriptor contentToReuse, final @NotNull ExecutionConsole executionConsole) {
        boolean showNotification;
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/intellij/execution/runners/RerunTestsNotification", "showRerunNotification"));
        }
        if (contentToReuse == null) {
            return;
        }
        String lastActionId = ActionManagerEx.getInstanceEx().getPrevPreformedActionId();
        boolean bl = showNotification = !"RerunTests".equals(lastActionId);
        if (showNotification && !PropertiesComponent.getInstance().isTrueValue(KEY)) {
            UiNotifyConnector.doWhenFirstShown((JComponent)executionConsole.getComponent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RerunTestsNotification.doShow(executionConsole);
                }
            });
        }
    }

    private static void doShow(final @NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionConsole", "com/intellij/execution/runners/RerunTestsNotification", "doShow"));
        }
        final Alarm alarm = new Alarm();
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RerunTests"));
                if (shortcutText.isEmpty()) {
                    return;
                }
                GotItMessage message = GotItMessage.createMessage("Rerun tests with " + shortcutText, "");
                message.setDisposable((Disposable)executionConsole);
                message.setCallback(new Runnable(){

                    @Override
                    public void run() {
                        PropertiesComponent.getInstance().setValue(RerunTestsNotification.KEY, true);
                    }
                });
                message.setShowCallout(false);
                Dimension consoleSize = executionConsole.getComponent().getSize();
                message.show(new RelativePoint((Component)executionConsole.getComponent(), new Point(consoleSize.width - 185, consoleSize.height - 60)), Balloon.Position.below);
                Disposer.dispose((Disposable)alarm);
            }
        }, 1000);
    }
}

