/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JList myFileList;
    private JRadioButton myUnlockAllButton;

    protected NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<VirtualFile> nonProjectFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        if (nonProjectFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonProjectFiles", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Non-Project Files Access");
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.myFileList.setModel(new CollectionListModel(nonProjectFiles));
        this.getOKAction().putValue("DefaultAction", null);
        this.getCancelAction().putValue("DefaultAction", true);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public NonProjectFileWritingAccessProvider.UnlockOption getUnlockOption() {
        NonProjectFileWritingAccessProvider.UnlockOption unlockOption = this.myUnlockAllButton.isSelected() ? NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_ALL : NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK;
        if (unlockOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog", "getUnlockOption"));
        }
        return unlockOption;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JRadioButton jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("I want to edit these files anyway");
        jRadioButton2.setSelected(true);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockAllButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("I want to edit any non-project file in the current session");
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("These files do not belong to the project");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myFileList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

