/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JTree;
import org.jetbrains.jps.model.JpsElement;

public class ToggleSourcesStateAction<P extends JpsElement>
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;
    private final ModuleSourceRootEditHandler<P> myEditHandler;

    public ToggleSourcesStateAction(JTree tree, ContentEntryTreeEditor entryEditor, ModuleSourceRootEditHandler<P> editHandler) {
        super(tree);
        this.myEntryTreeEditor = entryEditor;
        this.myEditHandler = editHandler;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(editHandler.getMarkRootButtonText());
        templatePresentation.setDescription(ProjectBundle.message((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getRootTypeName()}));
        templatePresentation.setIcon(editHandler.getRootIcon());
    }

    public boolean isSelected(AnActionEvent e) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return false;
        }
        ContentEntryEditor editor = this.myEntryTreeEditor.getContentEntryEditor();
        return this.myEditHandler.getRootType().equals(editor.getRootType(selectedFiles[0]));
    }

    public void setSelected(AnActionEvent e, boolean isSelected) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles.length != 0);
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        for (VirtualFile selectedFile : selectedFiles) {
            SourceFolder sourceFolder = contentEntryEditor.getSourceFolder(selectedFile);
            if (isSelected) {
                JpsElement properties;
                if (sourceFolder == null) {
                    properties = (JpsElement)this.myEditHandler.getRootType().createDefaultProperties();
                    contentEntryEditor.addSourceFolder(selectedFile, this.myEditHandler.getRootType(), properties);
                    continue;
                }
                if (this.myEditHandler.getRootType().equals((Object)sourceFolder.getRootType())) continue;
                properties = this.myEditHandler.getRootType().getClass().equals(sourceFolder.getRootType().getClass()) ? sourceFolder.getJpsElement().getProperties().getBulkModificationSupport().createCopy() : (JpsElement)this.myEditHandler.getRootType().createDefaultProperties();
                contentEntryEditor.removeSourceFolder(sourceFolder);
                contentEntryEditor.addSourceFolder(selectedFile, this.myEditHandler.getRootType(), properties);
                continue;
            }
            if (sourceFolder == null) continue;
            contentEntryEditor.removeSourceFolder(sourceFolder);
        }
    }
}

