/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.diff.Block;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.FindBlock;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.history.impl.CachedRevisionsContents;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.HashMap;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SortableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryDialog
extends DialogWrapper
implements DataProvider {
    private final Editor myEditor;
    private final int mySelectionStart;
    private final int mySelectionEnd;
    private final Map<VcsFileRevision, Block> myRevisionToContentMap = new HashMap();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.impl.VcsHistoryDialog");
    private final AbstractVcs myActiveVcs;
    private final DiffRequestPanel myDiffPanel;
    private final Project myProject;
    private static final ColumnInfo REVISION = new ColumnInfo(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getRevisionNumber();
        }
    };
    private static final ColumnInfo DATE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.date", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            Date date = ((VcsFileRevision)object).getRevisionDate();
            if (date == null) {
                return "";
            }
            return DateFormatUtil.formatPrettyDateTime((Date)date);
        }
    };
    private static final ColumnInfo MESSAGE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.message", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getCommitMessage();
        }
    };
    private static final ColumnInfo AUTHOR = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getAuthor();
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{REVISION, DATE, AUTHOR, MESSAGE};
    private final TableView myList;
    protected final List<VcsFileRevision> myRevisions;
    private final Splitter mySplitter;
    private final VirtualFile myFile;
    private final JCheckBox myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
    private final CachedRevisionsContents myCachedContents;
    private final JTextArea myComments = new JTextArea();
    private static final int CURRENT = 0;
    private boolean myIsInLoading = false;
    @NonNls
    private final String myHelpId;
    private boolean myIsDisposed = false;
    private final FileType myContentFileType;

    public VcsHistoryDialog(Project project, VirtualFile file, Editor editor, VcsHistoryProvider vcsHistoryProvider, VcsHistorySession session, AbstractVcs vcs, int selectionStart, int selectionEnd, String title, CachedRevisionsContents cachedContents) {
        super(project, true);
        this.myProject = project;
        this.myEditor = editor;
        this.mySelectionStart = selectionStart;
        this.mySelectionEnd = selectionEnd;
        this.myCachedContents = cachedContents;
        this.setTitle(title);
        this.myActiveVcs = vcs;
        this.myRevisions = new ArrayList<VcsFileRevision>();
        this.myFile = file;
        String helpId = vcsHistoryProvider.getHelpId();
        this.myHelpId = helpId != null ? helpId : "reference.dialogs.vcs.selection.history";
        final VcsDependentHistoryComponents components = vcsHistoryProvider.getUICustomization(session, (JComponent)this.getRootPane());
        this.myList = new TableView(new ListTableModel(VcsHistoryDialog.createColumns(components.getColumns())));
        ((SortableColumnModel)this.myList.getModel()).setSortable(false);
        this.myList.getEmptyText().setText(VcsBundle.message((String)"history.empty", (Object[])new Object[0]));
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, this.getDisposable(), this.getWindow());
        this.myRevisions.addAll(session.getRevisionList());
        VcsRevisionNumber currentRevisionNumber = session.getCurrentRevisionNumber();
        if (currentRevisionNumber != null) {
            this.myRevisions.add((VcsFileRevision)new CurrentRevision(file, currentRevisionNumber));
        }
        Collections.sort(this.myRevisions, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision rev1, VcsFileRevision rev2) {
                return VcsHistoryUtil.compare(rev1, rev2);
            }
        });
        Collections.reverse(this.myRevisions);
        this.myContentFileType = file.getFileType();
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.mySplitter = new Splitter(true, this.getVcsConfiguration().FILE_HISTORY_DIALOG_SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel(components.getDetailsComponent()));
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    ((VcsHistoryDialog)VcsHistoryDialog.this).getVcsConfiguration().FILE_HISTORY_DIALOG_SPLITTER_PROPORTION = ((Float)evt.getNewValue()).floatValue();
                }
            }
        });
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsHistoryDialog.this.myList.getSelectedRowCount() == 1 && !VcsHistoryDialog.this.myList.isEmpty()) {
                    revision = (VcsFileRevision)VcsHistoryDialog.this.myList.getItems().get(VcsHistoryDialog.this.myList.getSelectedRow());
                    VcsHistoryDialog.this.myComments.setText(revision.getCommitMessage());
                    VcsHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsHistoryDialog.this.myComments.setText("");
                }
                if (components.getRevisionListener() != null) {
                    components.getRevisionListener().consume((Object)revision);
                }
                VcsHistoryDialog.this.updateDiff();
            }
        };
        this.myList.getSelectionModel().addListSelectionListener(selectionListener);
        this.myChangesOnlyCheckBox.setSelected(configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF);
        try {
            this.updateRevisionsList();
        }
        catch (VcsException e) {
            this.canNotLoadRevisionMessage(e);
        }
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = VcsHistoryDialog.this.myChangesOnlyCheckBox.isSelected();
                try {
                    VcsHistoryDialog.this.updateRevisionsList();
                }
                catch (VcsException e1) {
                    VcsHistoryDialog.this.canNotLoadRevisionMessage(e1);
                }
            }
        });
        this.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!VcsHistoryDialog.this.isShowing()) {
                    return;
                }
                VcsHistoryDialog.this.myList.getSelectionModel().addSelectionInterval(0, 0);
            }
        });
        this.setTitle(VcsBundle.message((String)"dialog.title.history.for.file", (Object[])new Object[]{file.getName()}));
    }

    private void canNotLoadRevisionMessage(final VcsException e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!VcsHistoryDialog.this.isShowing()) {
                    return;
                }
                PopupUtil.showBalloonForComponent((Component)VcsHistoryDialog.this.getRootPane(), (String)VcsHistoryDialog.this.canNoLoadMessage(e), (MessageType)MessageType.ERROR, (boolean)true, (Disposable)VcsHistoryDialog.this.myProject);
            }
        });
    }

    private String canNoLoadMessage(VcsException e) {
        return "Can not load revision contents: " + e.getMessage();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public void show() {
        this.myList.getSelectionModel().setSelectionInterval(0, 0);
        super.show();
    }

    private static ColumnInfo[] createColumns(ColumnInfo[] additionalColumns) {
        if (additionalColumns == null) {
            return COLUMNS;
        }
        ColumnInfo[] result2 = new ColumnInfo[additionalColumns.length + COLUMNS.length];
        System.arraycopy(COLUMNS, 0, result2, 0, COLUMNS.length);
        System.arraycopy(additionalColumns, 0, result2, COLUMNS.length, additionalColumns.length);
        return result2;
    }

    protected String getContentOf(VcsFileRevision revision) throws VcsException {
        return this.myCachedContents.getContentOf(revision);
    }

    private void loadContentsFor(VcsFileRevision[] revisions) throws VcsException {
        this.myCachedContents.loadContentsFor(revisions);
    }

    private void updateRevisionsList() throws VcsException {
        if (this.myIsInLoading) {
            return;
        }
        if (this.myChangesOnlyCheckBox.isSelected()) {
            this.loadContentsFor(this.myRevisions.toArray(new VcsFileRevision[this.myRevisions.size()]));
            try {
                ((ListTableModel)this.myList.getModel()).setItems(this.filteredRevisions());
            }
            catch (FilesTooBigForDiffException e) {
                this.myChangesOnlyCheckBox.setEnabled(false);
                this.myChangesOnlyCheckBox.setSelected(false);
                this.setErrorText(e.getMessage());
                ((ListTableModel)this.myList.getModel()).setItems(this.myRevisions);
            }
            ((ListTableModel)this.myList.getModel()).fireTableDataChanged();
            this.updateDiff(0, 0);
        } else {
            ((ListTableModel)this.myList.getModel()).setItems(this.myRevisions);
            ((ListTableModel)this.myList.getModel()).fireTableDataChanged();
        }
    }

    private List<VcsFileRevision> filteredRevisions() throws FilesTooBigForDiffException, VcsException {
        ArrayList<VcsFileRevision> result2 = new ArrayList<VcsFileRevision>();
        VcsFileRevision nextRevision = this.myRevisions.get(this.myRevisions.size() - 1);
        result2.add(nextRevision);
        for (int i = this.myRevisions.size() - 2; i >= 0; --i) {
            VcsFileRevision vcsFileRevision = this.myRevisions.get(i);
            if (this.getContentToShow(nextRevision).equals(this.getContentToShow(vcsFileRevision))) continue;
            result2.add(vcsFileRevision);
            nextRevision = vcsFileRevision;
        }
        Collections.reverse(result2);
        return result2;
    }

    private synchronized void updateDiff() {
        if (this.myList.isEmpty()) {
            return;
        }
        int[] selectedIndices = this.myList.getSelectedRows();
        if (selectedIndices.length == 0) {
            this.updateDiff(0, 0);
        } else if (selectedIndices.length == 1) {
            this.updateDiff(selectedIndices[0], 0);
        } else {
            this.updateDiff(selectedIndices[selectedIndices.length - 1], selectedIndices[0]);
        }
    }

    private synchronized void updateDiff(int first, int second) {
        VcsFileRevision secondRev;
        if (this.myIsDisposed || this.myIsInLoading) {
            return;
        }
        List items = ((ListTableModel)this.myList.getModel()).getItems();
        VcsFileRevision firstRev = (VcsFileRevision)items.get(first);
        if (VcsHistoryUtil.compare(firstRev, secondRev = (VcsFileRevision)items.get(second)) > 0) {
            VcsFileRevision tmp = firstRev;
            firstRev = secondRev;
            secondRev = tmp;
        }
        if (this.myIsDisposed) {
            return;
        }
        DiffRequest diffRequest = this.createDiffRequest(firstRev, secondRev);
        this.myDiffPanel.setRequest(diffRequest);
    }

    @NotNull
    private DiffRequest createDiffRequest(@NotNull VcsFileRevision firstRev, @NotNull VcsFileRevision secondRev) {
        SimpleDiffRequest simpleDiffRequest;
        block7: {
            if (firstRev == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstRev", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
            }
            if (secondRev == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondRev", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
            }
            try {
                DocumentContent content1 = DiffContentFactory.getInstance().create(this.getContentToShow(firstRev), this.myContentFileType);
                DocumentContent content2 = DiffContentFactory.getInstance().create(this.getContentToShow(secondRev), this.myContentFileType);
                String title1 = VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{firstRev.getRevisionNumber()});
                String title2 = VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{secondRev.getRevisionNumber()});
                simpleDiffRequest = new SimpleDiffRequest(null, (DiffContent)content1, (DiffContent)content2, title1, title2);
                if (simpleDiffRequest != null) break block7;
            }
            catch (VcsException e) {
                this.canNotLoadRevisionMessage(e);
                MessageDiffRequest messageDiffRequest = new MessageDiffRequest(this.canNoLoadMessage(e));
                if (messageDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
                }
                return messageDiffRequest;
            }
            catch (FilesTooBigForDiffException e) {
                MessageDiffRequest messageDiffRequest = new MessageDiffRequest("File is too big and there are too many changes.");
                if (messageDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
                }
                return messageDiffRequest;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createDiffRequest"));
        }
        return simpleDiffRequest;
    }

    public synchronized void dispose() {
        this.myIsDisposed = true;
        super.dispose();
    }

    private JComponent createBottomPanel(JComponent addComp) {
        Splitter splitter = new Splitter(true, this.getVcsConfiguration().FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION);
        splitter.setDividerWidth(4);
        splitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    ((VcsHistoryDialog)VcsHistoryDialog.this).getVcsConfiguration().FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION = ((Float)evt.getNewValue()).floatValue();
                }
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.createTablePanel(), "Center");
        tablePanel.add((Component)this.myChangesOnlyCheckBox, "North");
        splitter.setFirstComponent((JComponent)tablePanel);
        splitter.setSecondComponent(this.createComments(addComp));
        return splitter;
    }

    private VcsConfiguration getVcsConfiguration() {
        return this.myActiveVcs.getConfiguration();
    }

    private JComponent createComments(JComponent addComp) {
        Splitter splitter = new Splitter(false);
        JLabel label = new JLabel("Commit Message:"){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.getWidth(), 21);
            }
        };
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)label, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComments), "Center");
        this.myComments.setRows(5);
        this.myComments.setEditable(false);
        this.myComments.setLineWrap(true);
        splitter.setFirstComponent((JComponent)panel);
        splitter.setSecondComponent(addComp);
        return splitter;
    }

    private JComponent createTablePanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.myList);
    }

    protected JComponent createCenterPanel() {
        return this.mySplitter;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    @NotNull
    protected Action[] createActions() {
        Action okAction = this.getOKAction();
        okAction.putValue("Name", VcsBundle.message((String)"close.tab.action.name", (Object[])new Object[0]));
        if (this.myHelpId != null) {
            Action[] actionArray = new Action[]{okAction, this.getHelpAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{okAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/impl/VcsHistoryDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return "VCS.FileHistoryDialog";
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return this.myList.getSelectedObject();
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myActiveVcs.getKeyInstanceMethod();
        }
        return null;
    }

    protected String getContentToShow(VcsFileRevision revision) throws FilesTooBigForDiffException, VcsException {
        Block block = this.getBlock(revision);
        if (block == null) {
            return "";
        }
        return block.getBlockContent();
    }

    @Nullable
    private Block getBlock(VcsFileRevision revision) throws FilesTooBigForDiffException, VcsException {
        if (this.myRevisionToContentMap.containsKey(revision)) {
            return this.myRevisionToContentMap.get(revision);
        }
        String revisionContent = this.getContentOf(revision);
        if (revisionContent == null) {
            return null;
        }
        int index = this.myRevisions.indexOf(revision);
        Block blockByIndex = this.getBlock(index);
        if (blockByIndex == null) {
            return null;
        }
        this.myRevisionToContentMap.put(revision, new FindBlock(revisionContent, blockByIndex).getBlockInThePrevVersion());
        return this.myRevisionToContentMap.get(revision);
    }

    private Block getBlock(int index) throws FilesTooBigForDiffException, VcsException {
        return index > 0 ? this.getBlock(this.myRevisions.get(index - 1)) : new Block(this.myEditor.getDocument().getText(), this.mySelectionStart, this.mySelectionEnd);
    }
}

