/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java.wrap.impl;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChildWrapArranger {
    @Nullable
    public Wrap arrange(ASTNode child, ASTNode parent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, Wrap suggestedWrap, AbstractJavaBlock reservedWrapsProvider) {
        ASTNode directParent = child.getTreeParent();
        int role = ((CompositeElement)directParent).getChildRole(child);
        if (parent instanceof PsiPolyadicExpression) {
            boolean rOperand;
            if (role == 63 && !settings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return null;
            }
            boolean bl = rOperand = ArrayUtil.indexOf((Object[])((PsiPolyadicExpression)parent).getOperands(), (Object)child.getPsi()) > 0;
            if (settings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && rOperand) {
                return null;
            }
            return suggestedWrap;
        }
        IElementType nodeType = parent.getElementType();
        IElementType childType = child.getElementType();
        if (childType == JavaElementType.EXTENDS_LIST || childType == JavaElementType.IMPLEMENTS_LIST) {
            return Wrap.createWrap((int)settings.EXTENDS_KEYWORD_WRAP, (boolean)true);
        }
        if (childType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((int)settings.THROWS_KEYWORD_WRAP, (boolean)true);
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST) {
            if (role == 29) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            if (role == 29) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            if (role == 87 && !settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 114 && !settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 112 && settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 113 && settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            return suggestedWrap;
        }
        if (JavaFormatterUtil.isAssignment(parent) && role != 10) {
            if (role == 20) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? suggestedWrap : null;
            }
            if (role == 63) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? suggestedWrap : null;
            }
            if (role == 21) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? null : suggestedWrap;
            }
            if (role == 62) {
                return settings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? null : suggestedWrap;
            }
            if (role == 22) {
                return null;
            }
            return suggestedWrap;
        }
        if (nodeType == JavaElementType.REFERENCE_EXPRESSION) {
            if (role == 55) {
                return reservedWrapsProvider.getReservedWrap(JavaElementType.REFERENCE_EXPRESSION);
            }
            return suggestedWrap;
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            if (role == 39 || role == 32 || role == 40) {
                return suggestedWrap;
            }
            if (role == 38) {
                boolean dontWrap = (childType == JavaElementType.CODE_BLOCK || childType == JavaElementType.BLOCK_STATEMENT) && settings.BRACE_STYLE == 1;
                return Wrap.createWrap((WrapType)(dontWrap ? WrapType.NONE : WrapType.NORMAL), (boolean)true);
            }
            return null;
        }
        if (parent.getPsi() instanceof PsiModifierListOwner) {
            ASTNode last;
            ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling(child);
            if (prev != null && prev.getElementType() == JavaElementType.MODIFIER_LIST && (last = prev.getLastChildNode()) != null && last.getElementType() == JavaElementType.ANNOTATION) {
                if (JavaChildWrapArranger.isTypeAnnotationOrFalseIfDumb(last) || javaSettings.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION && JavaChildWrapArranger.isFieldModifierListWithSingleAnnotation(prev)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaChildWrapArranger.getAnnotationWrapType(parent, child, settings)), (boolean)true);
            }
            return null;
        }
        if (nodeType == JavaElementType.MODIFIER_LIST) {
            if (childType == JavaElementType.ANNOTATION) {
                ASTNode prev;
                if (JavaChildWrapArranger.isTypeAnnotationOrFalseIfDumb(child) && ((prev = FormatterUtil.getPreviousNonWhitespaceSibling(child)) == null || prev.getElementType() != JavaElementType.ANNOTATION || JavaChildWrapArranger.isTypeAnnotationOrFalseIfDumb(prev))) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaChildWrapArranger.getAnnotationWrapType(parent.getTreeParent(), child, settings)), (boolean)true);
            }
            if (childType == JavaTokenType.END_OF_LINE_COMMENT) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
            ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling(child);
            if (prev != null && prev.getElementType() == JavaElementType.ANNOTATION) {
                if (javaSettings.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION && JavaChildWrapArranger.isFieldModifierListWithSingleAnnotation(parent)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                }
                Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(JavaChildWrapArranger.getAnnotationWrapType(parent.getTreeParent(), child, settings)), (boolean)true);
                JavaChildWrapArranger.putPreferredWrapInParentBlock(reservedWrapsProvider, wrap);
                return wrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            if (role == 32) {
                return suggestedWrap;
            }
            if (role == 117 && !settings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return suggestedWrap;
            }
            if (role == 87 && settings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            if (child.getPsi() instanceof PsiStatement) {
                return suggestedWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.IF_STATEMENT) {
            if (childType == JavaElementType.IF_STATEMENT && role == 34 && settings.SPECIAL_ELSE_IF_TREATMENT) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            if (role == 33 || role == 34) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.FOREACH_STATEMENT || nodeType == JavaElementType.WHILE_STATEMENT) {
            if (role == 38) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.DO_WHILE_STATEMENT) {
            if (role == 38) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
            if (role == 35) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
            if (suggestedWrap != null) {
                return suggestedWrap;
            }
            if (role == 249) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        return suggestedWrap;
    }

    private static boolean isTypeAnnotationOrFalseIfDumb(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/wrap/impl/JavaChildWrapArranger", "isTypeAnnotationOrFalseIfDumb"));
        }
        PsiElement node = child.getPsi();
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)node, (Class[])new Class[]{PsiWhiteSpace.class, PsiAnnotation.class});
        if (next instanceof PsiKeyword) {
            return false;
        }
        return !DumbService.isDumb((Project)node.getProject()) && PsiImplUtil.isTypeAnnotation(node);
    }

    private static void putPreferredWrapInParentBlock(@NotNull AbstractJavaBlock block, @NotNull Wrap preferredWrap) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/psi/formatter/java/wrap/impl/JavaChildWrapArranger", "putPreferredWrapInParentBlock"));
        }
        if (preferredWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredWrap", "com/intellij/psi/formatter/java/wrap/impl/JavaChildWrapArranger", "putPreferredWrapInParentBlock"));
        }
        AbstractJavaBlock parentBlock = block.getParentBlock();
        if (parentBlock != null) {
            parentBlock.setReservedWrap(preferredWrap, JavaElementType.MODIFIER_LIST);
        }
    }

    private static boolean isFieldModifierListWithSingleAnnotation(@NotNull ASTNode elem) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/psi/formatter/java/wrap/impl/JavaChildWrapArranger", "isFieldModifierListWithSingleAnnotation"));
        }
        ASTNode parent = elem.getTreeParent();
        if (parent != null && parent.getElementType() == JavaElementType.FIELD) {
            return JavaChildWrapArranger.isModifierListWithSingleAnnotation(elem);
        }
        return false;
    }

    private static boolean isModifierListWithSingleAnnotation(@NotNull ASTNode elem) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/psi/formatter/java/wrap/impl/JavaChildWrapArranger", "isModifierListWithSingleAnnotation"));
        }
        return elem.getPsi() instanceof PsiModifierList && ((PsiModifierList)elem.getPsi()).getAnnotations().length == 1;
    }

    private static int getAnnotationWrapType(ASTNode parent, ASTNode child, CommonCodeStyleSettings settings) {
        IElementType nodeType = parent.getElementType();
        if (nodeType == JavaElementType.METHOD) {
            return settings.METHOD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.CLASS) {
            for (ASTNode node = child.getTreeNext(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() == TokenType.WHITE_SPACE || node instanceof PsiTypeElement || !(node instanceof PsiErrorElement)) continue;
                return settings.FIELD_ANNOTATION_WRAP;
            }
            return settings.CLASS_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.FIELD) {
            return settings.FIELD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.PARAMETER || nodeType == JavaElementType.RECEIVER_PARAMETER || nodeType == JavaElementType.RESOURCE_VARIABLE) {
            return settings.PARAMETER_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.LOCAL_VARIABLE) {
            return settings.VARIABLE_ANNOTATION_WRAP;
        }
        return 0;
    }
}

