/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiElementBase");

    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[children.length - 1];
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/PsiElementBase", "acceptChildren"));
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "getReferences"));
        }
        return psiReferenceArray;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this, offset);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/PsiElementBase", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/PsiElementBase", "addRangeBefore"));
        }
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + ((Object)((Object)this)).getClass());
    }

    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiElementBase", "add"));
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiElementBase", "addBefore"));
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiElementBase", "addAfter"));
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiElementBase", "checkAdd"));
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/PsiElementBase", "replace"));
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName());
    }

    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElementBase psiElementBase = this;
        if (psiElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "getNavigationElement"));
        }
        return psiElementBase;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "getUseScope"));
        }
        return globalSearchScope;
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "getProject"));
        }
        return project;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return parent.getContainingFile();
    }

    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    public boolean isValid() {
        PsiElement parent;
        for (parent = this.getParent(); parent != null && parent.getClass() == ((Object)((Object)this)).getClass(); parent = parent.getParent()) {
        }
        return parent != null && parent.isValid();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiElementBase", "textMatches"));
        }
        return Comparing.equal((CharSequence)this.getText(), (CharSequence)text, (boolean)true);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/PsiElementBase", "textMatches"));
        }
        return this.getText().equals(element.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/PsiElementBase", "accept"));
        }
        visitor.visitElement((PsiElement)this);
    }

    public String getName() {
        return null;
    }

    @NotNull
    protected <T> T notNullChild(T child) {
        if (child == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "notNullChild"));
        }
        return t;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            result2.add(cur);
        }
        Object[] objectArray = result2.toArray((Object[])Array.newInstance(aClass, result2.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        T t = this.notNullChild(this.findChildByClass(aClass));
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiElementBase", "findNotNullChildByClass"));
        }
        return t;
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }
}

