/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.ui.RefactoringDialog;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public abstract class MoveDialogBase
extends RefactoringDialog {
    private JCheckBox myOpenEditorCb;

    protected abstract String getMovePropertySuffix();

    protected abstract String getCbTitle();

    protected JCheckBox initOpenInEditorCb() {
        this.myOpenEditorCb = new JCheckBox(this.getCbTitle(), PropertiesComponent.getInstance().getBoolean("Move" + this.getMovePropertySuffix() + ".OpenInEditor", this.isEnabledByDefault()));
        return this.myOpenEditorCb;
    }

    protected boolean isEnabledByDefault() {
        return true;
    }

    protected void saveOpenInEditorOption() {
        if (this.myOpenEditorCb != null) {
            PropertiesComponent.getInstance().setValue("Move" + this.getMovePropertySuffix() + ".OpenInEditor", this.myOpenEditorCb.isSelected(), this.isEnabledByDefault());
        }
    }

    protected boolean isOpenInEditor() {
        return this.myOpenEditorCb != null && this.myOpenEditorCb.isSelected();
    }

    protected MoveDialogBase(@NotNull Project project, boolean canBeParent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/move/MoveDialogBase", "<init>"));
        }
        super(project, canBeParent);
    }
}

