/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteParameterCallHierarchyUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

abstract class SafeDeleteJavaCallerChooser
extends JavaCallerChooser {
    private final PsiMethod myMethod;
    private final Project myProject;
    private final ArrayList<UsageInfo> myResult;

    public SafeDeleteJavaCallerChooser(PsiMethod method, Project project, ArrayList<UsageInfo> result2) {
        super(method, project, "Select Methods To Propagate Parameter Deletion", null, (Consumer<Set<PsiMethod>>)Consumer.EMPTY_CONSUMER);
        this.myMethod = method;
        this.myProject = project;
        this.myResult = result2;
    }

    protected abstract ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> getTopLevelItems();

    protected abstract int getParameterIdx();

    @Override
    protected JavaMethodNode createTreeNode(PsiMethod nodeMethod, HashSet<PsiMethod> called, Runnable cancelCallback) {
        SafeDeleteJavaMethodNode node = new SafeDeleteJavaMethodNode(nodeMethod, (java.util.HashSet<PsiMethod>)called, cancelCallback, this.getParameterIdx(), nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMethod)this.getTopMethod()).equals(nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    @Override
    protected void doOKAction() {
        final ArrayList foreignMethodUsages = new ArrayList();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Set nodes = SafeDeleteJavaCallerChooser.this.getSelectedNodes();
                for (MethodNodeBase node : nodes) {
                    SafeDeleteJavaMethodNode methodNode = (SafeDeleteJavaMethodNode)node;
                    final PsiMethod nodeMethod = (PsiMethod)methodNode.getMethod();
                    if (nodeMethod.equals(SafeDeleteJavaCallerChooser.this.myMethod)) continue;
                    final PsiParameter parameter = nodeMethod.getParameterList().getParameters()[methodNode.myParameterIdx];
                    foreignMethodUsages.add(new SafeDeleteParameterCallHierarchyUsageInfo(nodeMethod, parameter, nodeMethod));
                    ReferencesSearch.search((PsiElement)nodeMethod).forEach((Processor)new Processor<PsiReference>(){

                        public boolean process(PsiReference reference) {
                            PsiElement element = reference.getElement();
                            if (element != null) {
                                ((JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage())).createUsageInfoForParameter(reference, foreignMethodUsages, parameter, nodeMethod);
                            }
                            return true;
                        }
                    });
                }
            }
        };
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(runnable);
            }
        }, "Search for Caller Method Usages...", true, this.myProject)) {
            this.myResult.addAll(foreignMethodUsages);
        }
        super.doOKAction();
    }

    static PsiParameter isTheOnlyOneParameterUsage(PsiElement call, final int parameterIndex, final PsiMethod nodeMethod) {
        PsiExpression expression;
        PsiExpression[] expressions;
        PsiExpressionList argumentList;
        if (call instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)call).getArgumentList()) != null && (expressions = argumentList.getExpressions()).length > parameterIndex && (expression = PsiUtil.deparenthesizeExpression((PsiExpression)expressions[parameterIndex])) != null) {
            PsiElement scope;
            final java.util.HashSet paramRefs = new java.util.HashSet();
            expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiParameter) {
                        paramRefs.add((PsiParameter)resolve);
                    }
                }
            });
            PsiParameter parameter = (PsiParameter)ContainerUtil.getFirstItem(paramRefs);
            if (parameter != null && !parameter.isVarArgs() && (scope = parameter.getDeclarationScope()) instanceof PsiMethod && ((PsiMethod)scope).findDeepestSuperMethods().length == 0) {
                final int scopeParamIdx = ((PsiMethod)scope).getParameterList().getParameterIndex(parameter);
                final Ref ref = new Ref((Object)false);
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(scope)).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        PsiElement element = reference.getElement();
                        if (element instanceof PsiReferenceExpression) {
                            PsiCallExpression parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
                            while (parent != null) {
                                PsiMethod resolved = parent.resolveMethod();
                                if (scope.equals(resolved)) {
                                    return !this.usedInQualifier(element, parent, scopeParamIdx);
                                }
                                if (nodeMethod.equals(resolved)) {
                                    if (this.usedInQualifier(element, parent, parameterIndex)) {
                                        return false;
                                    }
                                    ref.set((Object)true);
                                    return true;
                                }
                                parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCallExpression.class, (boolean)true);
                            }
                            return false;
                        }
                        return true;
                    }

                    private boolean usedInQualifier(PsiElement element, PsiCallExpression parent, int parameterIndex2) {
                        PsiReferenceExpression qualifier = null;
                        if (parent instanceof PsiMethodCallExpression) {
                            qualifier = ((PsiMethodCallExpression)parent).getMethodExpression();
                        } else if (parent instanceof PsiNewExpression) {
                            qualifier = ((PsiNewExpression)parent).getQualifier();
                        }
                        if (PsiTreeUtil.isAncestor((PsiElement)qualifier, (PsiElement)element, (boolean)true)) {
                            return true;
                        }
                        PsiExpressionList list = parent.getArgumentList();
                        return list != null && !PsiTreeUtil.isAncestor((PsiElement)list.getExpressions()[parameterIndex2], (PsiElement)element, (boolean)false);
                    }
                }) && ((Boolean)ref.get()).booleanValue()) {
                    return parameter;
                }
            }
        }
        return null;
    }

    private class SafeDeleteJavaMethodNode
    extends JavaMethodNode {
        private final int myParameterIdx;

        public SafeDeleteJavaMethodNode(PsiMethod currentMethod, java.util.HashSet<PsiMethod> called, Runnable cancelCallback, int idx, Project project) {
            super(currentMethod, (Set<PsiMethod>)called, project, cancelCallback);
            this.myParameterIdx = idx;
        }

        @Override
        protected MethodNodeBase<PsiMethod> createNode(PsiMethod caller, java.util.HashSet<PsiMethod> called) {
            return new SafeDeleteJavaMethodNode(caller, called, this.myCancelCallback, this.getParameterIndex(caller), this.myProject);
        }

        @Override
        protected List<PsiMethod> computeCallers() {
            if (((PsiMethod)SafeDeleteJavaCallerChooser.this.getTopMethod()).equals(this.getMethod())) {
                ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> items = SafeDeleteJavaCallerChooser.this.getTopLevelItems();
                return ContainerUtil.map(items, (Function)new Function<SafeDeleteParameterCallHierarchyUsageInfo, PsiMethod>(){

                    public PsiMethod fun(SafeDeleteParameterCallHierarchyUsageInfo info) {
                        return info.getCallerMethod();
                    }
                });
            }
            List<PsiMethod> methods = super.computeCallers();
            methods.remove(SafeDeleteJavaCallerChooser.this.getTopMethod());
            return methods;
        }

        @Override
        protected Condition<PsiMethod> getFilter() {
            return new Condition<PsiMethod>(){

                public boolean value(PsiMethod method) {
                    return !((PsiMethod)SafeDeleteJavaMethodNode.this.myMethod).equals(method) && SafeDeleteJavaMethodNode.this.getParameter(method) != null;
                }
            };
        }

        private PsiParameter getParameter(PsiMethod caller) {
            if (caller.findDeepestSuperMethods().length > 0) {
                return null;
            }
            final Ref ref = new Ref();
            ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)new LocalSearchScope((PsiElement)caller)).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement elementParent;
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiReferenceExpression && (elementParent = element.getParent()) instanceof PsiCallExpression) {
                        ref.set((Object)SafeDeleteJavaCallerChooser.isTheOnlyOneParameterUsage(elementParent, SafeDeleteJavaMethodNode.this.myParameterIdx, (PsiMethod)SafeDeleteJavaMethodNode.this.myMethod));
                        return false;
                    }
                    return true;
                }
            });
            return (PsiParameter)ref.get();
        }

        private int getParameterIndex(PsiMethod caller) {
            PsiParameter parameter = this.getParameter(caller);
            return parameter != null ? caller.getParameterList().getParameterIndex(parameter) : -1;
        }
    }
}

