/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomImplUtil");

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement element, String msg) {
        if (element instanceof DomFileElementImpl) {
            String s = ((DomFileElementImpl)element).checkValidity();
            if (s != null) {
                throw new AssertionError((Object)s);
            }
            return;
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
        assert (handler2 != null);
        try {
            handler2.assertValid();
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)(msg + ((Throwable)((Object)e)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod method) {
        if (!DomImplUtil.isGetter(method)) {
            return false;
        }
        if (DomImplUtil.hasTagValueAnnotation(method)) {
            return true;
        }
        if ("getValue".equals(method.getName())) {
            if (method.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (method.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (method.getAnnotation(Convert.class) != null || method.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)method.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)method.getReturnType());
        }
        return false;
    }

    private static boolean hasTagValueAnnotation(JavaMethod method) {
        return method.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method) {
        boolean isIs;
        String name = method.getName();
        boolean isGet = name.startsWith("get");
        boolean bl = isIs = !isGet && name.startsWith("is");
        if (!isGet && !isIs) {
            return false;
        }
        if (method.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type returnType = method.getGenericReturnType();
        if (isGet) {
            return returnType != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)returnType);
    }

    public static boolean isTagValueSetter(JavaMethod method) {
        boolean setter = method.getName().startsWith("set") && method.getGenericParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        return setter && (DomImplUtil.hasTagValueAnnotation(method) || "setValue".equals(method.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        NameStrategyForAttributes annotation;
        Class aClass = null;
        if (isAttribute && (annotation = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass == null && (annotation = (NameStrategy)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass != null) {
            if (HyphenNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)aClass)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)aClass.newInstance();
            }
            catch (InstantiationException e) {
                LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(final @NotNull XmlTag tag, final EvaluatedXmlName name, final XmlFile file) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/util/xml/impl/DomImplUtil", "findSubTags"));
        }
        if (!tag.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] tags = tag.getSubTags();
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, (Condition)new Condition<XmlTag>(){

            public boolean value(XmlTag childTag) {
                try {
                    return DomImplUtil.isNameSuitable(name, childTag.getLocalName(), childTag.getName(), childTag.getNamespace(), file);
                }
                catch (PsiInvalidElementAccessException e) {
                    if (!childTag.isValid()) {
                        LOG.error("tag.getSubTags() returned invalid, tag=" + tag + ", " + "containing file: " + tag.getContainingFile() + "subTag.parent=" + childTag.getNode().getTreeParent());
                        return false;
                    }
                    throw e;
                }
            }
        });
    }

    public static List<XmlTag> findSubTags(XmlTag[] tags, final EvaluatedXmlName name, final XmlFile file) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, (Condition)new Condition<XmlTag>(){

            public boolean value(XmlTag childTag) {
                return DomImplUtil.isNameSuitable(name, childTag, file);
            }
        });
    }

    public static boolean isNameSuitable(XmlName name, XmlTag tag, @NotNull DomInvocationHandler handler2, XmlFile file) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/xml/impl/DomImplUtil", "isNameSuitable"));
        }
        return DomImplUtil.isNameSuitable(handler2.createEvaluatedXmlName(name), tag, file);
    }

    private static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, XmlTag tag, XmlFile file) {
        return DomImplUtil.isNameSuitable(evaluatedXmlName, tag.getLocalName(), tag.getName(), tag.getNamespace(), file);
    }

    public static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, String localName, String qName, String namespace, XmlFile file) {
        String localName1 = evaluatedXmlName.getXmlName().getLocalName();
        return (localName1.equals(localName) || localName1.equals(qName)) && evaluatedXmlName.isNamespaceAllowed(namespace, file, !localName1.equals(qName));
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, Type type, @Nullable JavaMethod javaMethod) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/xml/impl/DomImplUtil", "createXmlName"));
        }
        Class<?> aClass = DomImplUtil.getErasure(type);
        if (aClass == null) {
            return null;
        }
        String key = DomImplUtil.getNamespaceKey(aClass);
        if (key == null && javaMethod != null) {
            for (Method method : javaMethod.getHierarchy()) {
                String key1 = DomImplUtil.getNamespaceKey(method.getDeclaringClass());
                if (key1 == null) continue;
                return new XmlName(name, key1);
            }
        }
        return new XmlName(name, key);
    }

    @Nullable
    private static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.getErasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    private static String getNamespaceKey(@NotNull Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xml/impl/DomImplUtil", "getNamespaceKey"));
        }
        Namespace namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(type, Namespace.class);
        return namespace != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, JavaMethod method) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/xml/impl/DomImplUtil", "createXmlName"));
        }
        return DomImplUtil.createXmlName(name, method.getGenericReturnType(), method);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler handler2, XmlTag[] subTags, XmlFile file) {
        if (subTags.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx info = handler2.getGenericInfo();
        THashSet usedNames = new THashSet();
        List collectionChildrenDescriptions = info.getCollectionChildrenDescriptions();
        int size = collectionChildrenDescriptions.size();
        for (int i = 0; i < size; ++i) {
            DomCollectionChildDescription description = (DomCollectionChildDescription)collectionChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        List fixedChildrenDescriptions = info.getFixedChildrenDescriptions();
        int size2 = fixedChildrenDescriptions.size();
        for (int i = 0; i < size2; ++i) {
            DomFixedChildDescription description = (DomFixedChildDescription)fixedChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, (Condition)new Condition<XmlTag>((Set)usedNames, handler2, file){
            final /* synthetic */ Set val$usedNames;
            final /* synthetic */ DomInvocationHandler val$handler;
            final /* synthetic */ XmlFile val$file;
            {
                this.val$usedNames = set;
                this.val$handler = domInvocationHandler;
                this.val$file = xmlFile;
            }

            public boolean value(XmlTag tag) {
                if (StringUtil.isEmpty((String)tag.getName())) {
                    return false;
                }
                for (XmlName name : this.val$usedNames) {
                    if (!DomImplUtil.isNameSuitable(name, tag, this.val$handler, this.val$file)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    static XmlFile getFile(DomElement domElement) {
        DomInvocationHandler handler2;
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        assert (handler2 != null) : domElement;
        for (handler2 = DomManagerImpl.getDomInvocationHandler(domElement); handler2 != null && !(handler2 instanceof DomRootInvocationHandler) && handler2.getXmlTag() == null; handler2 = handler2.getParentHandler()) {
        }
        if (handler2 instanceof DomRootInvocationHandler) {
            return ((DomRootInvocationHandler)handler2).getParent().getFile();
        }
        assert (handler2 != null);
        XmlTag tag = handler2.getXmlTag();
        PsiElement parentTag;
        while ((parentTag = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag)) instanceof XmlTag) {
            tag = (XmlTag)parentTag;
        }
        return (XmlFile)tag.getContainingFile();
    }
}

