/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Function;
import com.intellij.vcs.log.ui.actions.TextFieldWithProgress;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupWithProgress {
    private static final Logger LOG = Logger.getInstance(FindPopupWithProgress.class);
    @NotNull
    private final TextFieldWithProgress myTextField;
    @NotNull
    private final Function<String, Future> myFunction;
    @NotNull
    private final JBPopup myPopup;
    @Nullable
    private Future myFuture;

    public FindPopupWithProgress(@NotNull Project project, @NotNull Collection<String> variants, @NotNull Function<String, Future> function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/FindPopupWithProgress", "<init>"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/vcs/log/ui/actions/FindPopupWithProgress", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/vcs/log/ui/actions/FindPopupWithProgress", "<init>"));
        }
        this.myFunction = function;
        this.myTextField = new TextFieldWithProgress(project, variants){

            @Override
            public void onOk() {
                if (FindPopupWithProgress.this.myFuture == null) {
                    final Future future2 = (Future)FindPopupWithProgress.this.myFunction.fun((Object)this.getText().trim());
                    FindPopupWithProgress.this.myFuture = future2;
                    this.showProgress();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                future2.get();
                                FindPopupWithProgress.this.okPopup();
                            }
                            catch (CancellationException ex) {
                                FindPopupWithProgress.this.cancelPopup();
                            }
                            catch (InterruptedException ex) {
                                FindPopupWithProgress.this.cancelPopup();
                            }
                            catch (ExecutionException ex) {
                                LOG.error((Throwable)ex);
                                FindPopupWithProgress.this.cancelPopup();
                            }
                        }
                    });
                }
            }
        };
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myTextField, this.myTextField.getPreferableFocusComponent()).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(true).setRequestFocus(true).createPopup();
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                if (!event.isOk() && FindPopupWithProgress.this.myFuture != null) {
                    FindPopupWithProgress.this.myFuture.cancel(true);
                }
                FindPopupWithProgress.this.myFuture = null;
                FindPopupWithProgress.this.myTextField.hideProgress();
            }
        });
        JBTextField field = new JBTextField(20);
        Dimension size = field.getPreferredSize();
        Insets insets = this.myTextField.getBorder().getBorderInsets(this.myTextField);
        size.height += 6 + insets.top + insets.bottom;
        size.width += 4 + insets.left + insets.right;
        this.myPopup.setSize(size);
    }

    private void cancelPopup() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FindPopupWithProgress.this.myPopup.cancel();
            }
        });
    }

    private void okPopup() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FindPopupWithProgress.this.myPopup.closeOk(null);
            }
        });
    }

    public void showUnderneathOf(@NotNull Component anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/vcs/log/ui/actions/FindPopupWithProgress", "showUnderneathOf"));
        }
        this.myPopup.showUnderneathOf(anchor);
    }
}

