/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.Component;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogQuickSettingsActions
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/VcsLogQuickSettingsActions", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogSettings settings = (VcsLogSettings)ServiceManager.getService((Project)project, VcsLogSettings.class);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new MySettingsActionGroup(settings, logUi), e.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "ToolwindowPopup");
        Component component = e.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            popup.showUnderneathOf(component);
        } else {
            popup.showInCenterOf(component);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/VcsLogQuickSettingsActions", "update"));
        }
        Project project = e.getProject();
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && logUi != null);
    }

    private static class MySettingsActionGroup
    extends ActionGroup {
        private final VcsLogSettings mySettings;
        private final VcsLogUi myUi;

        public MySettingsActionGroup(VcsLogSettings settings, VcsLogUi ui) {
            this.mySettings = settings;
            this.myUi = ui;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{new ShowBranchesPanelAction(), new ShowRootsColumnAction()});
            actions.add(new Separator("Highlight"));
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions(VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)e.getProject())) {
                actions.add(new EnableHighlighterAction(factory));
            }
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/VcsLogQuickSettingsActions$MySettingsActionGroup", "getChildren"));
            }
            return anActionArray;
        }

        private class EnableHighlighterAction
        extends ToggleAction
        implements DumbAware {
            private final VcsLogHighlighterFactory myFactory;

            private EnableHighlighterAction(VcsLogHighlighterFactory factory) {
                super(factory.getTitle());
                this.myFactory = factory;
            }

            public boolean isSelected(AnActionEvent e) {
                return MySettingsActionGroup.this.myUi.isHighlighterEnabled(this.myFactory.getId());
            }

            public void setSelected(AnActionEvent e, boolean state) {
                MySettingsActionGroup.this.myUi.setHighlighterEnabled(this.myFactory.getId(), state);
            }
        }

        private class ShowRootsColumnAction
        extends ToggleAction
        implements DumbAware {
            public ShowRootsColumnAction() {
                super("Show Root Names");
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabledAndVisible(MySettingsActionGroup.this.myUi.isMultipleRoots());
            }

            public boolean isSelected(AnActionEvent e) {
                return MySettingsActionGroup.this.myUi.isShowRootNames();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                MySettingsActionGroup.this.myUi.setShowRootNames(state);
            }
        }

        private class ShowBranchesPanelAction
        extends ToggleAction
        implements DumbAware {
            public ShowBranchesPanelAction() {
                super("Show Branches Panel");
            }

            public boolean isSelected(AnActionEvent e) {
                return MySettingsActionGroup.this.mySettings.isShowBranchesPanel();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                MySettingsActionGroup.this.mySettings.setShowBranchesPanel(state);
                MySettingsActionGroup.this.myUi.setBranchesPanelVisible(state);
            }
        }
    }
}

