/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsSimpleTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsFavoriteListProvider
extends AbstractFavoritesListProvider<Object>
implements BreakpointPanelProvider.BreakpointsListener {
    private final List<BreakpointPanelProvider> myBreakpointPanelProviders;
    private final BreakpointItemsTreeController myTreeController;
    private final List<XBreakpointGroupingRule> myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
    private final Set<XBreakpointGroupingRule> myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
    private final SingleAlarm myRebuildAlarm = new SingleAlarm(new Runnable(){

        @Override
        public void run() {
            BreakpointsFavoriteListProvider.this.updateChildren();
        }
    }, 100);
    private final FavoritesManager myFavoritesManager;

    public BreakpointsFavoriteListProvider(Project project, FavoritesManager favoritesManager) {
        super(project, "Breakpoints");
        this.myBreakpointPanelProviders = XBreakpointUtil.collectPanelProviders();
        this.myFavoritesManager = favoritesManager;
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesAvailable);
        this.myTreeController.setTreeView((JTree)((Object)new BreakpointsSimpleTree(this.myProject, this.myTreeController)));
        for (BreakpointPanelProvider provider : this.myBreakpointPanelProviders) {
            provider.addListener(this, this.myProject, (Disposable)this.myProject);
            provider.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.updateChildren();
    }

    @Override
    public void breakpointsChanged() {
        this.myRebuildAlarm.cancelAndRequest();
    }

    private void getEnabledGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        rules.clear();
        XBreakpointsDialogState settings = ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager()).getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains(rule.getId()))) continue;
            rules.add(rule);
        }
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (BreakpointPanelProvider provider : this.myBreakpointPanelProviders) {
            provider.provideBreakpointItems(this.myProject, items);
        }
        this.getEnabledGroupingRules(this.myRulesEnabled);
        this.myTreeController.setGroupingRules(this.myRulesEnabled);
        this.myTreeController.rebuildTree(items);
        CheckedTreeNode root = this.myTreeController.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode child = root.getChildAt(i);
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            this.replicate((DefaultMutableTreeNode)child, this.myNode, this.myChildren);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    private void replicate(DefaultMutableTreeNode source, AbstractTreeNode destination, List<AbstractTreeNode<Object>> destinationChildren) {
        final ArrayList<AbstractTreeNode<Object>> copyChildren = new ArrayList<AbstractTreeNode<Object>>();
        AbstractTreeNode<Object> copy = new AbstractTreeNode<Object>(this.myProject, source.getUserObject()){

            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                ArrayList arrayList = copyChildren;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider$2", "getChildren"));
                }
                return arrayList;
            }

            protected void update(PresentationData presentation) {
            }
        };
        for (int i = 0; i < source.getChildCount(); ++i) {
            TreeNode treeNode = source.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)treeNode;
            this.replicate(sourceChild, (AbstractTreeNode)copy, copyChildren);
        }
        if (BreakpointsFavoriteListProvider.checkNavigatable(copy)) {
            destinationChildren.add(copy);
            copy.setParent(destination);
        }
    }

    private static boolean checkNavigatable(AbstractTreeNode<?> node) {
        if (node.getValue() instanceof Navigatable && ((Navigatable)node.getValue()).canNavigate()) {
            return true;
        }
        Collection children = node.getChildren();
        for (AbstractTreeNode child : children) {
            if (!BreakpointsFavoriteListProvider.checkNavigatable(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "getCustomName"));
        }
        switch (type) {
            case EDIT: {
                return "Edit breakpoint";
            }
            case REMOVE: {
                return "Remove breakpoint";
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "willHandle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedObjects", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "willHandle"));
        }
        return selectedObjects.size() == 1 && (type == CommonActionsPanel.Buttons.EDIT || type == CommonActionsPanel.Buttons.REMOVE) && ((AbstractTreeNode)selectedObjects.iterator().next()).getValue() instanceof BreakpointItem;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "handle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedObjects", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "handle"));
        }
        Rectangle bounds = component.getBounds();
        if (component instanceof JTree) {
            JTree tree = (JTree)component;
            bounds = tree.getRowBounds(tree.getLeadSelectionRow());
            bounds.y += bounds.height / 2;
            bounds = tree.getVisibleRect().intersection(bounds);
        }
        Point whereToShow = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        BreakpointItem breakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObjects.iterator().next()).getValue();
        switch (type) {
            case EDIT: {
                DebuggerSupport debuggerSupport = XBreakpointUtil.getDebuggerSupport(this.myProject, breakpointItem);
                if (debuggerSupport == null) {
                    return;
                }
                debuggerSupport.getEditBreakpointAction().editBreakpoint(this.myProject, component, whereToShow, breakpointItem);
                break;
            }
            case REMOVE: {
                breakpointItem.removed(this.myProject);
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 200;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider", "customizeRenderer"));
        }
        renderer.clear();
        renderer.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        if (value instanceof BreakpointItem) {
            BreakpointItem breakpointItem = (BreakpointItem)value;
            breakpointItem.setupGenericRenderer((SimpleColoredComponent)renderer, true);
        } else if (value instanceof XBreakpointGroup) {
            renderer.append(((XBreakpointGroup)value).getName());
            renderer.setIcon(((XBreakpointGroup)value).getIcon(expanded));
        } else if (value instanceof XBreakpointGroupingRule) {
            renderer.append(((XBreakpointGroupingRule)value).getPresentableName());
        } else {
            renderer.append(String.valueOf(value));
        }
    }
}

