/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.rpc.CommandProcessorKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"3\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0007\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005i\u0019\u0003B\u0001\t\u00075\t\u0001tA\r\u0004\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u000eQ\u001b\u0019!$\u0005\t\u000f5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005U\u0007\u0007\tJ\u0002B!\t\u0011\u0001iQ\u0001E\u0001\u0016\u00051\u0005\u0001\u0014\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0004EIA!\u0011%\u0002\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001\u0001VB\u0002"}, strings={"OPERATOR_TRIMMER", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "NameMapperKt", "S1", "", "getGeneratedName", "", "document", "Lcom/intellij/openapi/editor/Document;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceEntry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "warnSeveralMapping", "", "element", "Lcom/intellij/psi/PsiElement;"}, moduleName="script-debugger-ui")
public final class NameMapperKt {
    private static final String S1 = ",()[]{}=";
    private static final CharMatcher OPERATOR_TRIMMER;

    public static final void warnSeveralMapping(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        CommandProcessorKt.getLOG().warn("incorrect sourcemap, several mappings for named element " + element.getText());
    }

    private static final CharSequence getGeneratedName(Document document, SourceMap sourceMap, MappingEntry sourceEntry) {
        int lineStartOffset = document.getLineStartOffset(sourceEntry.getGeneratedLine());
        MappingEntry nextGeneratedMapping = sourceMap.getMappings().getNextOnTheSameLine(sourceEntry);
        int endOffset = nextGeneratedMapping == null ? document.getLineEndOffset(sourceEntry.getGeneratedLine()) : lineStartOffset + nextGeneratedMapping.getGeneratedColumn();
        return document.getImmutableCharSequence().subSequence(lineStartOffset + sourceEntry.getGeneratedColumn(), endOffset);
    }

    static {
        S1 = S1;
        OPERATOR_TRIMMER = CharMatcher.INVISIBLE.or(CharMatcher.anyOf((CharSequence)S1));
    }

    public static final /* synthetic */ CharMatcher access$getOPERATOR_TRIMMER$p() {
        return OPERATOR_TRIMMER;
    }

    @NotNull
    public static final /* synthetic */ String access$getS1$p() {
        return S1;
    }

    @NotNull
    public static final /* synthetic */ CharSequence access$getGeneratedName(@NotNull Document document, @NotNull SourceMap sourceMap, @NotNull MappingEntry sourceEntry) {
        return NameMapperKt.getGeneratedName(document, sourceMap, sourceEntry);
    }
}

