/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiSelectionSearcher {
    private PsiSelectionSearcher() {
    }

    @NotNull
    public static <T extends PsiElement> List<T> searchElementsInSelection(Editor editor, Project project, Class<T> filter, boolean searchChildrenOfFound) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/psiutils/PsiSelectionSearcher", "searchElementsInSelection"));
            }
            return list;
        }
        UnfairTextRange selection = new UnfairTextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null || file instanceof PsiCompiledElement) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/psiutils/PsiSelectionSearcher", "searchElementsInSelection"));
            }
            return list;
        }
        ArrayList results = new ArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor((TextRange)selection, filter, results, searchChildrenOfFound){
            final /* synthetic */ TextRange val$selection;
            final /* synthetic */ Class val$filter;
            final /* synthetic */ List val$results;
            final /* synthetic */ boolean val$searchChildrenOfFound;
            {
                this.val$selection = textRange;
                this.val$filter = clazz;
                this.val$results = list;
                this.val$searchChildrenOfFound = bl;
            }

            public void visitElement(PsiElement element) {
                if (!this.val$selection.intersects(element.getTextRange())) {
                    return;
                }
                if (this.val$filter.isAssignableFrom(element.getClass())) {
                    this.val$results.add(element);
                    if (!this.val$searchChildrenOfFound) {
                        return;
                    }
                }
                super.visitElement(element);
            }
        };
        file.accept((PsiElementVisitor)visitor);
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/psiutils/PsiSelectionSearcher", "searchElementsInSelection"));
        }
        return arrayList;
    }
}

