/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import java.io.File;
import kotlin.ArraysKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinLocalClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\r\u0001A1\u0011$\u0001M\u0001;\u00051i!)\u0002R\u0007\u0005A\u0011!J\u0007\u0005\u0017!\rQB\u0001G\u00011\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!J\u0007\u0005\u0017!%QB\u0001G\u00011\tI2\u0001C\u0003\u000e\u0003a-\u0011d\u0001E\u0004\u001b\u0005AB\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "Companion", "RootProvider"}, moduleName="built-in-server")
public final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    private static final Companion.ORDER_ROOT_TYPES.1 ORDER_ROOT_TYPES;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.INSTANCE;
        ORDER_ROOT_TYPES = new NotNullLazyValue<OrderRootType[]>(){

            @NotNull
            protected OrderRootType[] compute() {
                OrderRootType javaDocRootType = org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getJavadocOrderRootType(DefaultWebServerRootsProvider.Companion);
                return javaDocRootType == null ? new OrderRootType[]{OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES} : new OrderRootType[]{javaDocRootType, OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project) {
        Module[] $i$a$1;
        PathInfo result2;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String effectivePath = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((String)effectivePath, (char)'/', (int)0, (boolean)false, (int)6)) > 0) {
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            if (!StringsKt.regionMatches((String)effectivePath, (int)0, (String)string, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                Module module;
                String moduleName = StringsKt.substring((String)effectivePath, (int)0, (int)index);
                AccessToken token = ReadAction.start();
                try {
                    module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                }
                finally {
                    token.finish();
                }
                Module module2 = module;
                if (module2 != null && !module2.isDisposed()) {
                    effectivePath = StringsKt.substring((String)effectivePath, (int)(index + 1));
                    FileResolver resolver = WebServerPathToFileManager.Companion.getInstance(project).getResolver(effectivePath);
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                    RootProvider[] rootProviderArray = RootProvider.values();
                    for (int i = 0; i < rootProviderArray.length; ++i) {
                        RootProvider rootProvider = rootProviderArray[i];
                        ModuleRootManager moduleRootManager2 = moduleRootManager;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                        PathInfo result3 = DefaultWebServerRootsProvider.Companion.findByRelativePath(effectivePath, rootProvider.getRoots(moduleRootManager2), resolver, moduleName);
                        if (result3 == null) continue;
                        return result3;
                    }
                    result2 = DefaultWebServerRootsProvider.Companion.findInModuleLibraries(effectivePath, module2, resolver);
                    if (result2 != null) {
                        return result2;
                    }
                }
            }
        }
        AccessToken token = ReadAction.start();
        try {
            $i$a$1 = ModuleManager.getInstance((Project)project).getModules();
        }
        finally {
            token.finish();
        }
        Module[] modules = $i$a$1;
        FileResolver resolver = WebServerPathToFileManager.Companion.getInstance(project).getResolver(effectivePath);
        if (!ArraysKt.isEmpty((Object[])modules)) {
            RootProvider[] rootProviderArray = RootProvider.values();
            for (int i = 0; i < rootProviderArray.length; ++i) {
                RootProvider rootProvider = rootProviderArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
                result2 = DefaultWebServerRootsProvider.Companion.findByRelativePath(project, effectivePath, modules, rootProvider, resolver);
                if (result2 == null) continue;
                return result2;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
        return DefaultWebServerRootsProvider.Companion.findInLibraries(project, modules, effectivePath, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AccessToken token = ReadAction.start();
        try {
            boolean isLibrary;
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(project);
            DirectoryInfo info = directoryIndex.getInfoForFile(file);
            if (!info.isExcluded() && !info.isInProject()) {
                PathInfo pathInfo = Intrinsics.areEqual((Object)file.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProvider.Companion.getInfoForDocJar(file, project) : (PathInfo)null;
                return pathInfo;
            }
            VirtualFile root = info.getSourceRoot();
            if (root == null) {
                root = info.getContentRoot();
                if (root == null) {
                    void value;
                    root = info.getLibraryClassRoot();
                    isLibrary = true;
                    boolean bl = root != null;
                    if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                        String string = file.getPresentableUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                        String message = string;
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                } else {
                    isLibrary = false;
                }
            } else {
                isLibrary = info.isInLibrarySource();
            }
            Module module = info.getModule();
            if (isLibrary && module == null) {
                OrderEntry[] orderEntryArray = directoryIndex.getOrderEntries(info);
                for (int i = 0; i < orderEntryArray.length; ++i) {
                    OrderEntry entry = orderEntryArray[i];
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    module = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                    break;
                }
            }
            File file2 = null;
            VirtualFile virtualFile = root;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
            PathInfo pathInfo = new PathInfo(file2, file, virtualFile, DefaultWebServerRootsProvider.Companion.getModuleNameQualifier(project, module), isLibrary);
            return pathInfo;
        }
        finally {
            token.finish();
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001B\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011A!1\u0001\r\u0001e!\u0011BA\u0005\u00021\u0001A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u001c\u0011\u0019\u00022A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005e\u0019\u0001bA\u0007\u00021\u000f\t6!\u0001\u0005\u0005c\u0007%Q1\u0002"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;", "", "(Ljava/lang/String;I)V", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "(Lcom/intellij/openapi/roots/ModuleRootManager;)[Lcom/intellij/openapi/vfs/VirtualFile;", "SOURCE", "CONTENT", "EXCLUDED"}, moduleName="built-in-server")
    private static final abstract class RootProvider
    extends Enum<RootProvider> {
        public static final /* enum */ RootProvider SOURCE;
        public static final /* enum */ RootProvider CONTENT;
        public static final /* enum */ RootProvider EXCLUDED;
        private static final /* synthetic */ RootProvider[] $VALUES;

        static {
            RootProvider[] rootProviderArray = new RootProvider[3];
            RootProvider[] rootProviderArray2 = rootProviderArray;
            rootProviderArray[0] = SOURCE = new SOURCE("SOURCE", 0);
            rootProviderArray[1] = CONTENT = new CONTENT("CONTENT", 1);
            rootProviderArray[2] = EXCLUDED = new EXCLUDED("EXCLUDED", 2);
            $VALUES = rootProviderArray;
        }

        @NotNull
        public abstract VirtualFile[] getRoots(@NotNull ModuleRootManager var1);

        public static RootProvider[] values() {
            return (RootProvider[])$VALUES.clone();
        }

        public static RootProvider valueOf(String string) {
            return Enum.valueOf(RootProvider.class, string);
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Aa9\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002Ks!1\u0002c\u0001\u000e'%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0002\u0019\u0006A\u0019Q#C\u0005\b\t\u0003IQ\u0001E\u0002\u0016\u00051\u0005\u0001T\u0001M\u00031\tA\"!G\u0002\t\b5\t\u0001\u0004B)\u0004\u0003!%\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider$SOURCE;", "Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;", "(Ljava/lang/String;I)V", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "(Lcom/intellij/openapi/roots/ModuleRootManager;)[Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="built-in-server")
        public static final class SOURCE
        extends RootProvider {
            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getSourceRoots();
            }

            SOURCE() {
            }
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Aa9\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002Ks!1\u0002c\u0001\u000e'%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0002\u0019\u0006A\u0019Q#C\u0005\b\t\u0003IQ\u0001E\u0002\u0016\u00051\u0005\u0001T\u0001M\u00031\tA\"!G\u0002\t\b5\t\u0001\u0004B)\u0004\u0003!%\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider$CONTENT;", "Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;", "(Ljava/lang/String;I)V", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "(Lcom/intellij/openapi/roots/ModuleRootManager;)[Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="built-in-server")
        public static final class CONTENT
        extends RootProvider {
            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getContentRoots();
            }

            CONTENT() {
            }
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Aa9\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002Ks!1\u0002c\u0001\u000e'%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0002\u0019\u0006A\u0019Q#C\u0005\b\t\u0003IQ\u0001E\u0002\u0016\u00051\u0005\u0001T\u0001M\u00031\tA\"!G\u0002\t\b5\t\u0001\u0004B)\u0004\u0003!%\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider$EXCLUDED;", "Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;", "(Ljava/lang/String;I)V", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "(Lcom/intellij/openapi/roots/ModuleRootManager;)[Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="built-in-server")
        public static final class EXCLUDED
        extends RootProvider {
            @Override
            @NotNull
            public VirtualFile[] getRoots(@NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                return rootManager.getExcludeRoots();
            }

            EXCLUDED() {
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"b\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005A\t\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!A!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!&\u0001\u0003\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!*\u0010\u0005\u0003!!QB\u0001G\u00011\u0013I2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\u0007\u0004\t\u000f5!\u0011BA\u0005\u00021!Az!G\u0002\t\u00125\t\u0001$C\r\u0004\u0011'i\u0011\u0001\u0007\u0006R\u0007\u0005A)\"j\u000e\u0005\u0003!!QB\u0001G\u00011\u0013I2\u0001\u0003\u0004\u000e\u0003a5\u0011D\u0002\u0005\f\u001b\u0011I!!C\u0001\u0019\u0018a=\u0011d\u0001E\n\u001b\u0005A\"\"\u0007\u0003\t\u00195\u0011A\u0012\u0001M\u0007#\u000e\t\u0001\u0012DS\u001b\t\u0005AQ\"\u0004\u0002\r\u0002a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\u0007\u0004\t\u000f5!\u0011BA\u0005\u00021!Az!G\u0002\t\r5\t\u0001TB\r\u0004\u0011'i\u0011\u0001\u0007\u0006R\u0007\u0005AY\"J\u000b\u0005\u0003!qQB\u0001G\u00011\u0013I2\u0001#\b\u000e\u0003a5\u0011d\u0001\u0005\u0010\u001b\u0005Aj!G\u0002\t 5\t\u0001\u0004E\r\u0004\u0011'i\u0011\u0001\u0007\u0006&#\u0011\t\u0001\u0012E\u0007\u0003\u0019\u0003AJ!G\u0002\t\r5\t\u0001TB\r\u0004\u0011Ei\u0011\u0001\u0007\u0005\u001a\u0007!MQ\"\u0001\r\u000bKm!\u0011\u0001#\t\u000e\u0003a\r\u0012d\u0001E\n\u001b\u0005A\"\"G\u0002\t\u001e5\t\u0001TB\r\u0004\u0011=i\u0011\u0001'\u0004\u001a\r!\u0011R\u0002B\u0005\u0003\u0013\u0005AJ\u0001'\n\u001a\u0007!\tR\"\u0001\r\tK5!\u0011\u0001C\n\u000e\u00051\u0005\u0001\u0014B\r\u0004\u0011Oi\u0011\u0001g\u0006\u001a\u0007!)Q\"\u0001M\u0006K\u0015!\u0011\u0001\u0003\u000b\u000e\u00051\u0005\u0001\u0014F\u0013\u000f\t\u0005AQ#\u0004\u0002\r\u0002a5\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\u0007\u0003\t#5\u0011A\u0012\u0001\r\tS1!\u0011\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0007\u000b\tA9\u0001$\u0001\u000e\u0005\u0011\u0015\u0001b\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$Companion;", "", "()V", "ORDER_ROOT_TYPES", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$Companion$ORDER_ROOT_TYPES$1", "getORDER_ROOT_TYPES", "()Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$Companion$ORDER_ROOT_TYPES$1;", "Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$Companion$ORDER_ROOT_TYPES$1;", "findByRelativePath", "Lorg/jetbrains/builtInWebServer/PathInfo;", "project", "Lcom/intellij/openapi/project/Project;", "path", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "rootProvider", "Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Lcom/intellij/openapi/module/Module;Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$RootProvider;Lorg/jetbrains/builtInWebServer/FileResolver;)Lorg/jetbrains/builtInWebServer/PathInfo;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/builtInWebServer/FileResolver;Ljava/lang/String;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInLibraries", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lorg/jetbrains/builtInWebServer/FileResolver;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInLibrary", "libraryFileName", "relativePath", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "findInModuleLibraries", "module", "", "result", "Lcom/intellij/openapi/util/Ref;", "getInfoForDocJar", "file", "getJavadocOrderRootType", "Lcom/intellij/openapi/roots/OrderRootType;", "getModuleNameQualifier"}, moduleName="built-in-server")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final ORDER_ROOT_TYPES.1 getORDER_ROOT_TYPES() {
            return ORDER_ROOT_TYPES;
        }

        private final OrderRootType getJavadocOrderRootType() {
            try {
                return JavadocOrderRootType.getInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }

        private final PathInfo findInModuleLibraries(String path, Module module, FileResolver resolver) {
            int index = StringsKt.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index <= 0) {
                return null;
            }
            Ref result2 = Ref.create();
            String string = StringsKt.substring((String)path, (int)0, (int)index);
            String string2 = StringsKt.substring((String)path, (int)(index + 1));
            Ref ref = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
            this.findInModuleLibraries(resolver, string, string2, (Ref<PathInfo>)ref, module);
            return (PathInfo)result2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo findInLibraries(Project project, Module[] modules, String path, FileResolver resolver) {
            int index = StringsKt.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index < 0) {
                return null;
            }
            String libraryFileName = StringsKt.substring((String)path, (int)0, (int)index);
            String relativePath = StringsKt.substring((String)path, (int)(index + 1));
            AccessToken token = ReadAction.start();
            try {
                int n;
                Ref result2 = Ref.create();
                Module[] moduleArray = modules;
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    Ref ref = result2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
                    if (!Companion.findInModuleLibraries(resolver, libraryFileName, relativePath, (Ref<PathInfo>)ref, module)) continue;
                    PathInfo pathInfo = (PathInfo)result2.get();
                    return pathInfo;
                }
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    PathInfo pathInfo = Companion.findInLibrary(libraryFileName, relativePath, (Library)module, resolver);
                    if (pathInfo == null) continue;
                    PathInfo pathInfo2 = pathInfo;
                    return pathInfo2;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final boolean findInModuleLibraries(FileResolver resolver, String libraryFileName, String relativePath, Ref<PathInfo> result2, Module module) {
            ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)new Processor<Library>(result2, libraryFileName, relativePath, resolver){
                final /* synthetic */ Ref $result;
                final /* synthetic */ String $libraryFileName;
                final /* synthetic */ String $relativePath;
                final /* synthetic */ FileResolver $resolver;

                public boolean process(@NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    this.$result.set((Object)org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$findInLibrary(DefaultWebServerRootsProvider.Companion, this.$libraryFileName, this.$relativePath, library, this.$resolver));
                    return this.$result.isNull();
                }
                {
                    this.$result = $captured_local_variable$0;
                    this.$libraryFileName = $captured_local_variable$1;
                    this.$relativePath = $captured_local_variable$2;
                    this.$resolver = $captured_local_variable$3;
                }
            });
            return !result2.isNull();
        }

        private final PathInfo findInLibrary(String libraryFileName, String relativePath, Library library, FileResolver resolver) {
            OrderRootType[] orderRootTypeArray = (OrderRootType[])this.getORDER_ROOT_TYPES().getValue();
            for (int i = 0; i < orderRootTypeArray.length; ++i) {
                OrderRootType rootType = orderRootTypeArray[i];
                VirtualFile[] virtualFileArray = library.getFiles(rootType);
                for (int j = 0; j < virtualFileArray.length; ++j) {
                    VirtualFile root = virtualFileArray[j];
                    if (!StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)libraryFileName)) continue;
                    VirtualFile virtualFile = root;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                    PathInfo pathInfo = FileResolver.DefaultImpls.resolve$default(resolver, relativePath, virtualFile, null, true, 4);
                    if (pathInfo == null) {
                        continue;
                    }
                    PathInfo result2 = pathInfo;
                    return result2;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo getInfoForDocJar(VirtualFile file, Project project) {
            OrderRootType orderRootType = this.getJavadocOrderRootType();
            if (orderRootType == null) {
                return null;
            }
            OrderRootType javaDocRootType = orderRootType;
            @KotlinLocalClass(version={1, 0, 0})
            @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"(\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001E\u0006\u000b\u0001)\n\u0001\u0001\u0003\u0006\u0019\u0001IB!\u0003\u0002\n\u0003a\t\u0001\u0014AQ\u0003#\u000e\t\u00012A\u0013\t\t-A\u0001\"D\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021\u0005Ic\u0002B\"\u001d\u0011\ti!\u0001$\u0001\u0019\u0006E\u001bq!\u0002\u0001\u000e\u0005\u0011\u0019\u0001rA\t\u0003\t\u0011AI!\u000b\b\u0005\u0007rAQ!\u0004\u0002\r\u0002a-\u0011kA\u0004\u0006\u00015\u0011AA\u0002E\u0007#\t!q\u0001c\u0004"}, strings={"org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider$Companion$getInfoForDocJar$LibraryProcessor", "Lcom/intellij/util/Processor;", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/OrderRootType;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "setModule", "(Lcom/intellij/openapi/module/Module;)V", "result", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getResult", "()Lorg/jetbrains/builtInWebServer/PathInfo;", "setResult", "(Lorg/jetbrains/builtInWebServer/PathInfo;)V", "process", "", "library"}, moduleName="built-in-server")
            public final class LibraryProcessor
            implements Processor<Library> {
                @Nullable
                private PathInfo result;
                @Nullable
                private Module module;
                final /* synthetic */ OrderRootType $javaDocRootType;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Project $project;

                @Nullable
                public final PathInfo getResult() {
                    return this.result;
                }

                public final void setResult(@Nullable PathInfo pathInfo) {
                    this.result = pathInfo;
                }

                @Nullable
                public final Module getModule() {
                    return this.module;
                }

                public final void setModule(@Nullable Module module) {
                    this.module = module;
                }

                public boolean process(@NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    VirtualFile[] virtualFileArray = library.getFiles(this.$javaDocRootType);
                    for (int i = 0; i < virtualFileArray.length; ++i) {
                        VirtualFile root = virtualFileArray[i];
                        if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.$file, (boolean)false)) continue;
                        File file = null;
                        VirtualFile virtualFile = root;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                        this.result = new PathInfo(file, this.$file, virtualFile, org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getModuleNameQualifier(DefaultWebServerRootsProvider.Companion, this.$project, this.module), true);
                        return false;
                    }
                    return true;
                }

                public LibraryProcessor(OrderRootType $captured_local_variable$0, VirtualFile $captured_local_variable$1, Project $captured_local_variable$2) {
                    this.$javaDocRootType = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                }
            }
            LibraryProcessor processor2 = new LibraryProcessor(javaDocRootType, file, project);
            AccessToken token = ReadAction.start();
            try {
                int n;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Module[] moduleArray = moduleManager.getModules();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    processor2.setModule(module);
                    ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)processor2);
                    if (processor2.getResult() == null) continue;
                    PathInfo pathInfo = processor2.getResult();
                    return pathInfo;
                }
                processor2.setModule(null);
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    if (processor2.process((Library)module)) continue;
                    PathInfo pathInfo = processor2.getResult();
                    return pathInfo;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final String getModuleNameQualifier(Project project, Module module) {
            if (module != null && PlatformUtils.isIntelliJ() && !StringsKt.equals((String)module.getName(), (String)project.getName(), (boolean)true)) {
                String string = module.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                if (!BuiltInWebServerKt.compareNameAndProjectBasePath(string, project)) {
                    return module.getName();
                }
            }
            return null;
        }

        private final PathInfo findByRelativePath(String path, VirtualFile[] roots, FileResolver resolver, String moduleName) {
            for (int i = 0; i < roots.length; ++i) {
                VirtualFile root = roots[i];
                PathInfo pathInfo = FileResolver.DefaultImpls.resolve$default(resolver, path, root, moduleName, false, 8);
                if (pathInfo == null) {
                    continue;
                }
                PathInfo result2 = pathInfo;
                return result2;
            }
            return null;
        }

        private final PathInfo findByRelativePath(Project project, String path, Module[] modules, RootProvider rootProvider, FileResolver resolver) {
            for (int i = 0; i < modules.length; ++i) {
                ModuleRootManager moduleRootManager;
                Module module = modules[i];
                if (module.isDisposed()) continue;
                ModuleRootManager moduleRootManager2 = moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                PathInfo result2 = this.findByRelativePath(path, rootProvider.getRoots(moduleRootManager2), resolver, null);
                if (result2 == null) continue;
                result2.setModuleName(this.getModuleNameQualifier(project, module));
                return result2;
            }
            return null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }

        @Nullable
        public static final /* synthetic */ OrderRootType access$getJavadocOrderRootType(Companion $this) {
            return $this.getJavadocOrderRootType();
        }
    }
}

