/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.NettyUtil;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AA!\u0002\u0001\u0005'1\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015\"AA\u0003E\u0006\u001b\u0005Ab!J\b\u0005%!5Q\"\u0001\r\u00073\rAq!D\u0001\u0019\u0010e1\u0001\u0002C\u0007\u0005\u0013\tI\u0011\u0001G\u0005\u0019\u0012\u0015RBA\u0003E\n\u001b\u0005Ab!\u0007\u0004\t\u00155!\u0011BA\u0005\u00021-A*\"G\u0002\t\u00185\t\u0001\u0004D\r\u0004\u00113i\u0011\u0001G\u0006\u001a\r!AQ\u0002B\u0005\u0003\u0013\u0005A\u0012\u0002'\u0005*!\u0011\u0015E\u0004#\u0002\u000e\u00051\u0005\u0001d\u0001\u000f\u0003A\t\t6aB\u0003\u0001\u001b\t!9\u0001\u0003\u0003\u0012\u0005\u0011%\u0001\"\u0002"}, strings={"Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "Lorg/jetbrains/builtInWebServer/NetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "processChannel", "Lio/netty/channel/Channel;", "getProcessChannel", "()Lio/netty/channel/Channel;", "setProcessChannel", "(Lio/netty/channel/Channel;)V", "closeProcessConnections", "", "configureBootstrap", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/execution/process/OSProcessHandler;", "port", "", "processHandler"}, moduleName="built-in-server")
public abstract class SingleConnectionNetService
extends NetService {
    @Nullable
    private volatile Channel processChannel;

    @Nullable
    protected final Channel getProcessChannel() {
        return this.processChannel;
    }

    protected final void setProcessChannel(@Nullable Channel channel) {
        this.processChannel = channel;
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    @Override
    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Bootstrap bootstrap;
        Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap bootstrap2 = bootstrap = NettyUtil.oioClientBootstrap();
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        this.configureBootstrap(bootstrap2, errorOutputConsumer);
        Channel channel = NettyUtil.connect(bootstrap, new InetSocketAddress(NetUtils.getLoopbackAddress(), port), promise);
        if (channel != null) {
            this.processChannel = channel;
            promise.setResult((Object)processHandler2);
        }
    }

    @Override
    protected void closeProcessConnections() {
        Channel currentProcessChannel = this.processChannel;
        if (currentProcessChannel != null) {
            this.processChannel = null;
            NettyUtil.closeAndReleaseFactory(currentProcessChannel);
        }
    }

    public SingleConnectionNetService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, null, 2, null);
    }
}

