/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.StringsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!B\u0001\u0005\u0006\u0015\t\u00012B\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001cD\r\u00021\u0003i\naDQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K\u0011!\u0011\u0001\u0003\u0005\u000e\u0003aEQu\u0003\u0003\u0001\u0011%i!\u0001$\u0001\u0019\fe\u0019\u00012C\u0007\u00021\u0013\t6!\u0001\u0003\u000bK9!9\u0001#\u0006\u000e\u00051\u0005\u0001tB\r\u0004\u0011'i\u0011\u0001'\u0003\u001a\t\u0011\t\u0001bC\u0007\u00021/)\u0003\u0002\u0003\u0007\u000e\u00051\u0005\u0001\u0014B\r\u0004\u00113i\u0011\u0001g\u0004&\u0013\u0011\t\u0001\"D\u0007\u0003\u0019\u0003AZ!G\u0002\t\u001c5\t\u0001tB\u0013\u000f\t\u000fAQ\"\u0004\u0002\r\u0002a-\u0011d\u0001E\n\u001b\u0005AJ!\u0007\u0003\u0005\u0003!YQ\"\u0001M\fK\u001dAa\"D\u0001\u0019\u001ee\u0019\u00012C\u0007\u00021\u0013I#\u0006B\"\t\u0011\u000fi\u0011%\u0003\u0004\n\u000bA)QC\u0001G\u00011\u0013AJ!\u0003\u0004\n\u000bA)QC\u0001G\u00011\u0017AZ\u0001E\u0003\u0016!%1\u0011\"\u0002\t\u0006+\ta\t\u0001'\u0003\u0019\n%1\u0011\"\u0002\t\u0006+\ta\t\u0001g\u0003\u0019\f1\u0005\u0001\u0004\u0002\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*O\u0011\t\u0005\u0002C\u0004\u000eC%1\u0011\"\u0002\t\u0006+\ta\t\u0001g\u0004\u0019\u0010%1\u0011\"\u0002\t\u0006+\ta\t\u0001g\u0003\u0019\fA)Q\u0003E\u0005\u0007\u0013\u0015\u0001R!\u0006\u0002\r\u0002a=\u0001tB\u0005\u0007\u0013\u0015\u0001R!\u0006\u0002\r\u0002a-\u00014\u0002G\u00011\u0011AB!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "", "application", "Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/project/Project;)V", "pathToInfoCache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getPathToInfoCache", "()Lcom/google/common/cache/Cache;", "virtualFileToPathInfo", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearCache", "", "doFindByRelativePath", "path", "doFindByRelativePath$built_in_server", "findVirtualFile", "cacheResult", "", "getPath", "file", "getPathInfo", "child", "getResolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "Companion"}, moduleName="built-in-server")
public final class WebServerPathToFileManager {
    private static final Companion.RELATIVE_PATH_RESOLVER.1 RELATIVE_PATH_RESOLVER;
    private static final Companion.EMPTY_PATH_RESOLVER.1 EMPTY_PATH_RESOLVER;
    private final Cache<String, PathInfo> pathToInfoCache;
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    private final Project project;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.builtInWebServer.WebServerPathToFileManager$Companion.INSTANCE;
        RELATIVE_PATH_RESOLVER = new FileResolver(){

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                if (root.isInLocalFileSystem() && Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                    File file = new File(root.getPath(), path);
                    if (file.exists()) {
                        return new PathInfo(file, (VirtualFile)null, root, moduleName, isLibrary);
                    }
                    return null;
                }
                VirtualFile virtualFile = root.findFileByRelativePath(path);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                return new PathInfo((File)null, file, root, moduleName, isLibrary);
            }
        };
        EMPTY_PATH_RESOLVER = new FileResolver(){

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                return new PathInfo((File)null, file, root, moduleName, isLibrary);
            }
        };
    }

    public final Cache<String, PathInfo> getPathToInfoCache() {
        return this.pathToInfoCache;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = this.getPathInfo(path, cacheResult);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        VirtualFile virtualFile = pathInfo2.getFile();
        if (virtualFile == null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            File file = pathInfo2.getIoFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            return localFileSystem.findFileByIoFile(file);
        }
        return virtualFile;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.findVirtualFile(string, bl);
    }

    @JvmOverloads
    @Nullable
    public VirtualFile findVirtualFile(@NotNull String string) {
        return WebServerPathToFileManager.findVirtualFile$default(this, string, false, 2);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = this.doFindByRelativePath$built_in_server(path);
            if (cacheResult && pathInfo != null && pathInfo.isValid()) {
                this.pathToInfoCache.put((Object)path, (Object)pathInfo);
            }
        }
        return pathInfo;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.getPathInfo(string, bl);
    }

    @JvmOverloads
    @Nullable
    public PathInfo getPathInfo(@NotNull String string) {
        return WebServerPathToFileManager.getPathInfo$default(this, string, false, 2);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    private final PathInfo getPathInfo(VirtualFile child) {
        PathInfo result2 = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child);
        if (result2 == null) {
            WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
            for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
                WebServerRootsProvider infoProvider = webServerRootsProviderArray[i];
                result2 = infoProvider.getPathInfo(child, this.project);
                if (result2 == null) continue;
                this.virtualFileToPathInfo.put((Object)child, (Object)result2);
                break;
            }
        }
        return result2;
    }

    @Nullable
    public final PathInfo doFindByRelativePath$built_in_server(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
        for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
            WebServerRootsProvider rootsProvider = webServerRootsProviderArray[i];
            PathInfo result2 = rootsProvider.resolve(path, this.project);
            if (result2 == null) continue;
            if (result2.getFile() != null) {
                this.virtualFileToPathInfo.put((Object)result2.getFile(), (Object)result2);
            }
            return result2;
        }
        return null;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return StringsKt.isEmpty((String)path) ? (FileResolver)WebServerPathToFileManager.Companion.getEMPTY_PATH_RESOLVER() : (FileResolver)WebServerPathToFileManager.Companion.getRELATIVE_PATH_RESOLVER();
    }

    public WebServerPathToFileManager(@NotNull Application application, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.pathToInfoCache = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.virtualFileToPathInfo = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        application.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file = ((VFileContentChangeEvent)vFileEvent).getFile();
                        WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
                        for (int i = 0; i < webServerRootsProviderArray.length; ++i) {
                            WebServerRootsProvider rootsProvider = webServerRootsProviderArray[i];
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.clearCache();
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003\u0011\u0015Q!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ#\u0001B\u0005\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u0005\u0005\b!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0011%bA!\u0011\u0005\t\u00045\t\u0001DA)\u0004\r\u0015\u0011\u0001r\u0001G\u0001\u001b\t!)\u0001C\u0002*\u0019\u0011\t\u0005\u0002\u0003\u0003\u000e\u0003a%\u0011k\u0001\u0004\u0006\u0005!1A\u0012A\u0007\u0003\t\u0015AY\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion;", "", "()V", "EMPTY_PATH_RESOLVER", "org/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$EMPTY_PATH_RESOLVER$1", "getEMPTY_PATH_RESOLVER", "()Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$EMPTY_PATH_RESOLVER$1;", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$EMPTY_PATH_RESOLVER$1;", "RELATIVE_PATH_RESOLVER", "org/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$RELATIVE_PATH_RESOLVER$1", "getRELATIVE_PATH_RESOLVER", "()Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$RELATIVE_PATH_RESOLVER$1;", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion$RELATIVE_PATH_RESOLVER$1;", "getInstance", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "project", "Lcom/intellij/openapi/project/Project;"}, moduleName="built-in-server")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final RELATIVE_PATH_RESOLVER.1 getRELATIVE_PATH_RESOLVER() {
            return RELATIVE_PATH_RESOLVER;
        }

        private final EMPTY_PATH_RESOLVER.1 getEMPTY_PATH_RESOLVER() {
            return EMPTY_PATH_RESOLVER;
        }

        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            WebServerPathToFileManager webServerPathToFileManager = (WebServerPathToFileManager)ServiceManager.getService((Project)project, WebServerPathToFileManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)webServerPathToFileManager, (String)"ServiceManager.getServic\u2026oFileManager::class.java)");
            return webServerPathToFileManager;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

