/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Function;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"=\u0015\u0001Q!\u0001E\u0006\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!AG\u000f\u0011\riA!\u0003\u0002\n\u0003\u0011\u001e\u0001$A\t\u0003\t\u0001A9!G\u0002\t\t5\t\u0001\u0014\u0002+\u0004\u000555\u0001\"B\u0007\u0004\u0013\u0005!\u0019\u0001G\u0001U\u0007\tiy\u0003C\u0003\u000e\u0016%1\u0011\"\u0002I\u0006+\ta\t\u0001j\u0002%\ba\t\u0011kA\u0001\u0005\rE\u0011A\u0001\u0001E\u00043\rAi!D\u0001%\bE\u001b\u0011\u0001C\u0004U\u0007\tiY\u0003B\"\u0011\u0011\u001fi\u0011\u0001\u0007\u0005\u0016\r%!A\u0011A\u0005\u0003\u0019\u0003A\u0012\u0002'\u0005\u001a\u0010!MQ\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002\u0007\u0006Q\u0007\u0003!6AA\u0007(\t\r\u0003\u0002RCG\u000b\u0013\u0019IQ\u0001e\u0003\u0016\u00051\u0005Ae\u0003\u0013\f1\u0005\t6!\u0001\u0003\u0007#\t!\u0001\u0001c\u0002\u0012\u0005\u0011\u0005\u0001bC\u000b\u0005\u0013\tI\u0011\u0001j\u0002\u0019\u0003e]AA\u0001E\f\u001b\u001dI!!C\u0001%\b%\u0011\u0011\"\u0001\u0013\f11\u00016\u0011\u0001+\u0004\u00055QCa\u0011\t\t\u001a5U\u0011BB\u0005\u0006!\u0017)\"\u0001$\u0001%\u0017\u0011Z\u0001$A)\u0004\u0003\u00111\u0011C\u0001\u0003\u0001\u0011\u000f\t\"\u0001\"\u0001\t\u0017U!\u0011BA\u0005\u0002I\u000fA\u0012!'\b\u0005\u0005!]QBC\u0005\u0003\u0013\u0005!;!C\u0003\n\t%\u0011\u0011\"\u0001\u0013\f1\u0005AB\u0002UB\u0001)\u000e\u0011Qb\t\u0003D!!iQrB\u0005\u0004\u0013\ta\t\u0001G\u0005\u0019\u0003E\u001b\u0011\u0001\u0002\u0004\u0012\u0005\u0011\u0001\u0001rA\u000b\u0005\u0013\tI\u0011\u0001j\u0002\u0019\u0003emAA\u0001E\f\u001b%I!!C\u0001%\b%!\u0011bA\u0005\u0002\t\u0007A\u0012\u0001\u0007\u0007Q\u0007\u0003!6AAI\u0010\t\rC\u0001\u0002A\u0007\u00021\u0003)2!C\u0001\u0005\u0004a\tAdI)\u0004\u00075\u0011A\u0001\u0001E\u0002)\u000e\u0011\u0011s\u0004\u0003D\u0011!\u0015Q\"\u0001M\u0001+\rI\u0011\u0001b\u0001\u0019\u0003q\u0019\u0013kA\u0002\u000e\u0005\u0011\u0015\u00012\u0001+\u0004\u0005\u0001"}, strings={"isPending", "", "Lorg/jetbrains/concurrency/Promise;", "(Lorg/jetbrains/concurrency/Promise;)Z", "PromiseKt", "isRejected", "rejectedPromise", "T", "error", "", "resolvedPromise", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "catchError", "", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "task", "Lkotlin/Function0;", "then", "SUB_RESULT", "handler", "Lkotlin/Function1;", "thenAsync", "thenAsyncAccept"}, moduleName="platform-impl")
public final class PromiseKt {
    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> then(Promise<T> $receiver, @NotNull Function1<? super T, ? extends SUB_RESULT> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new Function<T, SUB_RESULT>(handler2){
            final /* synthetic */ Function1 $handler;

            public SUB_RESULT fun(T param) {
                return (SUB_RESULT)this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final <T, SUB_RESULT> Promise<SUB_RESULT> thenAsync(Promise<T> $receiver, @NotNull Function1<? super T, ? extends Promise<SUB_RESULT>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new AsyncFunction<T, SUB_RESULT>(handler2){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<SUB_RESULT> fun(T param) {
                return (Promise)this.$handler.invoke(param);
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final <T> Promise<Object> thenAsyncAccept(Promise<T> $receiver, @NotNull Function1<? super T, ? extends Promise<?>> handler2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return $receiver.then(new AsyncFunction<T, Object>(handler2){
            final /* synthetic */ Function1 $handler;

            @NotNull
            public Promise<Object> fun(T param) {
                Object object = this.$handler.invoke(param);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                }
                return (Promise)object;
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public static final Promise<?> resolvedPromise() {
        Promise promise = Promise.DONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.DONE");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise(T result2) {
        return Promise.resolve(result2);
    }

    @NotNull
    public static final <T> Promise<T> rejectedPromise(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Promise promise = Promise.reject((String)error);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.reject(error)");
        return promise;
    }

    public static final boolean isRejected(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getState(), (Object)Promise.State.REJECTED);
    }

    public static final boolean isPending(Promise<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getState(), (Object)Promise.State.PENDING);
    }

    public static final void catchError(AsyncPromise<? extends Object> $receiver, @NotNull Function0<? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            task.invoke();
        }
        catch (Throwable e) {
            $receiver.setError(e);
        }
    }
}

