/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"g\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\t\u00012\u0002\u0003\f\u0019\u0001I\u0012\u0001'\u0001\u001a\u0003a\t\u0011UA)\u0004\u0003!\rQ\u0005\u0007\u0003\f\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u00073\rAq!D\u0001\u0019\u0010e\u0019\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003aM\u0011d\u0001\u0005\u000b\u001b\u0005A*\"\n\r\u0005\u0017!YQ\"\u0001M\u00063\rAa!D\u0001\u0019\u0018e\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aE\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00155\t\u0001TC\u0013\t\t-AA\"D\u0001\u0019\u001ae\u0019\u0001\"D\u0007\u000217)\u001b\u0003B\u0006\t\u001d5U\u0011BB\u0005\u0006!\r)\"\u0001$\u0001\u0019\u0002a\u0005\u0001TA)\u0004\u0003\u0011\u001d\u0011d\u0001\u0005\t\u001b\u0005A\n\"j\t\u0005\u0017!uQr\u0001\r\u0010#\u000e\tAqA\r\u0007\u0011?iA!\u0003\u0002\n\u0003ay\u0001\u0004E\r\u0004\u0011Ci\u0011\u0001G\t*(\u0011\u0011\u0005\u0002\u0003\u0002\u000e\u0016%1\u0011\"\u0002\t\u0004+\ta\t\u0001'\u0001\u0019\u0002a\u0015\u0011kA\u0001\u0005\bE\u001bA!\u0002\u0001\u000e\u0005\u0011!\u0001\u0012\u0002"}, strings={"Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "Lorg/jetbrains/debugger/MemberFilter;", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "()V", "defaultMemberFilterPromise", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDefaultMemberFilterPromise", "()Lorg/jetbrains/concurrency/Promise;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "createFrameEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getMemberFilter", "propertyNamesToString", "", "list", "", "quotedAware", ""}, moduleName="script-debugger-ui")
public class BasicDebuggerViewSupport
implements MemberFilter,
DebuggerViewSupport {
    @NotNull
    private final Promise<MemberFilter> defaultMemberFilterPromise = Promise.resolve((Object)this);

    @NotNull
    protected final Promise<MemberFilter> getDefaultMemberFilterPromise() {
        return this.defaultMemberFilterPromise;
    }

    @Override
    @NotNull
    public String propertyNamesToString(@NotNull List<? extends String> list, boolean quotedAware) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return ValueModifierUtil.propertyNamesToString(list, quotedAware);
    }

    @Override
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setObjectPresentation(value, icon, node);
    }

    @Override
    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return new PromiseDebuggerEvaluator(frame);
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.defaultMemberFilterPromise;
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.isMemberVisible(this, variable);
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return MemberFilter.DefaultImpls.getAdditionalVariables(this);
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.rawNameToSource(this, variable);
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return MemberFilter.DefaultImpls.sourceNameToRaw(this, name);
    }

    @Override
    public boolean hasNameMappings() {
        return MemberFilter.DefaultImpls.hasNameMappings(this);
    }

    @Override
    @Nullable
    public Vm getVm() {
        return DebuggerViewSupport.DefaultImpls.getVm(this);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo(this, script, frame);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, scriptUrl, line, column);
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return DebuggerViewSupport.DefaultImpls.getSourceInfo((DebuggerViewSupport)this, functionName, script, line, column);
    }

    @Override
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return DebuggerViewSupport.DefaultImpls.canNavigateToSource(this, variable, context);
    }

    @Override
    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        DebuggerViewSupport.DefaultImpls.computeSourcePosition(this, name, value, variable, context, navigatable);
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return DebuggerViewSupport.DefaultImpls.computeInlineDebuggerData(this, name, variable, context, callback);
    }

    @Override
    @Nullable
    public Promise<?> computeAdditionalObjectProperties(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return DebuggerViewSupport.DefaultImpls.computeAdditionalObjectProperties(this, value, variable, context, node);
    }

    @Override
    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return DebuggerViewSupport.DefaultImpls.transformErrorOnGetUsedReferenceValue(this, value, error);
    }

    @Override
    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return DebuggerViewSupport.DefaultImpls.isInLibraryContent(this, sourceInfo, script);
    }
}

