/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LineBreakpointManager;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\tA1\u0001\u0007\u00013\u0019IA!C\u0002\n\u0003\u0011\r\u0001$\u0001M\u0001CSI\u0011\u0002c\u0001\u000e\u000f%)A\u0011A\u0005\u0004\u0013\u0005!\u0019\u0001'\u0002\u0019\u0005%\u0019\u0001bA\u0007\u00021\u000fI1\u0001\u0003\u0003\u000e\u0003a%\u0011kA\u0001\t\u000b\u0015RAa\u0003E\u0006\u001b\u0005Ab!G\u0003\t\u000e5\u0019\u0011\"\u0001C\u00021\u0005)c\u0002B\u0006\t\u000f5\t\u0001DB\r\u0006\u0011\u001bi1!C\u0001\u0005\u0004a\t\u0011d\u0001E\b\u001b\u0005AJ!K\u0004\u0005\u0003\"A1!D\u0001\u0019\bE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0003\u000e\u0003a%\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/LineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "breakpointTypeClass", "Ljava/lang/Class;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "manager", "Lorg/jetbrains/debugger/LineBreakpointManager;", "onlySourceMappedBreakpoints", "", "(Ljava/lang/Class;Lorg/jetbrains/debugger/LineBreakpointManager;Z)V", "registerBreakpoint", "", "breakpoint", "unregisterBreakpoint", "temporary"}, moduleName="script-debugger-ui")
public final class LineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<?>> {
    private final LineBreakpointManager manager;
    private final boolean onlySourceMappedBreakpoints;

    public void registerBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        this.manager.setBreakpoint(breakpoint, this.onlySourceMappedBreakpoints);
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        this.manager.removeBreakpoint(breakpoint, temporary);
    }

    public LineBreakpointHandler(@NotNull Class<? extends XLineBreakpointType<?>> breakpointTypeClass, @NotNull LineBreakpointManager manager, boolean onlySourceMappedBreakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpointTypeClass, (String)"breakpointTypeClass");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        super(breakpointTypeClass);
        this.manager = manager;
        this.onlySourceMappedBreakpoints = onlySourceMappedBreakpoints;
    }
}

