/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!\u0005R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0019!1\u0003\u0004\u0001\u001a\u0003a\u0005\u0011\u0015C\u0005\u0006\u0011\u0005i1!C\u0001\u0005\u0004a\r\u0011kA\u0001\t\u0005\u0015rAA\u0003\u0005\r\u001b\u0005AJ\"G\u0003\t\u001b5\u0019\u0011\"\u0001C\u00021\u001bI2\u0001c\u0007\u000e\u0003aqQe\u0001E\u000f\u001b\u0005AJ\"J\f\u0005%!yQ\"\u0001M\u00103\u0019AQ\"\u0004\u0003\n\u0003\u0011\rA\u0012\u0001M\u00073\rA)!D\u0001\u0019\u0007e\u0019\u0001\u0002E\u0007\u00021CI2\u0001C\t\u000e\u0003aqQe\u0004E\u0012\u001b\rI\u0011\u0001b\u0001\u0019%e)\u0001\"D\u0007\u0004\u0013\u0005!\u0019\u0001'\u0004\u001a\u0007!mQ\"\u0001\r\u000fK-!!\u0003#\n\u000e\t%\u0011\u0011\"\u0001M\b1MI2\u0001c\n\u000e\u0003a!Re\u0005\u0003\u0003\u0011Si\u0011\u0001g\u0004\u001a\r!iQ\u0002B\u0005\u0002\t\u0007a\t\u0001'\u0004\u001a\u0007!\u0001R\"\u0001M\u00113\rA\u0011#D\u0001\u0019\u001d\u0015BAa\u0003\u0005\u0016\u001b\u0005Ab\"G\u0002\t\u001b5\t\u0001tB\u0013\u000b\u0011Wi\u0011\u0001\u0007\b\u001a\r!1R\u0002B\u0005\u0003\u0013\u0005Az\u0001G\n&\u000b!5RbA\u0005\u0002\t\u0007A\"#J\b\t/5\u0019\u0011\"\u0001C\u00021IIR\u0001C\u0007\u000e\u0007%\tA1\u0001M\u00073\rAy#D\u0001\u0019\u001d\u0015:\u0001\u0002G\u0007\u000213I2\u0001c\n\u000e\u0003a!R%\u0004E\u0019\u001b\u0005AJ\"G\u0003\t\u001b5\u0019\u0011\"\u0001C\u00021\u001bI2\u0001C\r\u000e\u0003aqQ\u0005\u0005E\u0019\u001b\u0005AJ\"G\u0003\t\u001b5\u0019\u0011\"\u0001C\u00021\u001bIb\u0001c\r\u000e\t%\u0011\u0011\"\u0001M\u00111M)3\u0001\u0003\u000e\u000e\u0003ae\u0011F\u0003\u0003B\u0011!\u0015Q\"\u0001\r\u00049\u0005\n6aA\u0007\u0003\t\u000fAA!K\u0004\u0005\u0003\"AI!D\u0001\u0019\u000bE\u001b\u0011!\u0002\u0001*\u0013\u0011\t\u0005\u0002C\u0001\u000e\u0007%\tA1\u0001M\u0002#\u000e\tQ\u0001A\u0015\u0013\t\u0005C\u00012B\u0007\r\u0013\u0011I1!C\u0001\u0005\u0004a5\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001g\u0004\u0019\u000fa1\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00115\t\u0001\u0014C)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!IQ\u0002B\u0005\u0003\u0013\u0005Az\u0001g\u0005R\u0007\u0005)\u0001!\u000b\n\u0005\u0005\"A!\"D\u0005\n\u0005%\t\u0001tB\u0005\u0005\u0013\rI\u0011\u0001b\u0001\u0019\u000eaU\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0003E\f"}, strings={"Lorg/jetbrains/debugger/LineBreakpointManager;", "", "debugProcess", "Lorg/jetbrains/debugger/DebugProcessImpl;", "(Lorg/jetbrains/debugger/DebugProcessImpl;)V", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "getBreakpointManager", "()Lorg/jetbrains/debugger/BreakpointManager;", "breakpointResolvedListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ideToVmBreakpoints", "Lgnu/trove/THashMap;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "", "Lorg/jetbrains/debugger/Breakpoint;", "lock", "Ljava/lang/Object;", "runToLocationBreakpoints", "Lgnu/trove/THashSet;", "vmToIdeBreakpoint", "Lcom/intellij/util/containers/MultiMap;", "getVmToIdeBreakpoint", "()Lcom/intellij/util/containers/MultiMap;", "beforeBreakpointRemoved", "", "breakpoint", "disable", "", "clearRunToLocationBreakpoints", "createTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "isTemporary", "doRemoveBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "doSetBreakpoint", "isAnyFirstLineBreakpoint", "isRunToCursorBreakpoints", "breakpoints", "removeAllBreakpoints", "removeBreakpoint", "temporary", "runToLocation", "setBreakpoint", "onlySourceMappedBreakpoints", "locations", "updateAllBreakpoints"}, moduleName="script-debugger-ui")
public abstract class LineBreakpointManager {
    private final THashMap<XLineBreakpoint<?>, List<Breakpoint>> ideToVmBreakpoints;
    @NotNull
    private final MultiMap<Breakpoint, XLineBreakpoint<?>> vmToIdeBreakpoint;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final AtomicBoolean breakpointResolvedListenerAdded;
    private final DebugProcessImpl<?> debugProcess;

    @NotNull
    protected final MultiMap<Breakpoint, XLineBreakpoint<?>> getVmToIdeBreakpoint() {
        return this.vmToIdeBreakpoint;
    }

    private final BreakpointManager getBreakpointManager() {
        Vm vm = this.debugProcess.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        return vm.getBreakpointManager();
    }

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean onlySourceMappedBreakpoints) {
        List list;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object object = this.lock;
        synchronized (lock) {
            list = (List)this.ideToVmBreakpoints.get(breakpoint);
        }
        List target = list;
        if (target == null) {
            this.setBreakpoint(breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint, onlySourceMappedBreakpoints));
        } else {
            BreakpointManager breakpointManager = this.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.getEnabled()) continue;
                vmBreakpoint.setEnabled(true);
                breakpointManager.flush(vmBreakpoint).rejected((Consumer)new Consumer<Throwable>(this, breakpoint){
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    /*
                     * WARNING - void declaration
                     */
                    public final void consume(Throwable it) {
                        void $receiver;
                        Throwable throwable = it;
                        Icon icon = AllIcons.Debugger.Db_invalid_breakpoint;
                        XLineBreakpoint xLineBreakpoint = this.$breakpoint;
                        XDebugSession xDebugSession = LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession();
                        String string = $receiver.getMessage();
                        xDebugSession.updateBreakpointPresentation(xLineBreakpoint, icon, string);
                    }
                    {
                        this.this$0 = lineBreakpointManager;
                        this.$breakpoint = xLineBreakpoint;
                    }
                });
            }
        }
    }

    @NotNull
    public final Promise<?> removeBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<?> doRemoveBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SetsKt.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            if (disable) {
                List list = (List)this.ideToVmBreakpoints.get(breakpoint);
                if (list == null) {
                    return PromiseKt.resolvedPromise();
                }
                List list2 = list;
                Iterator iterator = list2.iterator();
                List list3 = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"list");
                vmBreakpoints.element = list3;
                while (iterator.hasNext()) {
                    void $receiver;
                    Breakpoint vmBreakpoint = (Breakpoint)iterator.next();
                    Collection collection = this.getVmToIdeBreakpoint().get((Object)vmBreakpoint);
                    if ($receiver.size() <= 1) continue;
                    iterator.remove();
                }
            } else {
                List list = (List)this.ideToVmBreakpoints.remove(breakpoint);
                if (list == null) {
                    return PromiseKt.resolvedPromise();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ideToVmBreakpoints.remov\u2026 return resolvedPromise()");
                vmBreakpoints.element = list;
                if (!((List)((Collection)vmBreakpoints.element)).isEmpty()) {
                    for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                        this.getVmToIdeBreakpoint().remove((Object)vmBreakpoint, breakpoint);
                        if (!this.getVmToIdeBreakpoint().containsKey((Object)vmBreakpoint)) continue;
                        return PromiseKt.resolvedPromise();
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (((Collection)vmBreakpoints.element).isEmpty()) {
            return PromiseKt.resolvedPromise();
        }
        BreakpointManager breakpointManager = this.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                vmBreakpoint.setEnabled(false);
                promises.add(breakpointManager.flush(vmBreakpoint));
            }
        } else {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.remove(vmBreakpoint));
            }
        }
        Promise promise = Promise.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.all(promises)");
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<? extends Location> locations) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            vmBreakpoints.add((Object)this.doSetBreakpoint(breakpoint, location, false));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoints.put(breakpoint, (Object)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                this.getVmToIdeBreakpoint().putValue((Object)vmBreakpoint, breakpoint);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    protected final Breakpoint doSetBreakpoint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location, boolean isTemporary) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (this.breakpointResolvedListenerAdded.compareAndSet(false, true)) {
            this.getBreakpointManager().addBreakpointListener(new BreakpointListener(this){
                final /* synthetic */ LineBreakpointManager this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resolved(@NotNull Breakpoint breakpoint) {
                    Collection collection;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        collection = this.this$0.getVmToIdeBreakpoint().get((Object)breakpoint);
                    }
                    Collection breakpoints = collection;
                    for (XLineBreakpoint ideBreakpoint : breakpoints) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void errorOccurred(@NotNull Breakpoint breakpoint, @Nullable String errorMessage) {
                    Collection collection;
                    void lock;
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    if (this.this$0.isAnyFirstLineBreakpoint(breakpoint)) {
                        return;
                    }
                    Object lock2 = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock2) {
                        bl = LineBreakpointManager.access$getRunToLocationBreakpoints$p(this.this$0).remove((Object)breakpoint);
                    }
                    if (bl) {
                        XDebugSession xDebugSession = LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession();
                        StringBuilder stringBuilder = new StringBuilder().append("Cannot run to cursor: ");
                        String string = errorMessage;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        xDebugSession.reportError(stringBuilder.append(string).toString());
                        return;
                    }
                    Object $i$a$1 = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        collection = this.this$0.getVmToIdeBreakpoint().get((Object)breakpoint);
                    }
                    Collection breakpoints = collection;
                    for (XLineBreakpoint ideBreakpoint : breakpoints) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        BreakpointManager breakpointManager = this.getBreakpointManager();
        BreakpointTarget target = this.createTarget(breakpoint, breakpointManager, location, isTemporary);
        XLineBreakpoint<?> xLineBreakpoint = breakpoint;
        XExpression condition = xLineBreakpoint != null ? xLineBreakpoint.getConditionExpression() : null;
        XExpression xExpression = condition;
        return breakpointManager.setBreakpoint(target, location.getLine(), location.getColumn(), xExpression != null ? xExpression.getExpression() : null, Breakpoint.Companion.getEMPTY_VALUE(), true);
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> var1, @NotNull BreakpointManager var2, @NotNull Location var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = CollectionsKt.mutableKeys((Map)((Map)this.ideToVmBreakpoints));
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            xLineBreakpointArray = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<?> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoints.clear();
            this.getVmToIdeBreakpoint().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE;
        }
        return this.getBreakpointManager().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            Breakpoint[] breakpoints = (Breakpoint[])this.runToLocationBreakpoints.toArray((Object[])new Breakpoint[this.runToLocationBreakpoints.size()]);
            this.runToLocationBreakpoints.clear();
            breakpointArray = breakpoints;
        }
        Breakpoint[] breakpoints = breakpointArray;
        BreakpointManager breakpointManager = this.getBreakpointManager();
        for (int i = 0; i < breakpoints.length; ++i) {
            Breakpoint breakpoint;
            Breakpoint breakpoint2 = breakpoint = breakpoints[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
            breakpointManager.remove(breakpoint2);
        }
    }

    public LineBreakpointManager(@NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoints = new THashMap();
        MultiMap multiMap = MultiMap.createSmart();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSmart()");
        this.vmToIdeBreakpoint = multiMap;
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.breakpointResolvedListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(LineBreakpointManager $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ DebugProcessImpl<?> access$getDebugProcess$p(LineBreakpointManager $this) {
        return $this.debugProcess;
    }
}

