/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ParentlessVariableContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.ScopeVariablesGroupKt$WhenMappings;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"+\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t\u000f5E\u0002\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011D\u0002\u0005\u0003\u001b\u0011I!!C\u0001\u0019\u0007a\u0015\u0011d\u0001E\u0004\u001b\u0005AB!\u0007\u0003\t\n5\u0011A\u0012\u0001\r\u0006)\u000e-Q2\u0005\u0005\u0007\u001b\u0005AB!G\u0002\t\u000e5\t\u0001dA\r\u0004\u0011\u001di\u0011\u0001\u0007\u0003\u001a\t!%QB\u0001G\u00011\u0015!61BG\b\t\u0005Ay!D\u0001\u0019\u0011U\t\u0001d\u0001+\u0004\f\u0001"}, strings={"createAndAddScopeList", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "scopes", "", "Lorg/jetbrains/debugger/Scope;", "context", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "ScopeVariablesGroupKt", "createVariableContext", "scope", "parentContext", "createScopeNodeName", ""}, moduleName="script-debugger-ui")
public final class ScopeVariablesGroupKt {
    public static final void createAndAddScopeList(@NotNull XCompositeNode node, @NotNull List<? extends Scope> scopes, @NotNull VariableContext context, @Nullable CallFrame callFrame) {
        XValueChildrenList xValueChildrenList;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Collection collection = scopes;
        XValueChildrenList xValueChildrenList2 = xValueChildrenList;
        XValueChildrenList xValueChildrenList3 = xValueChildrenList;
        int n = collection.size();
        xValueChildrenList2(n);
        XValueChildrenList list = xValueChildrenList3;
        for (Scope scope : scopes) {
            list.addTopGroup((XValueGroup)new ScopeVariablesGroup(scope, context, callFrame));
        }
        node.addChildren(list, true);
    }

    @NotNull
    public static final VariableContext createVariableContext(@NotNull Scope scope, @NotNull VariableContext parentContext, @Nullable CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)parentContext, (String)"parentContext");
        if (callFrame == null || Intrinsics.areEqual((Object)((Object)scope.getType()), (Object)((Object)Scope.Type.LIBRARY))) {
            return new ParentlessVariableContext(parentContext, scope, Intrinsics.areEqual((Object)((Object)scope.getType()), (Object)((Object)Scope.Type.GLOBAL)));
        }
        return new VariableContextWrapper(parentContext, scope);
    }

    /*
     * WARNING - void declaration
     */
    private static final String createScopeNodeName(Scope $receiver) {
        void $receiver2;
        IllegalArgumentException illegalArgumentException;
        switch (ScopeVariablesGroupKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getType().ordinal()]) {
            case 1: {
                String string = XDebuggerBundle.message((String)"scope.global", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.global\")");
                return string;
            }
            case 2: {
                String string = XDebuggerBundle.message((String)"scope.local", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.local\")");
                return string;
            }
            case 3: {
                String string = XDebuggerBundle.message((String)"scope.with", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.with\")");
                return string;
            }
            case 4: {
                String string = XDebuggerBundle.message((String)"scope.closure", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.closure\")");
                return string;
            }
            case 5: {
                String string = XDebuggerBundle.message((String)"scope.catch", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.catch\")");
                return string;
            }
            case 6: {
                String string = XDebuggerBundle.message((String)"scope.library", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.library\")");
                return string;
            }
            case 7: {
                String string = XDebuggerBundle.message((String)"scope.instance", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.instance\")");
                return string;
            }
            case 8: {
                String string = XDebuggerBundle.message((String)"scope.class", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.class\")");
                return string;
            }
            case 9: {
                String string = XDebuggerBundle.message((String)"scope.block", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.block\")");
                return string;
            }
            case 10: {
                String string = XDebuggerBundle.message((String)"scope.script", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.script\")");
                return string;
            }
            case 11: {
                String string = XDebuggerBundle.message((String)"scope.unknown", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.unknown\")");
                return string;
            }
        }
        Enum enum_ = $receiver.getType();
        IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
        IllegalArgumentException illegalArgumentException3 = illegalArgumentException;
        String string = $receiver2.name();
        illegalArgumentException2(string);
        throw (Throwable)illegalArgumentException3;
    }

    @NotNull
    public static final /* synthetic */ String access$createScopeNodeName(Scope $receiver) {
        return ScopeVariablesGroupKt.createScopeNodeName($receiver);
    }
}

