/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.MessageWriter;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!\u0001\u0003\f\u0019\u0001I\u0012\u0001'\u0001\u001a\u0003a\tQ$\u0001G\rC+I1\u0001c\u0001\u000e\u0003a\u0011\u0011b\u0001E\u0003\u001b\u0005A2!U\u0002\u0002\u0011\u000f)\u0003\u0003\u0002\u0006\t\u000b5\t\u00014B\r\u0004\u0011\u0011i\u0011\u0001'\u0003\u001a\u000f!1Q\"B\u0005\u0004\u0013\ta\t\u0001G\u0004\u0019\u000e\u00152Aa\u0003E\b\u001b\rI\u0011\u0001b\u0001\u0019\u0011\u0015\"\u0001\u0012C\u0007\u0003\u0019\u0003AJ!\n\u0003\u0005\u0017!IQ\"\u0001M\nK\u001dA!\"D\u0001\u0019\fe\u0019\u0001\u0002B\u0007\u00021\u0013)\u0003\u0002\u0002\u0006\t\u00165\t\u00014C\r\u0004\u0011-i\u0011\u0001g\u0006&\u000f!UQ\"\u0001M\n3\rA1\"D\u0001\u0019\u000f%RA1\u0011\u000f\t\t5\u0011A\u0012\u0001M\u00059\u0005\u0001\u0013!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0019!D\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/rpc/MessageWriter;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;)V", "channel", "Lio/netty/channel/Channel;", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "detach", "Lorg/jetbrains/concurrency/Promise;", "getChannelIfActive", "isAttached", "", "setChannel", "write", "content", "Lio/netty/buffer/ByteBuf;", "MyChannelFutureListener", "VmEx"}, moduleName="script-debugger-backend")
public class StandaloneVmHelper
extends MessageWriter
implements AttachStateManager {
    private volatile Channel channel;
    private final Vm vm;
    private final MessageProcessor messageProcessor;

    @Override
    protected boolean write(@NotNull ByteBuf content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        ByteBuf byteBuf = content;
        if (byteBuf == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        return this.write((Object)byteBuf);
    }

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? (Channel)null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        return channel != null && !channel.writeAndFlush(content).isCancelled();
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.channel = channel;
        channel.closeFuture().addListener((GenericFutureListener)new MyChannelFutureListener());
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return PromiseKt.resolvedPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        Vm vm = this.vm;
        if (!(vm instanceof VmEx)) {
            vm = null;
        }
        VmEx vmEx = (VmEx)vm;
        Request<? extends Object> disconnectRequest = vmEx != null ? vmEx.createDisconnectRequest() : null;
        AsyncPromise promise = new AsyncPromise();
        if (disconnectRequest == null) {
            this.messageProcessor.closed();
            this.channel = null;
            this.closeChannel(currentChannel, (AsyncPromise<Object>)promise);
            return (Promise)promise;
        }
        this.messageProcessor.closed();
        this.channel = null;
        Promise<? extends Object> p = this.messageProcessor.send(disconnectRequest);
        p.processed(new Consumer<T>(this, promise, currentChannel){
            final /* synthetic */ StandaloneVmHelper this$0;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Channel $currentChannel;

            public final void consume(@Nullable Object it) {
                AsyncPromise $receiver = this.$promise;
                try {
                    StandaloneVmHelper.access$getMessageProcessor$p(this.this$0).cancelWaitingRequests();
                    this.this$0.closeChannel(this.$currentChannel, (AsyncPromise<Object>)this.$promise);
                }
                catch (Throwable e) {
                    $receiver.setError(e);
                }
            }
            {
                this.this$0 = standaloneVmHelper;
                this.$promise = asyncPromise;
                this.$currentChannel = channel;
            }
        });
        return (Promise)promise;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise);
    }

    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)messageProcessor, (String)"messageProcessor");
        this.vm = vm;
        this.messageProcessor = messageProcessor;
    }

    public static final /* synthetic */ void access$setChannel$p(StandaloneVmHelper $this, @Nullable Channel channel) {
        $this.channel = channel;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\t\u0001\u0002\u0001\u00034\u0019\u0001I\u0012\u0001'\u0001&\u0013\u0011\u0019\u0002\"A\u0007\u0007\u0013\r!\t!C\u0001\u0019\u00051\u0005\u00014\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", ""}, moduleName="script-debugger-backend")
    public static interface VmEx
    extends Vm {
        @Nullable
        public Request<? extends Object> createDisconnectRequest();

        @KotlinInterfaceDefaultImpls(version={1, 0, 0})
        @KotlinSyntheticClass(version={1, 0, 0}, abiVersion=32, moduleName="script-debugger-backend")
        public static final class DefaultImpls {
            @NotNull
            public static Promise<?> setBreakOnException(@NotNull VmEx $this, ExceptionCatchMode catchMode) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)catchMode), (String)"catchMode");
                return Vm.DefaultImpls.setBreakOnException($this, catchMode);
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005!\u0011I\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0005\u0005\u0017!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper$MyChannelFutureListener;", "Lio/netty/channel/ChannelFutureListener;", "(Lorg/jetbrains/debugger/StandaloneVmHelper;)V", "operationComplete", "", "future", "Lio/netty/channel/ChannelFuture;"}, moduleName="script-debugger-backend")
    private final class MyChannelFutureListener
    implements ChannelFutureListener {
        public void operationComplete(@NotNull ChannelFuture future2) {
            Intrinsics.checkParameterIsNotNull((Object)future2, (String)"future");
            if (StandaloneVmHelper.this.channel != null) {
                StandaloneVmHelper.this.messageProcessor.closed();
                StandaloneVmHelper.this.vm.getDebugListener().disconnected();
            }
        }
    }
}

