/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import java.util.List;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012A\u0003\u0002\t\u000ba\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u0011\t-I1\u0001c\u0001\u000e\u0003a\u0011\u0011b\u0001E\u0003\u001b\u0005A2!\u0003\u0003\t\b5\u0011A\u0012\u0001\r\u0005#\u000e\t\u0001\u0012BQ\u0015\u0013\rA\u0019!D\u0001\u0019\u0005%!\u0001\"B\u0007\u0003\u0019\u0003AZ!C\u0002\t\u00065\t\u0001dA\u0005\u0005\u0011\u000fi!\u0001$\u0001\u0019\tE\u001b\u0011\u0001\u0003\u0004&\u0011\u0011Y\u0001RC\u0007\u00021-I2\u0001c\u0006\u000e\u0003aaQ\u0005\u0003\u0003\f\u00113i\u0011\u0001G\u0006\u001a\u0007!iQ\"\u0001M\u000eK!!1\u0002\u0003\b\u000e\u000bAyQC\u0001G\u00011;Aj\"*\u0004\u0005\u0017!}Qr\u0001\r\u0011#\u000e\tA\u0011E\u0013\u0006\t-A\u0011#\u0004\u0002\r\u0002aAQe\u0002\u0003\f\u0011GiA!\u0003\u0002\n\u0003a\u0015\u0002DES\u0011\u0011Gi)\"\u0003\u0004\n\u000bAyQC\u0001G\u00011KA*\u0003\u0007\nR\u0007\u0005!\t#G\u0002\t'5\t\u0001tE\u0013\u0006\t-AA#\u0004\u0002\r\u0002a%R%\u0002\u0003\f\u0011Ui!\u0001$\u0001\u0019*\u0015*Aa\u0003E\u0016\u001b\ta\t\u0001'\u000b&\u000b\u0011Y\u0001BF\u0007\u0003\u0019\u0003AZ!\n\u0003\u0005\u0017!5R\"\u0001\r\u0004K\u0011!1\u0002C\f\u000e\u0003aI\u0011F\u0003\u0003D\u0011!\rQ\"\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u001bAq!\u000b\u0005\u0005\u0003rAy!\u0004\u0002\r\u0002aA\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00125\t\u0001$C)\u0004\u0003\u0015\u0001\u0011f\u0003\u0003D\u0011!\u001dQB\u0001G\u00011\u0011\t6\u0001B\u0003\u0001\u001b\t!\u0019\u0002\u0003\u0006*\u0011\u0011\t\u0005\u0002C\u0003\u000e\u00051\u0005\u00014B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/frame/CallFrameView;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "script", "Lorg/jetbrains/debugger/Script;", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;)V", "sourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/SourceInfo;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;)V", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "inLibraryContent", "", "getScript", "()Lorg/jetbrains/debugger/Script;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEqualityObject", "", "kotlin.jvm.PlatformType", "getEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "Lorg/jetbrains/annotations/NotNull;", "getEvaluator", "getMemberFilter", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "scope", "Lorg/jetbrains/debugger/Scope;", "getName", "", "getParent", "getScope", "getSourcePosition", "getViewSupport", "watchableAsEvaluationExpression"}, moduleName="script-debugger-ui")
public final class CallFrameView
extends XStackFrame
implements VariableContext {
    private final boolean inLibraryContent;
    private XDebuggerEvaluator evaluator;
    @NotNull
    private final CallFrame callFrame;
    private final SourceInfo sourceInfo;
    private final DebuggerViewSupport viewSupport;
    @Nullable
    private final Script script;

    public Object getEqualityObject() {
        return this.callFrame.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        List<Scope> list = this.callFrame.getVariableScopes();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"callFrame.variableScopes");
        ScopeVariablesGroupKt.createAndAddScopeList(node, list, this, this.callFrame);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.callFrame.getEvaluateContext();
    }

    @Nullable
    public Void getName() {
        return null;
    }

    @Nullable
    public Void getParent() {
        return null;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.viewSupport;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.viewSupport.getMemberFilter(this);
    }

    @NotNull
    public final Promise<MemberFilter> getMemberFilter(@NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        return ScopeVariablesGroupKt.createVariableContext(scope, this, this.callFrame).getMemberFilter();
    }

    @Nullable
    public Void getScope() {
        return null;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.viewSupport.createFrameEvaluator(this);
        }
        return this.evaluator;
    }

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (this.sourceInfo == null) {
            String scriptName = this.script == null ? "unknown" : this.script.getUrl().trimParameters().toDecodedForm();
            int line = this.callFrame.getLine();
            component.append(line != -1 ? scriptName + ':' + line : scriptName, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        String fileName = this.sourceInfo.getFile().getName();
        int line = this.sourceInfo.getLine() + 1;
        SimpleTextAttributes textAttributes = this.inLibraryContent ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || StringsKt.isEmpty((String)functionName) && this.callFrame.hasOnlyGlobalScope()) {
            component.append(fileName + ":" + line, textAttributes);
        } else {
            if (StringsKt.isEmpty((String)functionName)) {
                component.append("anonymous", this.inLibraryContent ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    @NotNull
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    @Nullable
    public final Script getScript() {
        return this.script;
    }

    public CallFrameView(@NotNull CallFrame callFrame, @Nullable SourceInfo sourceInfo, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        this.callFrame = callFrame;
        this.sourceInfo = sourceInfo;
        this.viewSupport = viewSupport;
        this.script = script;
        this.inLibraryContent = this.sourceInfo != null && this.viewSupport.isInLibraryContent(this.sourceInfo, this.script);
    }

    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        this(callFrame, viewSupport.getSourceInfo(script, callFrame), viewSupport, script);
    }
}

