/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.InnerKotlinClassLightClassData;
import org.jetbrains.kotlin.asJava.KotlinFacadeLightClassData;
import org.jetbrains.kotlin.asJava.KotlinLightClassBuilderFactory;
import org.jetbrains.kotlin.asJava.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.OutermostKotlinClassLightClassData;
import org.jetbrains.kotlin.asJava.WithFileStubAndExtraDiagnostics;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinJavaFileStubProvider<T extends WithFileStubAndExtraDiagnostics>
implements CachedValueProvider<T> {
    private static final Logger LOG = Logger.getInstance(KotlinJavaFileStubProvider.class);
    private final Project project;
    private final StubGenerationStrategy<T> stubGenerationStrategy;
    private final boolean local;

    @NotNull
    public static CachedValueProvider<KotlinFacadeLightClassData> createForFacadeClass(final @NotNull Project project, final @NotNull FqName facadeFqName, final @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForFacadeClass"));
        }
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForFacadeClass"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForFacadeClass"));
        }
        KotlinJavaFileStubProvider<KotlinFacadeLightClassData> kotlinJavaFileStubProvider = new KotlinJavaFileStubProvider<KotlinFacadeLightClassData>(project, false, new StubGenerationStrategy<KotlinFacadeLightClassData>(){

            @Override
            @NotNull
            public Collection<KtFile> getFiles() {
                Collection<KtFile> collection = LightClassGenerationSupport.getInstance(project).findFilesForFacade(facadeFqName, searchScope);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "getFiles"));
                }
                return collection;
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                FqName fqName2 = facadeFqName.parent();
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "getPackageFqName"));
                }
                return fqName2;
            }

            @Override
            @NotNull
            public LightClassConstructionContext getContext(@NotNull Collection<KtFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "getContext"));
                }
                LightClassConstructionContext lightClassConstructionContext = LightClassGenerationSupport.getInstance(project).getContextForFacade(files);
                if (lightClassConstructionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "getContext"));
                }
                return lightClassConstructionContext;
            }

            @Override
            @NotNull
            public KotlinFacadeLightClassData createLightClassData(PsiJavaFileStub javaFileStub, BindingContext bindingContext2, Diagnostics extraDiagnostics) {
                KotlinFacadeLightClassData kotlinFacadeLightClassData = new KotlinFacadeLightClassData(javaFileStub, extraDiagnostics);
                if (kotlinFacadeLightClassData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "createLightClassData"));
                }
                return kotlinFacadeLightClassData;
            }

            @Override
            public GenerationState.GenerateClassFilter getGenerateClassFilter() {
                return new GenerationState.GenerateClassFilter(){

                    @Override
                    public boolean shouldAnnotateClass(KtClassOrObject classOrObject) {
                        return this.shouldGenerateClass(classOrObject);
                    }

                    @Override
                    public boolean shouldGenerateClass(KtClassOrObject classOrObject) {
                        return KtPsiUtil.isLocal(classOrObject);
                    }

                    @Override
                    public boolean shouldGeneratePackagePart(KtFile jetFile) {
                        return true;
                    }

                    @Override
                    public boolean shouldGenerateScript(KtScript script) {
                        return false;
                    }
                };
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<KtFile> files) {
                KtFile representativeFile;
                JvmFileClassInfo fileClassInfo;
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "generate"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$1", "generate"));
                }
                if (!files.isEmpty() && !(fileClassInfo = NoResolveFileClassesProvider.INSTANCE.getFileClassInfo(representativeFile = files.iterator().next())).getWithJvmMultifileClass()) {
                    PackageCodegen codegen = state.getFactory().forPackage(representativeFile.getPackageFqName(), files);
                    codegen.generate(CompilationErrorHandler.THROW_EXCEPTION);
                    state.getFactory().asList();
                    return;
                }
                MultifileClassCodegen codegen = state.getFactory().forMultifileClass(facadeFqName, files);
                codegen.generate(CompilationErrorHandler.THROW_EXCEPTION);
                state.getFactory().asList();
            }

            public String toString() {
                return StubGenerationStrategy.class.getName() + " for facade class";
            }
        });
        if (kotlinJavaFileStubProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForFacadeClass"));
        }
        return kotlinJavaFileStubProvider;
    }

    @NotNull
    public static KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData> createForDeclaredClass(final @NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForDeclaredClass"));
        }
        KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData> kotlinJavaFileStubProvider = new KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData>(classOrObject.getProject(), classOrObject.isLocal(), new StubGenerationStrategy<OutermostKotlinClassLightClassData>(){

            private KtFile getFile() {
                return classOrObject.getContainingJetFile();
            }

            @Override
            @NotNull
            public LightClassConstructionContext getContext(@NotNull Collection<KtFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "getContext"));
                }
                LightClassConstructionContext lightClassConstructionContext = LightClassGenerationSupport.getInstance(classOrObject.getProject()).getContextForClassOrObject(classOrObject);
                if (lightClassConstructionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "getContext"));
                }
                return lightClassConstructionContext;
            }

            @Override
            @NotNull
            public OutermostKotlinClassLightClassData createLightClassData(PsiJavaFileStub javaFileStub, BindingContext bindingContext2, Diagnostics extraDiagnostics) {
                ClassDescriptor classDescriptor = bindingContext2.get(BindingContext.CLASS, classOrObject);
                if (classDescriptor == null) {
                    OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = new OutermostKotlinClassLightClassData(javaFileStub, extraDiagnostics, FqName.ROOT, classOrObject, Collections.emptyMap());
                    if (outermostKotlinClassLightClassData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "createLightClassData"));
                    }
                    return outermostKotlinClassLightClassData;
                }
                FqName fqName2 = this.predictClassFqName(bindingContext2, classDescriptor);
                Collection<ClassDescriptor> allInnerClasses = CodegenBinding.getAllInnerClasses(bindingContext2, classDescriptor);
                HashMap<KtClassOrObject, InnerKotlinClassLightClassData> innerClassesMap = ContainerUtil.newHashMap();
                for (ClassDescriptor innerClassDescriptor : allInnerClasses) {
                    PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(innerClassDescriptor);
                    if (!(declaration instanceof KtClassOrObject)) continue;
                    KtClassOrObject innerClass = (KtClassOrObject)declaration;
                    InnerKotlinClassLightClassData innerLightClassData = new InnerKotlinClassLightClassData(this.predictClassFqName(bindingContext2, innerClassDescriptor), innerClass);
                    innerClassesMap.put(innerClass, innerLightClassData);
                }
                OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = new OutermostKotlinClassLightClassData(javaFileStub, extraDiagnostics, fqName2, classOrObject, innerClassesMap);
                if (outermostKotlinClassLightClassData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "createLightClassData"));
                }
                return outermostKotlinClassLightClassData;
            }

            @NotNull
            private FqName predictClassFqName(BindingContext bindingContext2, ClassDescriptor classDescriptor) {
                Type asmType = CodegenBinding.getAsmType(bindingContext2, classDescriptor);
                FqName fqName2 = JvmClassName.byInternalName(asmType.getClassName().replace('.', '/')).getFqNameForClassNameWithoutDollars();
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "predictClassFqName"));
                }
                return fqName2;
            }

            @Override
            @NotNull
            public Collection<KtFile> getFiles() {
                List<KtFile> list = Collections.singletonList(this.getFile());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "getFiles"));
                }
                return list;
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                FqName fqName2 = this.getFile().getPackageFqName();
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "getPackageFqName"));
                }
                return fqName2;
            }

            @Override
            public GenerationState.GenerateClassFilter getGenerateClassFilter() {
                return new GenerationState.GenerateClassFilter(){

                    @Override
                    public boolean shouldGeneratePackagePart(KtFile jetFile) {
                        return true;
                    }

                    @Override
                    public boolean shouldAnnotateClass(KtClassOrObject classOrObject) {
                        return this.shouldGenerateClass(classOrObject);
                    }

                    @Override
                    public boolean shouldGenerateClass(KtClassOrObject generatedClassOrObject) {
                        if (generatedClassOrObject == classOrObject) {
                            return true;
                        }
                        if (PsiTreeUtil.isAncestor(generatedClassOrObject, classOrObject, true) || PsiTreeUtil.isAncestor(classOrObject, generatedClassOrObject, true)) {
                            return true;
                        }
                        if (generatedClassOrObject.isLocal() && classOrObject.isLocal()) {
                            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)generatedClassOrObject, (PsiElement)classOrObject);
                            return commonParent != null && !(commonParent instanceof PsiFile);
                        }
                        return false;
                    }

                    @Override
                    public boolean shouldGenerateScript(KtScript script) {
                        return PsiTreeUtil.isAncestor(script, classOrObject, false);
                    }
                };
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<KtFile> files) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "generate"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$2", "generate"));
                }
                PackageCodegen packageCodegen = state.getFactory().forPackage(this.getPackageFqName(), files);
                KtFile file = classOrObject.getContainingJetFile();
                Type packagePartType = FileClasses.getFileClassType(state.getFileClassesProvider(), file);
                PackageContext context = state.getRootContext().intoPackagePart(packageCodegen.getPackageFragment(), packagePartType, file);
                packageCodegen.generateClassOrObject(classOrObject, context);
                state.getFactory().asList();
            }

            public String toString() {
                return StubGenerationStrategy.class.getName() + " for explicit class " + classOrObject.getName();
            }
        });
        if (kotlinJavaFileStubProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createForDeclaredClass"));
        }
        return kotlinJavaFileStubProvider;
    }

    private KotlinJavaFileStubProvider(@NotNull Project project, boolean local, @NotNull StubGenerationStrategy<T> stubGenerationStrategy) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "<init>"));
        }
        if (stubGenerationStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubGenerationStrategy", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "<init>"));
        }
        this.project = project;
        this.stubGenerationStrategy = stubGenerationStrategy;
        this.local = local;
    }

    @Override
    @Nullable
    public CachedValueProvider.Result<T> compute() {
        BindingContext bindingContext2;
        FqName packageFqName = this.stubGenerationStrategy.getPackageFqName();
        Collection<KtFile> files = this.stubGenerationStrategy.getFiles();
        KotlinJavaFileStubProvider.checkForBuiltIns(packageFqName, files);
        LightClassConstructionContext context = this.stubGenerationStrategy.getContext(files);
        PsiJavaFileStub javaFileStub = this.createJavaFileStub(packageFqName, files);
        BindingTraceContext forExtraDiagnostics = new BindingTraceContext();
        try {
            Stack<StubElement> stubStack = new Stack<StubElement>();
            stubStack.push(javaFileStub);
            GenerationState state = new GenerationState(this.project, new KotlinLightClassBuilderFactory(stubStack), context.getModule(), context.getBindingContext(), Lists.newArrayList(files), false, false, this.stubGenerationStrategy.getGenerateClassFilter(), false, false, false, forExtraDiagnostics);
            KotlinCodegenFacade.prepareForCompilation(state);
            bindingContext2 = state.getBindingContext();
            this.stubGenerationStrategy.generate(state, files);
            StubElement pop2 = stubStack.pop();
            if (pop2 != javaFileStub) {
                LOG.error("Unbalanced stack operations: " + pop2);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            KotlinJavaFileStubProvider.logErrorWithOSInfo(e, packageFqName, null);
            throw e;
        }
        Diagnostics extraDiagnostics = forExtraDiagnostics.getBindingContext().getDiagnostics();
        return CachedValueProvider.Result.create(this.stubGenerationStrategy.createLightClassData(javaFileStub, bindingContext2, extraDiagnostics), this.local ? PsiModificationTracker.MODIFICATION_COUNT : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
    }

    @NotNull
    private static ClsFileImpl createFakeClsFile(@NotNull Project project, final @NotNull FqName packageFqName, @NotNull Collection<KtFile> files, final @NotNull Function0<? extends PsiClassHolderFileStub> fileStubProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createFakeClsFile"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createFakeClsFile"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createFakeClsFile"));
        }
        if (fileStubProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStubProvider", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createFakeClsFile"));
        }
        PsiManager manager = PsiManager.getInstance(project);
        VirtualFile virtualFile = KotlinJavaFileStubProvider.getRepresentativeVirtualFile(files);
        ClsFileImpl fakeFile = new ClsFileImpl(new ClassFileViewProvider(manager, virtualFile)){

            @Override
            @NotNull
            public PsiClassHolderFileStub getStub() {
                PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)fileStubProvider.invoke();
                if (psiClassHolderFileStub == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$3", "getStub"));
                }
                return psiClassHolderFileStub;
            }

            @Override
            @NotNull
            public String getPackageName() {
                String string = packageFqName.asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider$3", "getPackageName"));
                }
                return string;
            }
        };
        fakeFile.setPhysical(false);
        ClsFileImpl clsFileImpl = fakeFile;
        if (clsFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createFakeClsFile"));
        }
        return clsFileImpl;
    }

    @NotNull
    private PsiJavaFileStub createJavaFileStub(@NotNull FqName packageFqName, @NotNull Collection<KtFile> files) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        final PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(new ClsWrapperStubPsiFactory());
        ClsFileImpl fakeFile = KotlinJavaFileStubProvider.createFakeClsFile(this.project, packageFqName, files, (Function0<? extends PsiClassHolderFileStub>)new Function0<PsiClassHolderFileStub>(){

            @Override
            public PsiClassHolderFileStub invoke() {
                return javaFileStub;
            }
        });
        javaFileStub.setPsi(fakeFile);
        PsiJavaFileStubImpl psiJavaFileStubImpl = javaFileStub;
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        return psiJavaFileStubImpl;
    }

    @NotNull
    private static VirtualFile getRepresentativeVirtualFile(@NotNull Collection<KtFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "getRepresentativeVirtualFile"));
        }
        KtFile firstFile = files.iterator().next();
        VirtualFile virtualFile = firstFile.getVirtualFile();
        assert (virtualFile != null) : "No virtual file for " + firstFile;
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "getRepresentativeVirtualFile"));
        }
        return virtualFile2;
    }

    private static void checkForBuiltIns(@NotNull FqName fqName2, @NotNull Collection<KtFile> files) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "checkForBuiltIns"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "checkForBuiltIns"));
        }
        for (KtFile file : files) {
            if (!LightClassUtil.INSTANCE$.belongsToKotlinBuiltIns(file)) continue;
            KotlinJavaFileStubProvider.logErrorWithOSInfo(null, fqName2, file.getVirtualFile());
        }
    }

    private static void logErrorWithOSInfo(@Nullable Throwable cause, @NotNull FqName fqName2, @Nullable VirtualFile virtualFile) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/asJava/KotlinJavaFileStubProvider", "logErrorWithOSInfo"));
        }
        String path = virtualFile == null ? "<null>" : virtualFile.getPath();
        LOG.error("Could not generate LightClass for " + fqName2 + " declared in " + path + "\n" + "built-ins dir URL is " + LightClassUtil.INSTANCE$.getBuiltInsDirUrl() + "\n" + "System: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION, cause);
    }

    private static interface StubGenerationStrategy<T extends WithFileStubAndExtraDiagnostics> {
        @NotNull
        public Collection<KtFile> getFiles();

        @NotNull
        public FqName getPackageFqName();

        @NotNull
        public LightClassConstructionContext getContext(@NotNull Collection<KtFile> var1);

        @NotNull
        public T createLightClassData(PsiJavaFileStub var1, BindingContext var2, Diagnostics var3);

        public GenerationState.GenerateClassFilter getGenerateClassFilter();

        public void generate(@NotNull GenerationState var1, @NotNull Collection<KtFile> var2);
    }
}

