/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!\u0001\u0001\u0004\u0001\u001a\u0003a\u0005Q\u0014a\u0003\"\u0006E\u001b\u0011\u0001C\u0001&!\u0011Y\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$\u0002"}, strings={"Lorg/intellij/markdown/html/ListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "SilentParagraphGeneratingProvider"}, moduleName="intellij-markdown")
public final class ListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)(node instanceof ListItemCompositeNode));
        this.openTag(visitor, text, node);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        for (ASTNode child : ((ListItemCompositeNode)node).getChildren()) {
            if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.Companion.getPARAGRAPH()) && !isLoose) {
                SilentParagraphGeneratingProvider.INSTANCE.processNode(visitor, text, child);
                continue;
            }
            child.accept(visitor);
        }
        this.closeTag(visitor, text, node);
    }

    public ListItemGeneratingProvider() {
        super("li");
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&!\u0011Y\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\u0013\u0011\t-AY!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR\u0001"}, strings={"Lorg/intellij/markdown/html/ListItemGeneratingProvider$SilentParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "()V", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag"}, moduleName="intellij-markdown")
    public static final class SilentParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        public static final SilentParagraphGeneratingProvider INSTANCE;
        public static final SilentParagraphGeneratingProvider INSTANCE$;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        }

        static {
            new SilentParagraphGeneratingProvider();
        }

        private SilentParagraphGeneratingProvider() {
            INSTANCE = this;
            INSTANCE$ = this;
        }
    }
}

