/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrReferenceResolveRunner {
    private final GrReferenceExpression place;
    private ResolverProcessor processor;

    public GrReferenceResolveRunner(@NotNull GrReferenceExpression _place) {
        if (_place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "<init>"));
        }
        this.place = _place;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveImpl(@NotNull ResolverProcessor _processor) {
        if (_processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "resolveImpl"));
        }
        this.processor = _processor;
        try {
            boolean result = this.doResolve();
            ProgressManager.checkCanceled();
            boolean bl = result;
            return bl;
        }
        finally {
            this.processor = null;
        }
    }

    private boolean doResolve() {
        GrExpression qualifier = (GrExpression)this.place.getQualifier();
        if (qualifier == null) {
            GrExpression runtimeQualifier;
            if (!ResolveUtil.treeWalkUp(this.place, this.processor, true)) {
                return false;
            }
            if (!this.processor.hasCandidates() && (runtimeQualifier = PsiImplUtil.getRuntimeQualifier(this.place)) != null && !this.processQualifier(runtimeQualifier)) {
                return false;
            }
        } else if (this.place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            ResolveState state;
            PsiType qtype = qualifier.getType();
            PsiType componentType = ClosureParameterEnhancer.findTypeForIteration(qtype, (PsiElement)this.place);
            if (componentType != null && !this.processQualifierType(componentType, state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier).put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qtype, null)))) {
                return false;
            }
        } else {
            if (ResolveUtil.isClassReference(this.place)) {
                return true;
            }
            if (!this.processQualifier(qualifier)) {
                return false;
            }
            if (!this.processJavaLangClass(qualifier)) {
                return false;
            }
        }
        return true;
    }

    private boolean processJavaLangClass(@NotNull GrExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processJavaLangClass"));
        }
        if (!(qualifier instanceof GrReferenceExpression)) {
            return true;
        }
        if (!"class".equals(((GrReferenceExpression)qualifier).getReferenceName()) && !PsiUtil.isThisReference(qualifier)) {
            return true;
        }
        PsiType type = qualifier.getType();
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return true;
        }
        PsiType[] params = ((PsiClassType)type).getParameters();
        if (params.length != 1) {
            return true;
        }
        return this.processQualifierType(params[0], ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier));
    }

    private boolean processQualifier(@NotNull GrExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifier"));
        }
        PsiType qualifierType = qualifier.getType();
        ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
        if (qualifierType == null || qualifierType == PsiType.VOID) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiClassType objectQualifier;
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved != null && !resolved.processDeclarations((PsiScopeProcessor)this.processor, state, null, (PsiElement)this.place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage) && !this.processQualifierType((PsiType)(objectQualifier = TypesUtil.getJavaLangObject(this.place)), state)) {
                    return false;
                }
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                if (this.processQualifierType(conjunct, state)) continue;
                return false;
            }
        } else {
            PsiElement resolved;
            if (!this.processQualifierType(qualifierType, state)) {
                return false;
            }
            if (qualifier instanceof GrReferenceExpression && !PsiUtil.isSuperReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && !this.processJavaLangClass(qualifierType, state)) {
                return false;
            }
        }
        return true;
    }

    private boolean processJavaLangClass(@NotNull PsiType qualifierType, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processJavaLangClass"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processJavaLangClass"));
        }
        PsiClass javaLangClass = PsiUtil.getJavaLangClass(this.place, this.place.getResolveScope());
        if (javaLangClass == null) {
            return true;
        }
        PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], qualifierType);
            state = state.put(PsiSubstitutor.KEY, (Object)substitutor);
        }
        if (!javaLangClass.processDeclarations((PsiScopeProcessor)this.processor, state, null, (PsiElement)this.place)) {
            return false;
        }
        PsiClassType javaLangClassType = JavaPsiFacade.getElementFactory((Project)this.place.getProject()).createType(javaLangClass, substitutor);
        return ResolveUtil.processNonCodeMembers((PsiType)javaLangClassType, this.processor, this.place, state);
    }

    private boolean processQualifierType(@NotNull PsiType originalQualifierType, @NotNull ResolveState state) {
        PsiType componentType;
        GroovyPsiManager gmanager;
        GrTypeDefinition arrayClass;
        PsiClassType.ClassResolveResult qualifierResult;
        PsiClass qualifierClass;
        PsiType qualifierType;
        if (originalQualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalQualifierType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifierType"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processQualifierType"));
        }
        PsiType psiType = qualifierType = originalQualifierType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)originalQualifierType).getLeastUpperBound() : originalQualifierType;
        if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                if (this.processQualifierType(conjunct, state)) continue;
                return false;
            }
            return true;
        }
        if (qualifierType instanceof GrTraitType) {
            return this.processTraitType((GrTraitType)qualifierType, state);
        }
        if (qualifierType instanceof PsiClassType ? (qualifierClass = (qualifierResult = ((PsiClassType)qualifierType).resolveGenerics()).getElement()) != null && !qualifierClass.processDeclarations((PsiScopeProcessor)this.processor, state.put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor()), null, (PsiElement)this.place) : qualifierType instanceof PsiArrayType && (arrayClass = (gmanager = GroovyPsiManager.getInstance(this.place.getProject())).getArrayClass(((PsiArrayType)qualifierType).getComponentType())) != null && !arrayClass.processDeclarations(this.processor, state, null, this.place)) {
            return false;
        }
        if (!(this.place.getParent() instanceof GrMethodCall) && InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection") && (componentType = ClosureParameterEnhancer.findTypeForIteration(qualifierType, (PsiElement)this.place)) != null) {
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            this.processQualifierType(componentType, state.put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qualifierType, spreadState)));
        }
        if (!ResolveUtil.processCategoryMembers(this.place, this.processor, state)) {
            return false;
        }
        return ResolveUtil.processNonCodeMembers(qualifierType, this.processor, this.place, state);
    }

    private boolean processTraitType(@NotNull GrTraitType traitType, @NotNull ResolveState state) {
        if (traitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processTraitType"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceResolveRunner", "processTraitType"));
        }
        GrTypeDefinition mockDefinition = traitType.getMockTypeDefinition();
        if (mockDefinition != null) {
            if (!mockDefinition.processDeclarations(this.processor, state, null, this.place)) {
                return false;
            }
        } else {
            PsiClassType exprType = traitType.getExprType();
            if (!this.processQualifierType((PsiType)exprType, state)) {
                return false;
            }
            List<PsiClassType> traitTypes = traitType.getTraitTypes();
            ListIterator<PsiClassType> iterator = traitTypes.listIterator();
            while (iterator.hasPrevious()) {
                PsiClassType type = iterator.previous();
                if (this.processQualifierType((PsiType)type, state)) continue;
                return false;
            }
        }
        return true;
    }
}

