/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.synthetic.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.synthetic.AndroidConst;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.android.synthetic.res.SyntheticFileGenerator;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.StringValue;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&)\u0011Y\u00012A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0007\u0011\u000fiA!\u0003\u0002\n\u0003\u0011\u0016\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/android/synthetic/diagnostic/AndroidExtensionPropertiesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-android-compiler-plugin")
public final class AndroidExtensionPropertiesCallChecker
implements CallChecker {
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Map $receiver;
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtExpression ktExpression = context.call.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof PropertyDescriptor)) {
            callableDescriptor = null;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        DeclarationDescriptor declarationDescriptor = propertyDescriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        if (packageFragmentDescriptor == null) {
            return;
        }
        PackageFragmentDescriptor syntheticPackage = packageFragmentDescriptor;
        if (!StringsKt.startsWith$default((String)syntheticPackage.getFqName().asString(), (String)(AndroidConst.INSTANCE.getSYNTHETIC_PACKAGE() + "."), (boolean)false, (int)2)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = propertyDescriptor2.getAnnotations().findAnnotation(SyntheticFileGenerator.Companion.getINVALID_WIDGET_TYPE_ANNOTATION_FQNAME());
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor invalidWidgetTypeAnnotation = annotationDescriptor;
        Map map = invalidWidgetTypeAnnotation.getAllValueArguments();
        LinkedHashMap result = new LinkedHashMap();
        Iterator iterator = MapsKt.iterator((Map)$receiver);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)entry.getKey();
            if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)SyntheticFileGenerator.Companion.getINVALID_WIDGET_TYPE_ANNOTATION_TYPE_PARAMETER())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        $receiver = result;
        Object object = CollectionsKt.firstOrNull((Iterable)$receiver.values());
        if (!(object instanceof StringValue)) {
            object = null;
        }
        StringValue stringValue = (StringValue)object;
        if (stringValue == null) {
            return;
        }
        StringValue type = stringValue;
        String erroneousType = (String)type.getValue();
        DiagnosticFactory1<KtExpression, String> warning = StringsKt.contains$default((String)erroneousType, (char)'.', (boolean)false, (int)2) ? ErrorsAndroid.SYNTHETIC_UNRESOLVED_WIDGET_TYPE : ErrorsAndroid.SYNTHETIC_INVALID_WIDGET_TYPE;
        context.trace.report((Diagnostic)warning.on((PsiElement)expression, (Object)erroneousType));
    }
}

