/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeTag;
import kotlin.reflect.jvm.internal.impl.renderer.CustomFlexibleRendering;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.CustomSubstitutionCapability;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RawTypeCapabilities
implements TypeCapabilities {
    public static final RawTypeCapabilities INSTANCE;
    public static final RawTypeCapabilities INSTANCE$;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, CustomSubstitutionCapability.class)) {
            RawSubstitutionCapability rawSubstitutionCapability = RawSubstitutionCapability.INSTANCE;
            if (rawSubstitutionCapability == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawSubstitutionCapability;
        } else if (Intrinsics.areEqual(clazz, CustomFlexibleRendering.class)) {
            RawFlexibleRendering rawFlexibleRendering = RawFlexibleRendering.INSTANCE;
            if (rawFlexibleRendering == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawFlexibleRendering;
        } else if (Intrinsics.areEqual(clazz, RawTypeTag.class)) {
            RawTypeTag rawTypeTag = RawTypeTag.INSTANCE;
            if (rawTypeTag == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = rawTypeTag;
        } else {
            typeCapability = null;
        }
        return (T)typeCapability;
    }

    static {
        new RawTypeCapabilities();
    }

    private RawTypeCapabilities() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    private static final class RawSubstitutionCapability
    implements CustomSubstitutionCapability {
        @NotNull
        public static final RawSubstitution substitution;
        public static final RawSubstitutionCapability INSTANCE;
        public static final RawSubstitutionCapability INSTANCE$;

        @Override
        @NotNull
        public RawSubstitution getSubstitution() {
            return substitution;
        }

        static {
            new RawSubstitutionCapability();
        }

        private RawSubstitutionCapability() {
            INSTANCE = this;
            INSTANCE$ = this;
            substitution = RawSubstitution.INSTANCE;
        }
    }

    private static final class RawFlexibleRendering
    implements CustomFlexibleRendering {
        public static final RawFlexibleRendering INSTANCE;
        public static final RawFlexibleRendering INSTANCE$;

        /*
         * WARNING - void declaration
         */
        private final List<String> renderArguments(DescriptorRenderer $receiver, KotlinType jetType) {
            void destination;
            void $receiver2;
            Iterable $receiver3 = jetType.getArguments();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            for (Object item : $receiver2) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item;
                void var9_9 = destination;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull(v0, "it");
                String string = $receiver.renderTypeProjection((TypeProjection)v0);
                var9_9.add(string);
            }
            return (List)destination;
        }

        private final String replaceArgs(String $receiver, String newArgs) {
            if (!StringsKt.contains$default($receiver, '<', false, 2)) {
                return $receiver;
            }
            return StringsKt.substringBefore$default($receiver, '<', null, 2) + "<" + newArgs + ">" + StringsKt.substringAfterLast$default($receiver, '>', null, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public String renderInflexible(@NotNull KotlinType type2, @NotNull DescriptorRenderer renderer) {
            void var3_3;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(renderer, "renderer");
            if (CollectionsKt.isNotEmpty((Collection)type2.getArguments())) {
                return null;
            }
            StringBuilder $receiver = new StringBuilder();
            StringBuilder $receiver2 = $receiver;
            TypeConstructor typeConstructor2 = type2.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.constructor");
            $receiver2.append(renderer.renderTypeConstructor(typeConstructor2));
            $receiver2.append("(raw)");
            if (type2.isMarkedNullable()) {
                $receiver2.append('?');
            }
            return ((StringBuilder)var3_3).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Pair<String, String> renderBounds(@NotNull Flexibility flexibility, @NotNull DescriptorRenderer renderer) {
            boolean bl;
            String newArgs;
            String upperRendered;
            String lowerRendered;
            block3: {
                void destination;
                Iterable $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
                Intrinsics.checkParameterIsNotNull(renderer, "renderer");
                List<String> lowerArgs = this.renderArguments(renderer, flexibility.getLowerBound());
                List<String> upperArgs = this.renderArguments(renderer, flexibility.getUpperBound());
                lowerRendered = renderer.renderType(flexibility.getLowerBound());
                upperRendered = renderer.renderType(flexibility.getUpperBound());
                if (!CollectionsKt.isNotEmpty((Collection)upperArgs)) {
                    return null;
                }
                Iterable iterable = lowerArgs;
                void var8_8 = $receiver2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it;
                    String string = (String)item;
                    void var13_13 = destination;
                    String string2 = "(raw) " + (String)it;
                    var13_13.add(string2);
                }
                newArgs = StringsKt.join$default((List)destination, ", ", null, null, 0, null, 30);
                $receiver = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
                for (Object element : $receiver) {
                    Pair it = (Pair)element;
                    if (RawFlexibleRendering.INSTANCE.onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            String newUpper = bl ? this.replaceArgs(upperRendered, newArgs) : upperRendered;
            return new Pair<String, String>(this.replaceArgs(lowerRendered, newArgs), newUpper);
        }

        private final boolean onlyOutDiffers(String first, String second) {
            return Intrinsics.areEqual(first, StringsKt.removePrefix(second, "out ")) || Intrinsics.areEqual(second, "*");
        }

        static {
            new RawFlexibleRendering();
        }

        private RawFlexibleRendering() {
            INSTANCE = this;
            INSTANCE$ = this;
        }
    }
}

