/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqNameUnsafe
extends FqNameBase {
    public static final Name ROOT_NAME = Name.special("<root>");
    @NotNull
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(@NotNull String fqName2, @NotNull FqName safe) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "<init>"));
        }
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
        this.safe = safe;
    }

    public FqNameUnsafe(@NotNull String fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
    }

    private FqNameUnsafe(@NotNull String fqName2, FqNameUnsafe parent, Name shortName) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "<init>"));
        }
        this.fqName = fqName2;
        this.parent = parent;
        this.shortName = shortName;
    }

    public static boolean isValid(@Nullable String qualifiedName) {
        return qualifiedName != null && qualifiedName.indexOf(47) < 0 && qualifiedName.indexOf(42) < 0;
    }

    private void compute() {
        int lastDot = this.fqName.lastIndexOf(46);
        if (lastDot >= 0) {
            this.shortName = Name.guess(this.fqName.substring(lastDot + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, lastDot));
        } else {
            this.shortName = Name.guess(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    @Override
    @NotNull
    public String asString() {
        String string = this.fqName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "asString"));
        }
        return string;
    }

    public boolean isSafe() {
        if (this.safe != null) {
            return true;
        }
        return FqName.isValidAfterUnsafeCheck(this.asString());
    }

    @NotNull
    public FqName toSafe() {
        if (this.safe != null) {
            FqName fqName2 = this.safe;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "toSafe"));
            }
            return fqName2;
        }
        FqName fqName3 = this.safe = new FqName(this);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "toSafe"));
        }
        return fqName3;
    }

    public boolean isRoot() {
        return this.fqName.isEmpty();
    }

    @NotNull
    public FqNameUnsafe parent() {
        if (this.parent != null) {
            FqNameUnsafe fqNameUnsafe = this.parent;
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "parent"));
            }
            return fqNameUnsafe;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "parent"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public FqNameUnsafe child(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "child"));
        }
        String childFqName = this.isRoot() ? name.asString() : this.fqName + "." + name.asString();
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(childFqName, this, name);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "child"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public Name shortName() {
        if (this.shortName != null) {
            Name name = this.shortName;
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "shortName"));
            }
            return name;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        Name name = this.shortName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "shortName"));
        }
        return name;
    }

    @Override
    @NotNull
    public Name shortNameOrSpecial() {
        if (this.isRoot()) {
            Name name = ROOT_NAME;
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "shortNameOrSpecial"));
            }
            return name;
        }
        Name name = this.shortName();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "shortNameOrSpecial"));
        }
        return name;
    }

    @NotNull
    public List<FqNameUnsafe> path() {
        final ArrayList<FqNameUnsafe> path = new ArrayList<FqNameUnsafe>();
        path.add(FqName.ROOT.toUnsafe());
        this.walk(new WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName2) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe$1", "segment"));
                }
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe$1", "segment"));
                }
                path.add(fqName2);
            }
        });
        ArrayList<FqNameUnsafe> arrayList = path;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "path"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Name> pathSegments() {
        final ArrayList<Name> path = new ArrayList<Name>();
        this.walk(new WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName2) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe$2", "segment"));
                }
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe$2", "segment"));
                }
                path.add(shortName);
            }
        });
        ArrayList<Name> arrayList = path;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "pathSegments"));
        }
        return arrayList;
    }

    void walk(@NotNull WalkCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "walk"));
        }
        if (this.isRoot()) {
            return;
        }
        int pos = this.fqName.indexOf(46);
        if (pos < 0) {
            if (this.parent == null) {
                this.parent = FqName.ROOT.toUnsafe();
            }
            if (this.shortName == null) {
                this.shortName = Name.guess(this.fqName);
            }
            callback.segment(this.shortName, this);
            return;
        }
        Name firstSegment = Name.guess(this.fqName.substring(0, pos));
        FqNameUnsafe last = new FqNameUnsafe(firstSegment.asString(), FqName.ROOT.toUnsafe(), firstSegment);
        callback.segment(firstSegment, last);
        while (true) {
            Name shortName;
            int next;
            if ((next = this.fqName.indexOf(46, pos + 1)) < 0) {
                if (this.parent == null) {
                    this.parent = last;
                }
                shortName = Name.guess(this.fqName.substring(pos + 1));
                if (this.shortName == null) {
                    this.shortName = shortName;
                }
                callback.segment(shortName, this);
                return;
            }
            shortName = Name.guess(this.fqName.substring(pos + 1, next));
            last = new FqNameUnsafe(this.fqName.substring(0, next), last, shortName);
            callback.segment(shortName, last);
            pos = next;
        }
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "firstSegmentIs"));
        }
        if (this.isRoot()) {
            return false;
        }
        List<Name> pathSegments = this.pathSegments();
        return pathSegments.get(0).equals(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "lastSegmentIs"));
        }
        if (this.isRoot()) {
            return false;
        }
        return this.shortName().equals(segment);
    }

    @NotNull
    public static FqNameUnsafe fromSegments(@NotNull List<?> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "fromSegments"));
        }
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(StringsKt.join(names, "."));
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "fromSegments"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static FqNameUnsafe topLevel(@NotNull Name shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "topLevel"));
        }
        FqNameUnsafe fqNameUnsafe = new FqNameUnsafe(shortName.asString(), FqName.ROOT.toUnsafe(), shortName);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "topLevel"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public String toString() {
        String string = this.isRoot() ? ROOT_NAME.asString() : this.fqName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe", "toString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqNameUnsafe)) {
            return false;
        }
        FqNameUnsafe that = (FqNameUnsafe)o;
        return this.fqName.equals(that.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }

    static interface WalkCallback {
        public void segment(@NotNull Name var1, @NotNull FqNameUnsafe var2);
    }
}

