/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.Charsets;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStoreKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0004\u0006\u0003\u0011\tQ!\u0001E\u0005\u000b\u0005!\u0019!B\u0001\t\t\u0015\tAQA\u0003\u0002\u0011%)\u0011\u0001b\u0002\u0006\u0003!UQ!\u0001E\t\u000b\u0005!A\u0001B\u001a\r\u0001A\u0015\u0012$\u0001M\u0001;\u0003\u0015R\u0005\u0003\u0003\u0014\u0011\u0005i\u0011\u0001g\u0001\u001a\u0007!\u0011Q\"\u0001M\u0003K1!1\u0003C\u0002\u000e\u0003a\u001d\u0011d\u0001\u0005\u0005\u001b\u0005A*!G\u0002\t\n5\t\u0001$B\u0013\t\tMAY!D\u0001\u0019\u000be\u0019\u0001\u0002B\u0007\u00021\u000b)c\u0002B\n\t\r5\u0011A\u0012\u0001M\u00033\rAi!D\u0001\u0019\u000fe!\u0001rB\u0007\u0003\u0019\u0003A*!J\u0014\u0005'!AQ\"\u0001\r\b3\u0011A\t\"\u0004\u0002\r\u0002a\u0015\u0011d\u0001\u0005\n\u001b\u0005Ar!G\u0002\t\u00145\t\u0001DC\r\u0004\u0011+i\u0011\u0001G\u0004\u001a\u0007!YQ\"\u0001\r\u000b3\rA9\"D\u0001\u0019\u000fe\u0019\u0001\u0002D\u0007\u00021)IR\u0001B\u0001\t\u001a5\u0011A\u0012\u0001M\u0003KW\"1\u0003C\u0007\u000e\u0003a9\u0011\u0004\u0002E\u000e\u001b\ta\t\u0001'\u0002\u001a\u0007!IQ\"\u0001\r\b3\rA\u0019\"D\u0001\u0019\u0015e\u0019\u0001RC\u0007\u00021\u001dI2\u0001C\u0006\u000e\u0003aQ\u0011$\u0002\u0003\u0002\u0011/i!\u0001$\u0001\u0019\u001deIA!\u0001\u0005\r\u001b\u0019I1!\u0003\u0002\r\u0002a\u0015A\u0012\u0001M\u000f3%!\u0011\u0001#\u0007\u000e\r%\u0019\u0011B\u0001G\u00011\u000ba\t\u0001'\bR\u0007\u0005Aq\"\n\u0005\u0005'!}Q\"\u0001\r\b3\rAI\"D\u0001\u0019\u0006\u0015rAa\u0005\u0005\u0011\u001b\u0005A\u001a!\u0007\u0003\t\"5\u0011A\u0012\u0001M\u00033\u0011A\u0011#\u0004\u0002\r\u0002a\u0015Q%\u0006\u0003\u0014\u0011Gi\u0011\u0001G\u0004\u001a\u0007!eQ\"\u0001M\u00033\u0011A\t#\u0004\u0002\r\u0002a\u0015\u0011d\u0001\u0005\u0013\u001b\u0005Ar!G\u0002\t#5\t\u0001D\u0003"}, strings={"Lorg/jetbrains/keychain/OSXKeychainLibrary;", "Lcom/sun/jna/Library;", "CFRelease", "", "cf", "Lcom/sun/jna/Pointer;", "CFStringGetCharacterAtIndex", "", "theString", "idx", "", "CFStringGetLength", "SecCopyErrorMessageString", "status", "", "reserved", "SecKeychainAddGenericPassword", "keychain", "serviceNameLength", "serviceName", "", "accountNameLength", "accountName", "passwordLength", "passwordData", "itemRef", "SecKeychainFindGenericPassword", "keychainOrArray", "", "", "(Lcom/sun/jna/Pointer;I[BI[B[I[Lcom/sun/jna/Pointer;[Lcom/sun/jna/Pointer;)I", "SecKeychainItemDelete", "SecKeychainItemFreeContent", "attrList", "data", "SecKeychainItemModifyContent", "length", "Companion"}, moduleName="settings-repository")
public interface OSXKeychainLibrary
extends Library {
    public static final Companion Companion = org.jetbrains.keychain.OSXKeychainLibrary$Companion.INSTANCE;

    public int SecKeychainAddGenericPassword(@Nullable Pointer var1, int var2, @NotNull byte[] var3, int var4, @NotNull byte[] var5, int var6, @NotNull byte[] var7, @Nullable Pointer var8);

    public int SecKeychainItemModifyContent(@NotNull Pointer var1, @Nullable Pointer var2, int var3, @NotNull byte[] var4);

    public int SecKeychainFindGenericPassword(@Nullable Pointer var1, int var2, @NotNull byte[] var3, int var4, @NotNull byte[] var5, @Nullable int[] var6, @Nullable Pointer[] var7, @Nullable Pointer[] var8);

    public int SecKeychainItemDelete(@NotNull Pointer var1);

    @Nullable
    public Pointer SecCopyErrorMessageString(int var1, @Nullable Pointer var2);

    public long CFStringGetLength(@NotNull Pointer var1);

    public char CFStringGetCharacterAtIndex(@NotNull Pointer var1, long var2);

    public void CFRelease(@NotNull Pointer var1);

    public void SecKeychainItemFreeContent(@Nullable Pointer var1, @Nullable Pointer var2);

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0011\u0011)\u0011\u0001B\u0001\u0006\u0003!IQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0012\u0004\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)3\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001DB\u0013\f\u0011\u001bi\u0011\u0001\u0007\u0003\u001a\u0007!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u000b\u0015b\u0001\u0012C\u0007\u0003\u0019\u0003AR!G\u0002\t\u000f5\t\u0001tB\r\u0004\u0011!i\u0011\u0001G\u0003&!\u0011\t\u0001\"C\u0007\u00021\u0011I2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005AR!G\u0002\t\u00145\t\u0001DC\u0013\u0015\t\u0005A\u0011\"D\u0001\u0019\te\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003a)\u0011d\u0001E\u000b\u001b\u0005Az!G\u0002\t\u00175\t\u0001DB\u0013\u0010\u0011%i\u0011\u0001\u0007\u0003\u001a\u0007!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u000be\u0019\u0001RC\u0007\u00021/)s\u0002C\u0005\u000e\u0003a!\u0011d\u0001\u0005\b\u001b\u0005Az!G\u0002\t\u00115\t\u0001$B\r\u0004\u0011+i\u0011\u0001G\u0003*\u0015\u0011\t\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/jetbrains/keychain/OSXKeychainLibrary$Companion;", "", "()V", "LIBRARY", "Lorg/jetbrains/keychain/OSXKeychainLibrary;", "getLIBRARY", "()Lorg/jetbrains/keychain/OSXKeychainLibrary;", "checkForError", "", "message", "", "code", "", "deleteGenericPassword", "serviceName", "", "accountName", "findGenericPassword", "saveGenericPassword", "passwordBuffer", "Ljava/nio/ByteBuffer;", "password", "passwordSize", ""}, moduleName="settings-repository")
    public static final class Companion {
        private static final OSXKeychainLibrary LIBRARY;
        public static final Companion INSTANCE;

        private final OSXKeychainLibrary getLIBRARY() {
            return LIBRARY;
        }

        public final void saveGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName, @NotNull char[] password) {
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            ByteBuffer byteBuffer = Charsets.getUTF_8().encode(CharBuffer.wrap(password));
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Charsets.UTF_8.encode(CharBuffer.wrap(password))");
            this.saveGenericPassword(serviceName, accountName, byteBuffer);
        }

        public final void saveGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName, @NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            ByteBuffer byteBuffer = Charsets.getUTF_8().encode(password);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Charsets.UTF_8.encode(password)");
            this.saveGenericPassword(serviceName, accountName, byteBuffer);
        }

        private final void saveGenericPassword(byte[] serviceName, String accountName, ByteBuffer passwordBuffer) {
            byte[] passwordData;
            int passwordDataSize = passwordBuffer.limit();
            if (passwordBuffer.hasArray() && passwordBuffer.arrayOffset() == 0) {
                byte[] byArray = passwordBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"passwordBuffer.array()");
                passwordData = byArray;
            } else {
                passwordData = new byte[passwordDataSize];
                passwordBuffer.get(passwordData);
            }
            this.saveGenericPassword(serviceName, accountName, passwordData, passwordDataSize);
        }

        @Nullable
        public final String findGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName) {
            byte[] $receiver;
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            byte[] accountNameBytes = StringsKt.toByteArray$default((String)accountName, null, (int)1);
            int[] passwordSize = new int[1];
            Pointer[] passwordData = new Pointer[]{null};
            byte[] byArray = serviceName;
            Pointer pointer = null;
            OSXKeychainLibrary oSXKeychainLibrary = this.getLIBRARY();
            String string = "find";
            Companion companion = this;
            int n = $receiver.length;
            $receiver = accountNameBytes;
            byte[] byArray2 = serviceName;
            int n2 = $receiver.length;
            companion.checkForError(string, DefaultImpls.SecKeychainFindGenericPassword$default(oSXKeychainLibrary, pointer, n, byArray2, n2, accountNameBytes, passwordSize, passwordData, null, 128));
            Pointer pointer2 = passwordData[0];
            if (pointer2 == null) {
                return null;
            }
            Pointer pointer3 = pointer2;
            byte[] byArray3 = pointer3.getByteArray(0L, passwordSize[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"pointer.getByteArray(0, passwordSize[0])");
            String result = StringsKt.String((byte[])byArray3);
            this.getLIBRARY().SecKeychainItemFreeContent(null, pointer3);
            return result;
        }

        private final void saveGenericPassword(byte[] serviceName, String accountName, byte[] password, int passwordSize) {
            byte[] $receiver;
            byte[] accountNameBytes = StringsKt.toByteArray$default((String)accountName, null, (int)1);
            Pointer[] itemRef = new Pointer[]{null};
            byte[] byArray = serviceName;
            Pointer pointer = null;
            OSXKeychainLibrary oSXKeychainLibrary = this.getLIBRARY();
            String string = "find (for save)";
            Companion companion = this;
            int n = $receiver.length;
            $receiver = accountNameBytes;
            byte[] byArray2 = serviceName;
            int n2 = $receiver.length;
            companion.checkForError(string, oSXKeychainLibrary.SecKeychainFindGenericPassword(pointer, n, byArray2, n2, accountNameBytes, null, null, itemRef));
            Pointer pointer2 = itemRef[0];
            if (pointer2 == null) {
                byte[] $receiver2;
                byte[] $i$f$size = serviceName;
                pointer = null;
                oSXKeychainLibrary = this.getLIBRARY();
                string = "save (new)";
                companion = this;
                n = $receiver2.length;
                $receiver2 = accountNameBytes;
                byArray2 = serviceName;
                n2 = $receiver2.length;
                companion.checkForError(string, DefaultImpls.SecKeychainAddGenericPassword$default(oSXKeychainLibrary, pointer, n, byArray2, n2, accountNameBytes, passwordSize, password, null, 128));
            } else {
                this.checkForError("save (update)", this.getLIBRARY().SecKeychainItemModifyContent(pointer2, null, passwordSize, password));
                this.getLIBRARY().CFRelease(pointer2);
            }
        }

        public final void deleteGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName) {
            byte[] $receiver;
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Pointer[] itemRef = new Pointer[]{null};
            byte[] accountNameBytes = StringsKt.toByteArray$default((String)accountName, null, (int)1);
            byte[] byArray = serviceName;
            Pointer pointer = null;
            OSXKeychainLibrary oSXKeychainLibrary = this.getLIBRARY();
            String string = "find (for delete)";
            Companion companion = this;
            int n = $receiver.length;
            $receiver = accountNameBytes;
            byte[] byArray2 = serviceName;
            int n2 = $receiver.length;
            companion.checkForError(string, oSXKeychainLibrary.SecKeychainFindGenericPassword(pointer, n, byArray2, n2, accountNameBytes, null, null, itemRef));
            Pointer pointer2 = itemRef[0];
            if (pointer2 != null) {
                this.checkForError("delete", this.getLIBRARY().SecKeychainItemDelete(pointer2));
                this.getLIBRARY().CFRelease(pointer2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void checkForError(@NotNull String message, int code) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            if (code != 0 && code != -25300) {
                Pointer translated = this.getLIBRARY().SecCopyErrorMessageString(code, null);
                StringBuilder builder = new StringBuilder(message).append(": ");
                if (translated == null) {
                    builder.append(code);
                } else {
                    void $receiver;
                    char[] buf = new char[(int)this.getLIBRARY().CFStringGetLength(translated)];
                    int n = 0;
                    char[] cArray = buf;
                    int n2 = ((void)$receiver).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            buf[i] = this.getLIBRARY().CFStringGetCharacterAtIndex(translated, (long)i);
                            if (i == n2) break;
                            ++i;
                        }
                    }
                    this.getLIBRARY().CFRelease(translated);
                    builder.append(buf).append(" (").append(code).append(')');
                }
                CredentialsStoreKt.getLOG().error(builder.toString());
            }
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
            Object object = Native.loadLibrary((String)"Security", OSXKeychainLibrary.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.keychain.OSXKeychainLibrary");
            }
            LIBRARY = (OSXKeychainLibrary)object;
        }
    }

    @KotlinInterfaceDefaultImpls(version={1, 0, 0})
    @KotlinSyntheticClass(version={1, 0, 0}, abiVersion=32, moduleName="settings-repository")
    public static final class DefaultImpls {
        public static /* synthetic */ int SecKeychainAddGenericPassword$default(OSXKeychainLibrary oSXKeychainLibrary, Pointer pointer, int n, byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, Pointer pointer2, int n4) {
            if ((n4 & 0x80) != 0) {
                pointer2 = null;
            }
            return oSXKeychainLibrary.SecKeychainAddGenericPassword(pointer, n, byArray, n2, byArray2, n3, byArray3, pointer2);
        }

        public static /* synthetic */ int SecKeychainFindGenericPassword$default(OSXKeychainLibrary oSXKeychainLibrary, Pointer pointer, int n, byte[] byArray, int n2, byte[] byArray2, int[] nArray, Pointer[] pointerArray, Pointer[] pointerArray2, int n3) {
            if ((n3 & 0x20) != 0) {
                nArray = null;
            }
            if ((n3 & 0x40) != 0) {
                pointerArray = null;
            }
            if ((n3 & 0x80) != 0) {
                pointerArray2 = null;
            }
            return oSXKeychainLibrary.SecKeychainFindGenericPassword(pointer, n, byArray, n2, byArray2, nArray, pointerArray, pointerArray2);
        }
    }
}

