/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\tMb\u0001!G\u0001\u0019\u0002\u0015bAa\u0003\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002&\u001d\u0011Y\u0001\u0002B\u0007\u00021\u0007I2\u0001#\u0003\u000e\u0003a\u0015\u0011$\u0002\u0003\u0002\u0011\ri!\u0001$\u0001\u0019\b\u0015BAa\u0005\u0005\u0006\u001b\u0005A\u001a!G\u0002\t\f5\t\u0001D\u0002"}, strings={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "", "messageParent", "Ljava/awt/Container;", "checkUrl", "uriString", "isValidRepository", "file", "Ljava/io/File;"}, moduleName="settings-repository")
public interface RepositoryService {
    public boolean checkUrl(@NotNull String var1, @Nullable Container var2);

    public boolean checkFileRepo(@NotNull String var1, @NotNull Container var2);

    public boolean isValidRepository(@NotNull File var1);

    @KotlinInterfaceDefaultImpls(version={1, 0, 0})
    @KotlinSyntheticClass(version={1, 0, 0}, abiVersion=32, moduleName="settings-repository")
    public static final class DefaultImpls {
        public static boolean checkUrl(@NotNull RepositoryService $this, @Nullable String uriString, Container messageParent) {
            boolean isFile;
            Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
            URIish uri = new URIish(uriString);
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                isFile = true;
            } else {
                boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
            }
            return messageParent == null || !isFile || $this.checkFileRepo(uriString, messageParent);
        }

        public static /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n) {
            if ((n & 2) != 0) {
                container = null;
            }
            return repositoryService.checkUrl(string, container);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean checkFileRepo(@NotNull RepositoryService $this, @NotNull String url, Container messageParent) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
            String suffix = "/" + ".git";
            File file = new File(StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2) ? StringsKt.substring((String)url, (int)0, (int)(CollectionsKt.length((CharSequence)url) - CollectionsKt.length((CharSequence)suffix))) : url);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    Messages.showErrorDialog((Component)messageParent, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                    return false;
                }
                if ($this.isValidRepository(file)) {
                    return true;
                }
            } else if (!file.isAbsolute()) {
                Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]), (String)"");
                return false;
            }
            if (Messages.showYesNoDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.dialog.message", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                try {
                    GitExKt.createBareRepository(file);
                    return true;
                }
                catch (IOException e) {
                    void $receiver;
                    Object[] objectArray;
                    Throwable throwable = e;
                    int n = 0;
                    Object[] objectArray2 = objectArray = new Object[1];
                    String string = "init.failed.message";
                    Component component = messageParent;
                    String string2 = $receiver.getMessage();
                    objectArray[n] = string2;
                    Messages.showErrorDialog((Component)component, (String)IcsBundleKt.icsMessage(string, objectArray2), (String)IcsBundleKt.icsMessage("init.failed.title", new Object[0]));
                    return false;
                }
            }
            return false;
        }
    }
}

